/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage.j2d;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.sis.coverage.Category;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.internal.coverage.j2d.ColorModelFactory;
import org.apache.sis.internal.coverage.j2d.ColorsForRange;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.coverage.j2d.ScaledColorSpace;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.InternationalString;

public final class ColorModelBuilder {
    public static final ColorModel NULL_COLOR_MODEL = null;
    private static final InternationalString TRANSPARENT = Vocabulary.formatInternational((short)249);
    private static final InternationalString COLOR_INDEX = Vocabulary.formatInternational((short)30);
    private static final InternationalString VISUAL = Vocabulary.formatInternational((short)221);
    private static final int MAX_VALUE = 255;
    public static final int TYPE_COMPACT = 0;
    private final boolean compact;
    public static final Function<Category, Color[]> GRAYSCALE = category -> {
        Color[] colorArray;
        if (category.isQuantitative()) {
            Color[] colorArray2 = new Color[2];
            colorArray2[0] = Color.BLACK;
            colorArray = colorArray2;
            colorArray2[1] = Color.WHITE;
        } else {
            colorArray = null;
        }
        return colorArray;
    };
    private final Function<Category, Color[]> colors;
    private ColorsForRange[] entries;
    private SampleDimension source;
    private SampleDimension target;
    private NumberRange<?> defaultRange;
    private final ColorModel inheritedColors;

    public ColorModelBuilder(Collection<Map.Entry<NumberRange<?>, Color[]>> colors, ColorModel inherited) {
        this.entries = ColorsForRange.list(colors, inherited);
        this.inheritedColors = inherited;
        this.colors = GRAYSCALE;
        for (Map.Entry<NumberRange<?>, Color[]> entry : colors) {
            NumberRange<?> range = entry.getKey();
            if (!(range.getMinDouble() < 0.0) && !(range.getMaxDouble() >= 256.0)) continue;
            this.compact = true;
            return;
        }
        this.compact = false;
    }

    public ColorModelBuilder(Function<Category, Color[]> colors, ColorModel inherited, boolean compact) {
        this.colors = colors != null ? colors : GRAYSCALE;
        this.inheritedColors = inherited;
        this.compact = compact;
    }

    private void checkInitializationStatus(boolean initialized) {
        if (this.entries != null != initialized) {
            throw new IllegalStateException(Errors.format(initialized ? (short)189 : 188, this.getClass()));
        }
    }

    private static boolean isAlreadyScaled(NumberRange<?> range) {
        return range.getMinDouble(true) == 0.0 && range.getMaxDouble(true) == 255.0;
    }

    public boolean initialize(SampleModel model, SampleDimension source) {
        this.checkInitializationStatus(false);
        if (source != null) {
            this.source = source;
            List<Category> categories = source.getCategories();
            if (!categories.isEmpty()) {
                boolean isUndefined = true;
                boolean missingNodata = true;
                ColorsForRange[] entries = new ColorsForRange[categories.size()];
                for (int i = 0; i < entries.length; ++i) {
                    ColorsForRange range = new ColorsForRange(categories.get(i), this.colors, this.inheritedColors);
                    isUndefined &= range.isUndefined();
                    missingNodata &= range.isData;
                    entries[i] = range;
                }
                if (!isUndefined) {
                    if (missingNodata && (model == null || !ImageUtilities.isIntegerType(model))) {
                        int count = entries.length;
                        entries = Arrays.copyOf(entries, count + 1);
                        entries[count] = new ColorsForRange((CharSequence)TRANSPARENT, NumberRange.create(Float.class, Float.valueOf(Float.NaN)), null, false, this.inheritedColors);
                    }
                    this.entries = entries;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean initialize(SampleModel source, int band) {
        this.checkInitializationStatus(false);
        if (ImageUtilities.isIntegerType(source)) {
            long minimum = 0L;
            long maximum = Numerics.bitmask(source.getSampleSize(band)) - 1L;
            if (!ImageUtilities.isUnsignedType(source)) {
                minimum = (maximum >>>= 1) ^ 0xFFFFFFFFFFFFFFFFL;
            }
            this.initialize(minimum, maximum);
            return true;
        }
        return false;
    }

    public boolean initialize(ColorModel source) {
        this.checkInitializationStatus(false);
        if (source != null) {
            ColorSpace cs = source.getColorSpace();
            if (cs instanceof ScaledColorSpace) {
                ScaledColorSpace scs = (ScaledColorSpace)cs;
                this.initialize(scs.offset, scs.maximum, source.getTransferType());
                return true;
            }
            if (ImageUtilities.isIntegerType(source.getTransferType())) {
                long maximum = Numerics.bitmask(source.getPixelSize()) - 1L;
                long minimum = 0L;
                if (source instanceof IndexColorModel) {
                    IndexColorModel indexed = (IndexColorModel)source;
                    int t = indexed.getMapSize();
                    if ((long)t <= maximum) {
                        maximum = (long)t - 1L;
                    }
                    if ((t = indexed.getTransparentPixel()) == 0) {
                        minimum = 1L;
                    }
                }
                if (minimum < maximum) {
                    this.initialize(minimum, maximum);
                    return true;
                }
            }
        }
        return false;
    }

    public void initialize(double minimum, double maximum, int dataType) {
        this.checkInitializationStatus(false);
        ArgumentChecks.ensureFinite("minimum", minimum);
        ArgumentChecks.ensureFinite("maximum", maximum);
        this.defaultRange = ImageUtilities.isIntegerType(dataType) ? NumberRange.create(Math.round(minimum), true, Math.round(maximum), true) : NumberRange.create(minimum, true, maximum, true);
        this.applyDefaultRange();
    }

    public void initialize(long minimum, long maximum) {
        this.checkInitializationStatus(false);
        this.defaultRange = NumberRange.create(minimum, true, maximum, true);
        this.applyDefaultRange();
    }

    private void applyDefaultRange() {
        SampleDimension.Builder builder = new SampleDimension.Builder().setName((CharSequence)VISUAL);
        if (this.compact) {
            NumberRange<Integer> samples = NumberRange.create(1, true, 255, true);
            builder.setBackground((CharSequence)TRANSPARENT, 0).addQuantitative((CharSequence)COLOR_INDEX, samples, this.defaultRange);
        } else {
            builder.addQuantitative((CharSequence)COLOR_INDEX, this.defaultRange, ColorModelBuilder.identity(), null);
        }
        this.target = builder.build();
        this.source = this.target.forConvertedValues(true);
        List<Category> categories = this.target.getCategories();
        ColorsForRange[] entries = new ColorsForRange[categories.size()];
        for (int i = 0; i < entries.length; ++i) {
            Category category = categories.get(i);
            ColorsForRange range = new ColorsForRange(category.forConvertedValues(true), this.colors, this.inheritedColors);
            range.sampleRange = category.getSampleRange();
            entries[i] = range;
        }
        this.entries = entries;
    }

    public void rescaleMainRange(ColorModel original) {
        ColorSpace cs;
        this.checkInitializationStatus(true);
        if (original != null && (cs = original.getColorSpace()) instanceof ScaledColorSpace) {
            ScaledColorSpace scs = (ScaledColorSpace)cs;
            double minimum = scs.offset;
            double maximum = scs.maximum;
            ColorsForRange widest = null;
            double widestSpan = 0.0;
            for (ColorsForRange entry : this.entries) {
                double span = Math.min(entry.sampleRange.getMaxDouble(), maximum) - Math.max(entry.sampleRange.getMinDouble(), minimum);
                if (!(span > widestSpan)) continue;
                widestSpan = span;
                widest = entry;
            }
            this.defaultRange = NumberRange.create(minimum, true, maximum, false);
            if (widest != null && widestSpan != widest.sampleRange.getSpan()) {
                widest.sampleRange = this.defaultRange;
                this.target = null;
            }
        }
    }

    private void compact() {
        Object[] entries;
        block23: {
            if (this.target != null) {
                return;
            }
            entries = this.entries;
            if (this.source != null) {
                this.target = this.source.forConvertedValues(false);
                if (this.target.getSampleRange().filter(ColorModelBuilder::isAlreadyScaled).isPresent()) {
                    int i;
                    if (this.target == this.source) {
                        return;
                    }
                    HashMap mapper = new HashMap();
                    for (Category category : this.target.getCategories()) {
                        if (mapper.put(category.forConvertedValues(true).getSampleRange(), category.getSampleRange()) == null) continue;
                        break block23;
                    }
                    NumberRange[] ranges = new NumberRange[entries.length];
                    for (i = 0; i < entries.length; ++i) {
                        ranges[i] = (NumberRange)mapper.remove(((ColorsForRange)entries[i]).sampleRange);
                        if (ranges[i] != null) {
                            continue;
                        }
                        break block23;
                    }
                    for (i = 0; i < entries.length; ++i) {
                        ((ColorsForRange)entries[i]).sampleRange = ranges[i];
                    }
                    return;
                }
            }
        }
        Arrays.sort(entries);
        double span = 0.0;
        int lower = 0;
        int deferred = 0;
        int count = entries.length;
        NumberRange<Object> themes = null;
        HashMap<NumberRange<Integer>, Object> mapper = new HashMap<NumberRange<Integer>, Object>();
        SampleDimension.Builder builder = new SampleDimension.Builder();
        for (int i = 0; i < count; ++i) {
            Object entry = entries[i];
            NumberRange<Object> sourceRange = ((ColorsForRange)entry).sampleRange;
            if (!((ColorsForRange)entry).isData) {
                NumberRange<Integer> targetRange;
                if (lower >= 255) {
                    throw new IllegalArgumentException(Resources.format((short)62));
                }
                if (mapper.put(targetRange = NumberRange.create(lower++, true, lower, false), entry) != null) continue;
                double value = sourceRange.getMinDouble();
                if (Double.isNaN(value)) {
                    builder.mapQualitative(((ColorsForRange)entry).name(), targetRange, (float)value);
                    continue;
                }
                if (value == ((ColorsForRange)entry).sampleRange.getMaxDouble()) {
                    sourceRange = NumberRange.create(value - 0.5, true, value + 0.5, false);
                }
                builder.addQuantitative(((ColorsForRange)entry).name(), targetRange, sourceRange);
                themes = themes != null ? themes.unionAny(sourceRange) : sourceRange;
                continue;
            }
            double s = sourceRange.getSpan();
            if (s > 0.0) {
                span += s;
                System.arraycopy(entries, deferred, entries, deferred + 1, i - deferred);
                entries[deferred++] = entry;
                continue;
            }
            System.arraycopy(entries, i + 1, entries, i, --count - i);
            entries[count] = null;
        }
        if (deferred == 0 && themes != null) {
            if (this.defaultRange == null) {
                this.defaultRange = NumberRange.create(0, true, 32768, false);
            }
            for (NumberRange<?> sourceRange : this.defaultRange.subtractAny(themes)) {
                span += sourceRange.getSpan();
                ColorsForRange[] tmp = (ColorsForRange[])Arrays.copyOf(entries, ++count);
                System.arraycopy(entries, deferred++, tmp, deferred, count - deferred);
                tmp[deferred - 1] = new ColorsForRange(null, sourceRange, null, true, null);
                entries = tmp;
            }
        }
        entries = (ColorsForRange[])ArraysExt.resize(entries, count);
        this.entries = entries;
        int base = lower;
        double toIndexRange = (double)(256 - base) / span;
        span = 0.0;
        for (int i = 0; i < deferred; ++i) {
            Object entry = entries[i];
            int upper = Math.toIntExact(Math.round((span += ((ColorsForRange)entry).sampleRange.getSpan()) * toIndexRange) + (long)base);
            if (upper <= lower) {
                throw new IllegalArgumentException(Resources.format((short)62));
            }
            NumberRange<Integer> samples = NumberRange.create(lower, true, upper, false);
            if (mapper.put(samples, entry) == null) {
                builder.addQuantitative(((ColorsForRange)entry).name(), samples, ((ColorsForRange)entry).sampleRange);
            }
            lower = upper;
        }
        if (this.source != null) {
            builder.setName(this.source.getName());
        } else {
            builder.setName((CharSequence)VISUAL);
        }
        this.target = builder.build();
        for (Category category : this.target.getCategories()) {
            NumberRange<?> packed = category.getSampleRange();
            ((ColorsForRange)mapper.get(packed)).sampleRange = packed;
        }
    }

    public ColorModel createColorModel(int dataType, int numBands, int visibleBand) {
        this.checkInitializationStatus(true);
        if (this.compact) {
            this.compact();
            dataType = 0;
        }
        ArgumentChecks.ensureStrictlyPositive("numBands", numBands);
        ArgumentChecks.ensureBetween("visibleBand", 0, numBands - 1, visibleBand);
        return ColorModelFactory.createPiecewise(dataType, numBands, visibleBand, this.entries);
    }

    public MathTransform1D getSampleToIndexValues() throws NoninvertibleTransformException {
        this.checkInitializationStatus(true);
        return this.target != null ? this.target.getTransferFunction().orElseGet(ColorModelBuilder::identity).inverse() : ColorModelBuilder.identity();
    }

    private static MathTransform1D identity() {
        return (MathTransform1D)MathTransforms.identity((int)1);
    }
}

