/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature;

import java.util.Iterator;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.internal.feature.AbstractGeometry;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryType;
import org.apache.sis.internal.feature.SpatialOperationContext;
import org.apache.sis.internal.filter.sqlmm.SQLMM;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.util.Classes;
import org.apache.sis.util.NullArgumentException;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.resources.Errors;
import org.opengis.filter.DistanceOperatorName;
import org.opengis.filter.InvalidFilterValueException;
import org.opengis.filter.SpatialOperatorName;
import org.opengis.geometry.Boundary;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Geometry;
import org.opengis.geometry.TransfiniteSet;
import org.opengis.geometry.complex.Complex;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public abstract class GeometryWrapper<G>
extends AbstractGeometry
implements Geometry {
    protected GeometryWrapper() {
    }

    public abstract Geometries<G> factory();

    public abstract Object implementation();

    public OptionalInt getSRID() {
        return OptionalInt.empty();
    }

    public abstract CoordinateReferenceSystem getCoordinateReferenceSystem();

    public abstract void setCoordinateReferenceSystem(CoordinateReferenceSystem var1);

    public abstract GeneralEnvelope getEnvelope();

    public abstract DirectPosition getCentroid();

    public abstract double[] getPointCoordinates();

    public abstract double[] getAllCoordinates();

    public abstract G mergePolylines(Iterator<?> var1);

    public final boolean predicate(DistanceOperatorName type, GeometryWrapper<G> other, Quantity<Length> distance, SpatialOperationContext context) {
        GeometryWrapper[] geometries = new GeometryWrapper[]{this, other};
        try {
            if (context.transform(geometries)) {
                double dv = distance.getValue().doubleValue();
                Unit unit = ReferencingUtilities.getUnit((CoordinateReferenceSystem)context.commonCRS);
                if (unit != null) {
                    dv = distance.getUnit().getConverterToAny(unit).convert(dv);
                }
                return geometries[0].predicateSameCRS(type, geometries[1], dv);
            }
        }
        catch (IncommensurableException | TransformException | FactoryException e) {
            throw new InvalidFilterValueException(e);
        }
        return SpatialOperationContext.negativeResult(type);
    }

    public final boolean predicate(SpatialOperatorName type, GeometryWrapper<G> other, SpatialOperationContext context) {
        GeometryWrapper[] geometries = new GeometryWrapper[]{this, other};
        try {
            if (context.transform(geometries)) {
                return geometries[0].predicateSameCRS(type, geometries[1]);
            }
        }
        catch (IncommensurableException | TransformException | FactoryException e) {
            throw new InvalidFilterValueException(e);
        }
        return SpatialOperationContext.negativeResult(type);
    }

    public final Object operation(SQLMM operation) {
        assert (operation.geometryCount() == 1 && operation.maxParamCount == 1) : operation;
        Object result = this.operationSameCRS(operation, null, null);
        assert (this.isInstance(operation, result)) : result;
        return result;
    }

    public final Object operation(SQLMM operation, GeometryWrapper<G> other) throws TransformException {
        assert (operation.geometryCount() == 2 && operation.maxParamCount == 2) : operation;
        Object result = this.operationSameCRS(operation, this.toSameCRS(other), null);
        assert (this.isInstance(operation, result)) : result;
        return result;
    }

    public final Object operationWithArgument(SQLMM operation, Object argument) {
        assert (operation.geometryCount() == 1 && operation.maxParamCount == 2) : operation;
        if (argument == null && operation.minParamCount > 1) {
            throw new NullArgumentException(Errors.format((short)113, "arg1"));
        }
        Object result = this.operationSameCRS(operation, null, argument);
        assert (this.isInstance(operation, result)) : result;
        return result;
    }

    public final Object operationWithArgument(SQLMM operation, GeometryWrapper<G> other, Object argument) throws TransformException {
        assert (operation.geometryCount() == 2 && operation.maxParamCount == 3) : operation;
        if (argument == null && operation.minParamCount > 2) {
            throw new NullArgumentException(Errors.format((short)113, "arg2"));
        }
        Object result = this.operationSameCRS(operation, this.toSameCRS(other), argument);
        assert (this.isInstance(operation, result)) : result;
        return result;
    }

    private GeometryWrapper<G> toSameCRS(GeometryWrapper<G> other) throws TransformException {
        if (this.isSameCRS(other)) {
            return other;
        }
        CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem();
        return crs != null ? other.transform(crs) : this;
    }

    private boolean isInstance(SQLMM operation, Object result) {
        return result == null || operation.getReturnType(this.factory()).isInstance(result);
    }

    protected boolean predicateSameCRS(SpatialOperatorName type, GeometryWrapper<G> other) {
        throw new UnsupportedOperationException(Geometries.unsupported(type.name()));
    }

    protected boolean predicateSameCRS(DistanceOperatorName type, GeometryWrapper<G> other, double distance) {
        throw new UnsupportedOperationException(Geometries.unsupported(type.name()));
    }

    protected Object operationSameCRS(SQLMM operation, GeometryWrapper<G> other, Object argument) {
        throw new UnsupportedOperationException(Geometries.unsupported(operation.name()));
    }

    public GeometryWrapper<G> toGeometryType(GeometryType target) {
        Object geometry;
        Class<?> type = this.factory().getGeometryClass(target);
        if (type.isInstance(geometry = this.implementation())) {
            return this;
        }
        throw new UnconvertibleObjectException(Errors.format((short)7, geometry.getClass(), type));
    }

    public GeometryWrapper<G> transform(CoordinateOperation operation, boolean validate) throws FactoryException, TransformException {
        throw new UnsupportedOperationException(Geometries.unsupported("transform"));
    }

    public GeometryWrapper<G> transform(CoordinateReferenceSystem targetCRS) throws TransformException {
        if (targetCRS == null) {
            return this;
        }
        throw new UnsupportedOperationException(Geometries.unsupported("transform"));
    }

    public abstract boolean isSameCRS(GeometryWrapper<G> var1);

    public abstract String formatWKT(double var1);

    @Deprecated
    public final Geometry getMbRegion() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final DirectPosition getRepresentativePoint() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final Boundary getBoundary() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final Complex getClosure() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final boolean isSimple() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final boolean isCycle() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final double distance(Geometry geometry) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final int getDimension(DirectPosition point) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final int getCoordinateDimension() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final Set<Complex> getMaximalComplex() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final Geometry getConvexHull() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final Geometry getBuffer(double distance) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final Geometry clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Deprecated
    public final boolean contains(TransfiniteSet pointSet) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final boolean contains(DirectPosition point) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final boolean intersects(TransfiniteSet pointSet) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final boolean equals(TransfiniteSet pointSet) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final TransfiniteSet union(TransfiniteSet pointSet) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final TransfiniteSet intersection(TransfiniteSet pointSet) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final TransfiniteSet difference(TransfiniteSet pointSet) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final TransfiniteSet symmetricDifference(TransfiniteSet ps) {
        throw new UnsupportedOperationException();
    }

    public final boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(this.getClass()) && Objects.equals(((GeometryWrapper)obj).implementation(), this.implementation());
    }

    public final int hashCode() {
        return ~Objects.hashCode(this.implementation());
    }

    public final String toString() {
        Class<?> c = this.implementation().getClass();
        Class<?> e = c.getEnclosingClass();
        Object s = Classes.getShortName(e != null ? e : c);
        GeneralEnvelope envelope = this.getEnvelope();
        if (envelope != null) {
            String bbox = envelope.toString();
            s = (String)s + bbox.substring(bbox.indexOf(40));
        }
        return s;
    }
}

