/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature.jts;

import java.awt.Shape;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.sis.internal.feature.jts.Factory;
import org.apache.sis.internal.feature.jts.PackedCoordinateSequence;
import org.apache.sis.internal.feature.jts.ShapeAdapter;
import org.apache.sis.internal.referencing.j2d.AbstractShape;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

abstract class ShapeConverter {
    private static final int DIMENSION = 2;
    private static final int INITIAL_CAPACITY = 64;
    private static final int POINT = 1;
    private static final int LINESTRING = 2;
    private static final int POLYGON = 4;
    private final List<Geometry> geometries;
    private final GeometryFactory factory;
    protected final PathIterator iterator;
    protected int length;
    private int geometryType;

    ShapeConverter(GeometryFactory factory, PathIterator iterator, boolean isFloat) {
        this.iterator = iterator;
        this.geometries = new ArrayList<Geometry>();
        this.factory = factory != null ? factory : Factory.INSTANCE.factory(isFloat);
    }

    static Geometry create(GeometryFactory factory, Shape shape, double flatness) {
        if (shape instanceof ShapeAdapter) {
            return ((ShapeAdapter)((Object)shape)).geometry;
        }
        PathIterator iterator = shape.getPathIterator(null, flatness);
        ShapeConverter converter = AbstractShape.isFloat((Object)shape) ? new Float(factory, iterator) : new Double(factory, iterator);
        return converter.build();
    }

    abstract int currentSegment();

    abstract void addPoint();

    abstract PackedCoordinateSequence toSequence(boolean var1);

    private Geometry build() {
        while (!this.iterator.isDone()) {
            switch (this.currentSegment()) {
                case 0: {
                    this.flush(false);
                    this.addPoint();
                    break;
                }
                case 1: {
                    if (this.length == 0) {
                        throw new IllegalPathStateException("LINETO without previous MOVETO.");
                    }
                    this.addPoint();
                    break;
                }
                case 4: {
                    this.flush(true);
                    break;
                }
                default: {
                    throw new IllegalPathStateException("Must contain only flat segments.");
                }
            }
            this.iterator.next();
        }
        this.flush(false);
        int count = this.geometries.size();
        if (count == 1) {
            return this.geometries.get(0);
        }
        switch (this.geometryType) {
            case 0: {
                return this.factory.createEmpty(2);
            }
            default: {
                return this.factory.createGeometryCollection(GeometryFactory.toGeometryArray(this.geometries));
            }
            case 1: {
                return this.factory.createMultiPoint(GeometryFactory.toPointArray(this.geometries));
            }
            case 2: {
                return this.factory.createMultiLineString(GeometryFactory.toLineStringArray(this.geometries));
            }
            case 4: 
        }
        Geometry result = this.geometries.get(0);
        for (int i = 1; i < count; ++i) {
            result = result.symDifference(this.geometries.get(i));
        }
        return result;
    }

    private void flush(boolean isRing) {
        if (this.length != 0) {
            Point geometry;
            if (this.length == 2) {
                geometry = this.factory.createPoint((CoordinateSequence)this.toSequence(false));
                this.geometryType |= 1;
            } else if (isRing) {
                geometry = this.factory.createPolygon((CoordinateSequence)this.toSequence(true));
                this.geometryType |= 4;
            } else {
                geometry = this.factory.createLineString((CoordinateSequence)this.toSequence(false));
                this.geometryType |= 2;
            }
            this.geometries.add((Geometry)geometry);
            this.length = 0;
        }
    }

    private static final class Float
    extends ShapeConverter {
        private final float[] vertex = new float[6];
        private float[] buffer = new float[64];

        Float(GeometryFactory factory, PathIterator iterator) {
            super(factory, iterator, false);
        }

        @Override
        int currentSegment() {
            return this.iterator.currentSegment(this.vertex);
        }

        @Override
        void addPoint() {
            this.addPoint(this.vertex);
        }

        private void addPoint(float[] source) {
            if (this.length >= this.buffer.length) {
                this.buffer = Arrays.copyOf(this.buffer, this.length * 2);
            }
            System.arraycopy(source, 0, this.buffer, this.length, 2);
            this.length += 2;
        }

        @Override
        PackedCoordinateSequence toSequence(boolean close) {
            if (close && !Arrays.equals(this.buffer, 0, 2, this.buffer, this.length - 2, this.length)) {
                this.addPoint(this.buffer);
            }
            return new PackedCoordinateSequence.Float(this.buffer, this.length);
        }
    }

    private static final class Double
    extends ShapeConverter {
        private final double[] vertex = new double[6];
        private double[] buffer = new double[64];

        Double(GeometryFactory factory, PathIterator iterator) {
            super(factory, iterator, false);
        }

        @Override
        int currentSegment() {
            return this.iterator.currentSegment(this.vertex);
        }

        @Override
        void addPoint() {
            this.addPoint(this.vertex);
        }

        private void addPoint(double[] source) {
            if (this.length >= this.buffer.length) {
                this.buffer = Arrays.copyOf(this.buffer, this.length * 2);
            }
            System.arraycopy(source, 0, this.buffer, this.length, 2);
            this.length += 2;
        }

        @Override
        PackedCoordinateSequence toSequence(boolean close) {
            if (close && !Arrays.equals(this.buffer, 0, 2, this.buffer, this.length - 2, this.length)) {
                this.addPoint(this.buffer);
            }
            return new PackedCoordinateSequence.Double(this.buffer, this.length);
        }
    }
}

