/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml;

import jakarta.xml.bind.annotation.XmlTransient;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotoolkit.gml.xml.TimeIndeterminateValueType;
import org.geotoolkit.temporal.object.ISODateParser;
import org.opengis.temporal.TemporalPosition;

@XmlTransient
public abstract class AbstractTimePosition {
    protected static final Logger LOGGER = Logger.getLogger("org.geotoolkit.gml.xml");
    protected static final List<DateFormat> FORMATTERS = new ArrayList<DateFormat>();

    public TemporalPosition anyOther() {
        return null;
    }

    public abstract Date getDate();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date parseDate(String value) {
        if (value != null && !value.isEmpty()) {
            ISODateParser parser = new ISODateParser();
            try {
                return parser.parseToDate(value);
            }
            catch (NumberFormatException numberFormatException) {
                for (DateFormat df : FORMATTERS) {
                    try {
                        DateFormat dateFormat = df;
                        synchronized (dateFormat) {
                            return df.parse(value);
                        }
                    }
                    catch (ParseException ex) {
                    }
                }
                LOGGER.log(Level.WARNING, "Unable to parse date value:{0}", value);
            }
        }
        return null;
    }

    public abstract TimeIndeterminateValueType getIndeterminatePosition();

    static {
        FORMATTERS.add(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS"));
        FORMATTERS.add(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"));
        FORMATTERS.add(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        FORMATTERS.add(new SimpleDateFormat("yyyy-MM-dd"));
        FORMATTERS.add(new SimpleDateFormat("yyyy"));
    }
}

