/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.gml.xml.v321;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementRefs;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import org.apache.sis.coverage.grid.GridGeometry;
import org.geotoolkit.gml.xml.v321.AbstractGeometryType;
import org.geotoolkit.gml.xml.v321.GridEnvelopeType;
import org.geotoolkit.gml.xml.v321.GridLimitsType;
import org.geotoolkit.gml.xml.v321.ObjectFactory;
import org.geotoolkit.gml.xml.v321.RectifiedGridType;
import org.opengis.coverage.grid.Grid;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="GridType", propOrder={"rest"})
@XmlSeeAlso(value={RectifiedGridType.class})
@XmlRootElement(name="Grid")
public class GridType
extends AbstractGeometryType {
    @XmlElementRefs(value={@XmlElementRef(name="axisName", namespace="http://www.opengis.net/gml/3.2", type=JAXBElement.class), @XmlElementRef(name="limits", namespace="http://www.opengis.net/gml/3.2", type=JAXBElement.class), @XmlElementRef(name="axisLabels", namespace="http://www.opengis.net/gml/3.2", type=JAXBElement.class)})
    private List<JAXBElement<?>> rest;
    @XmlAttribute(required=true)
    @XmlSchemaType(name="positiveInteger")
    private Integer dimension;

    public GridType() {
    }

    public GridType(Grid grid) {
        this(grid, null);
    }

    public GridType(Grid grid, CoordinateReferenceSystem crs) {
        if (grid != null) {
            ObjectFactory factory = new ObjectFactory();
            this.dimension = grid.getDimension();
            GridEnvelopeType limits = new GridEnvelopeType(grid.getExtent());
            this.rest = new ArrayList();
            this.rest.add(factory.createGridTypeLimits(new GridLimitsType(limits)));
            if (grid.getAxisNames() != null) {
                this.rest.add(factory.createGridTypeAxisLabels(grid.getAxisNames()));
            } else if (crs != null) {
                ArrayList<String> axisNames = new ArrayList<String>();
                for (int i = 0; i < crs.getCoordinateSystem().getDimension(); ++i) {
                    axisNames.add(crs.getCoordinateSystem().getAxis(i).getAbbreviation());
                }
                this.rest.add(factory.createGridTypeAxisLabels(axisNames));
            }
        }
    }

    public GridType(GridGeometry gg) {
        if (gg != null) {
            ObjectFactory factory = new ObjectFactory();
            this.dimension = gg.getDimension();
            GridEnvelopeType limits = new GridEnvelopeType((GridEnvelope)gg.getExtent());
            this.rest = new ArrayList();
            this.rest.add(factory.createGridTypeLimits(new GridLimitsType(limits)));
            if (gg.isDefined(1)) {
                CoordinateSystem cs = gg.getCoordinateReferenceSystem().getCoordinateSystem();
                ArrayList<String> axisNames = new ArrayList<String>();
                for (int i = 0; i < cs.getDimension(); ++i) {
                    axisNames.add(cs.getAxis(i).getAbbreviation());
                }
                this.rest.add(factory.createGridTypeAxisLabels(axisNames));
            }
        }
    }

    public List<JAXBElement<?>> getRest() {
        if (this.rest == null) {
            this.rest = new ArrayList();
        }
        return this.rest;
    }

    public List<String> getGridAxisLabels() {
        if (this.rest != null) {
            for (JAXBElement<?> elem : this.rest) {
                Object object;
                if (!elem.getName().equals(ObjectFactory._GridTypeAxisLabels_QNAME) || !((object = elem.getValue()) instanceof List)) continue;
                List axisLabels = (List)object;
                return axisLabels;
            }
        }
        return new ArrayList<String>();
    }

    public Integer getDimension() {
        return this.dimension;
    }

    public void setDimension(Integer value) {
        this.dimension = value;
    }
}

