/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.measure.UnitConverter;
import org.apache.sis.internal.util.DoubleDouble;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.math.Fraction;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.AbstractConverter;
import org.apache.sis.measure.ConcatenatedConverter;
import org.apache.sis.measure.IdentityConverter;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.LenientComparable;
import org.apache.sis.util.StringBuilders;

final class LinearConverter
extends AbstractConverter
implements LenientComparable {
    private static final long serialVersionUID = -3759983642723729926L;
    private final double scale;
    private final double offset;
    private final double divisor;
    private volatile transient BigDecimal scale10;
    private volatile transient BigDecimal offset10;
    private volatile transient LinearConverter inverse;

    LinearConverter(double scale, double offset, double divisor) {
        this.scale = scale;
        this.offset = offset;
        this.divisor = divisor;
    }

    static AbstractConverter create(Number scale, Number offset) {
        double divisor;
        double numerator;
        double shift;
        double d = shift = offset != null ? LinearConverter.doubleValue(offset) : 0.0;
        if (scale instanceof Fraction) {
            numerator = ((Fraction)scale).numerator;
            divisor = ((Fraction)scale).denominator;
            shift *= divisor;
        } else {
            numerator = scale != null ? LinearConverter.doubleValue(scale) : 1.0;
            divisor = 1.0;
        }
        if (shift == 0.0 && numerator == divisor) {
            return IdentityConverter.INSTANCE;
        }
        LinearConverter c = new LinearConverter(numerator, shift, divisor);
        if (scale instanceof BigDecimal) {
            c.scale10 = (BigDecimal)scale;
        }
        if (offset instanceof BigDecimal) {
            c.offset10 = (BigDecimal)offset;
        }
        return c;
    }

    static LinearConverter scale(double numerator, double denominator) {
        return new LinearConverter(numerator, 0.0, denominator);
    }

    static LinearConverter offset(double numerator, double denominator) {
        return new LinearConverter(denominator, numerator, denominator);
    }

    static LinearConverter pow(UnitConverter converter, int n, boolean root) {
        double denominator;
        double numerator;
        if (converter instanceof LinearConverter) {
            LinearConverter lc = (LinearConverter)converter;
            numerator = lc.scale;
            denominator = lc.divisor;
        } else {
            numerator = converter.convert(1.0) - converter.convert(0.0);
            denominator = 1.0;
        }
        if (root) {
            switch (n) {
                case 1: {
                    break;
                }
                case 2: {
                    numerator = Math.sqrt(numerator);
                    denominator = Math.sqrt(denominator);
                    break;
                }
                case 3: {
                    numerator = Math.cbrt(numerator);
                    denominator = Math.cbrt(denominator);
                    break;
                }
                default: {
                    double r = 1.0 / (double)n;
                    numerator = Math.pow(numerator, r);
                    denominator = Math.pow(denominator, r);
                    break;
                }
            }
        } else {
            numerator = numerator == 10.0 ? MathFunctions.pow10(n) : Math.pow(numerator, n);
            denominator = denominator == 10.0 ? MathFunctions.pow10(n) : Math.pow(denominator, n);
        }
        return LinearConverter.scale(numerator, denominator);
    }

    @Override
    public boolean isLinear() {
        return this.offset == 0.0;
    }

    @Override
    public boolean isIdentity() {
        return this.scale == this.divisor && this.offset == 0.0;
    }

    final boolean almostIdentity() {
        return LinearConverter.epsilonEquals(this.scale, this.divisor) && LinearConverter.epsilonEquals(this.offset, 0.0);
    }

    @Override
    public synchronized UnitConverter inverse() {
        if (this.inverse == null) {
            this.inverse = this.isIdentity() ? this : new LinearConverter(this.divisor, -this.offset, this.scale);
            this.inverse.inverse = this;
        }
        return this.inverse;
    }

    @Override
    final Number[] coefficients() {
        Number[] c = new Number[this.scale != this.divisor ? 2 : (this.offset != 0.0 ? 1 : 0)];
        switch (c.length) {
            case 2: {
                c[1] = LinearConverter.ratio(this.scale, this.divisor);
            }
            case 1: {
                c[0] = LinearConverter.ratio(this.offset, this.divisor);
            }
        }
        return c;
    }

    private static Number ratio(double value, double divisor) {
        int denominator;
        int numerator;
        if (value != 0.0 && (double)(numerator = (int)value) == value && (double)(denominator = (int)divisor) == divisor) {
            return denominator == 1 ? Integer.valueOf(numerator) : new Fraction(numerator, denominator);
        }
        return value / divisor;
    }

    @Override
    public double convert(double value) {
        return Math.fma(value, this.scale, this.offset) / this.divisor;
    }

    @Override
    public Number convert(Number value) {
        ArgumentChecks.ensureNonNull("value", value);
        if (!this.isIdentity()) {
            if (value instanceof DoubleDouble) {
                DoubleDouble dd = (DoubleDouble)value;
                return dd.multiply(this.scale, true).add(this.offset, true).divide(this.divisor, true);
            }
            if (value instanceof BigInteger) {
                value = new BigDecimal((BigInteger)value);
            }
            if (value instanceof BigDecimal) {
                BigDecimal scale10 = this.scale10;
                BigDecimal offset10 = this.offset10;
                if (scale10 == null || offset10 == null) {
                    BigDecimal divisor = BigDecimal.valueOf(this.divisor);
                    scale10 = BigDecimal.valueOf(this.scale).divide(divisor);
                    offset10 = BigDecimal.valueOf(this.offset).divide(divisor);
                    this.scale10 = scale10;
                    this.offset10 = offset10;
                }
                value = ((BigDecimal)value).multiply(scale10).add(offset10);
            } else {
                value = this.convert(LinearConverter.doubleValue(value));
            }
        }
        return value;
    }

    @Override
    public double derivative(double value) {
        return this.scale / this.divisor;
    }

    @Override
    public UnitConverter concatenate(UnitConverter converter) {
        double otherDivisor;
        double otherOffset;
        double otherScale;
        ArgumentChecks.ensureNonNull("converter", converter);
        if (converter.isIdentity()) {
            return this;
        }
        if (this.isIdentity()) {
            return converter;
        }
        if (converter instanceof LinearConverter) {
            LinearConverter lc = (LinearConverter)converter;
            otherScale = lc.scale;
            otherOffset = lc.offset;
            otherDivisor = lc.divisor;
        } else if (converter.isLinear()) {
            otherOffset = converter.convert(0.0);
            otherScale = converter.convert(1.0) - otherOffset;
            otherDivisor = 1.0;
        } else {
            return new ConcatenatedConverter(converter, this);
        }
        otherOffset = otherOffset * this.scale + otherDivisor * this.offset;
        if ((otherScale *= this.scale) != 0.0 || otherOffset != 0.0 || (otherDivisor *= this.divisor) != 0.0) {
            double cf;
            double f = 1.0;
            do {
                cf = f;
            } while (otherScale % (f *= 10.0) == 0.0 && otherOffset % f == 0.0 && otherDivisor % f == 0.0);
            otherScale /= cf;
            otherOffset /= cf;
            otherDivisor /= cf;
        }
        if (otherOffset == 0.0 && otherScale == otherDivisor) {
            return IdentityConverter.INSTANCE;
        }
        return new LinearConverter(otherScale, otherOffset, otherDivisor);
    }

    public int hashCode() {
        return Long.hashCode(Double.doubleToLongBits(this.scale) + 31L * (Double.doubleToLongBits(this.offset) + 37L * Double.doubleToLongBits(this.divisor)));
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof LinearConverter) {
            LinearConverter o = (LinearConverter)other;
            return Numerics.equals(this.scale, o.scale) && Numerics.equals(this.offset, o.offset) && Numerics.equals(this.divisor, o.divisor);
        }
        if (other instanceof IdentityConverter) {
            return this.isIdentity();
        }
        return false;
    }

    @Override
    public boolean equals(Object other, ComparisonMode mode) {
        if (mode.isApproximate()) {
            if (other instanceof LinearConverter) {
                return this.equivalent((LinearConverter)other);
            }
            if (other instanceof IdentityConverter) {
                return this.almostIdentity();
            }
            return false;
        }
        return this.equals(other);
    }

    final boolean equivalent(LinearConverter other) {
        return LinearConverter.epsilonEquals(this.scale * other.divisor, other.scale * this.divisor) && LinearConverter.epsilonEquals(this.offset * other.divisor, other.offset * this.divisor);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder().append("y\u00a0=\u00a0");
        if (this.offset != 0.0) {
            buffer.append('(');
        }
        if (this.scale != 1.0) {
            StringBuilders.trimFractionalPart(buffer.append(this.scale));
            buffer.append('\u22c5');
        }
        buffer.append('x');
        if (this.offset != 0.0) {
            StringBuilders.trimFractionalPart(buffer.append("\u00a0+\u00a0").append(this.offset));
            buffer.append(')');
        }
        if (this.divisor != 1.0) {
            StringBuilders.trimFractionalPart(buffer.append('\u2215').append(this.divisor));
        }
        return buffer.toString();
    }
}

