/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.temporal.object;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.Unit;
import javax.measure.quantity.Time;
import org.apache.sis.measure.Units;
import org.apache.sis.util.SimpleInternationalString;
import org.geotoolkit.temporal.object.DefaultDateAndTime;
import org.geotoolkit.temporal.object.DefaultDuration;
import org.geotoolkit.temporal.object.DefaultPeriodDuration;
import org.geotoolkit.temporal.object.DefaultTemporalCoordinate;
import org.geotoolkit.temporal.object.ISODateParser;
import org.geotoolkit.temporal.reference.DefaultTemporalCoordinateSystem;
import org.geotoolkit.util.StringUtilities;
import org.geotoolkit.util.collection.UnSynchronizedCache;
import org.opengis.temporal.CalendarDate;
import org.opengis.temporal.DateAndTime;
import org.opengis.temporal.Duration;
import org.opengis.temporal.JulianDate;
import org.opengis.temporal.OrdinalEra;
import org.opengis.temporal.OrdinalPosition;
import org.opengis.temporal.TemporalCoordinate;
import org.opengis.temporal.TemporalReferenceSystem;
import org.opengis.util.InternationalString;

public final class TemporalUtilities {
    private static final Logger LOGGER = Logger.getLogger("org.geotoolkit.temporal.object");
    private static final String DEFAULT_TIMEZONE = TimeZone.getDefault().getID();
    public static final Unit<Time> MONTH_UNIT = Units.DAY.multiply(30.0);
    public static final Unit<Time> YEAR_UNIT = Units.DAY.multiply(365.0);
    private static final List<String> FR_POOL = new ArrayList<String>(){

        @Override
        public int indexOf(Object o) {
            String candidate = (String)o;
            int n = FR_POOL.size();
            for (int i = 0; i < n; ++i) {
                if (!FR_POOL.get(i).equalsIgnoreCase(candidate)) continue;
                return i;
            }
            return -1;
        }
    };
    private static final SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat sdf3;
    private static final SimpleDateFormat sdf4;
    private static final SimpleDateFormat sdf5;
    private static final SimpleDateFormat sdf6;
    private static final SimpleDateFormat sdf7;
    private static final Map<String, TimeZone> TIME_ZONES;

    private TemporalUtilities() {
    }

    public static Date getDateFromString(String dateString) throws ParseException {
        return TemporalUtilities.getDateFromString(dateString, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getDateFromString(String dateString, boolean noGMTO) throws ParseException {
        boolean defaultTimezone = false;
        int indexT = dateString.indexOf(84);
        if (indexT > 0) {
            Object timezoneStr;
            int tzIndex = dateString.lastIndexOf(43);
            if (tzIndex == -1) {
                tzIndex = dateString.lastIndexOf(45);
            }
            if (tzIndex > indexT) {
                timezoneStr = dateString.substring(tzIndex + 1);
                if (((String)timezoneStr).indexOf(58) > 0) {
                    timezoneStr = ((String)timezoneStr).replace(":", "");
                    dateString = dateString.substring(0, tzIndex + 1).concat((String)timezoneStr);
                } else if (((String)timezoneStr).length() == 2) {
                    dateString = dateString.concat("00");
                }
            } else if (dateString.charAt(dateString.length() - 1) == 'Z') {
                dateString = dateString.substring(0, dateString.length() - 1).concat("+0000");
            } else {
                defaultTimezone = true;
            }
            if (dateString.indexOf(46) > 0) {
                timezoneStr = sdf3;
                synchronized (timezoneStr) {
                    return sdf3.parse(dateString);
                }
            }
            if (defaultTimezone) {
                timezoneStr = sdf4;
                synchronized (timezoneStr) {
                    return sdf4.parse(dateString);
                }
            }
            String timezone = TemporalUtilities.getTimeZone(dateString);
            SimpleDateFormat simpleDateFormat = sdf1;
            synchronized (simpleDateFormat) {
                sdf1.setTimeZone(TIME_ZONES.get(timezone));
                return sdf1.parse(dateString);
            }
        }
        if (dateString.indexOf(45) > 0) {
            if (noGMTO) {
                SimpleDateFormat simpleDateFormat = sdf6;
                synchronized (simpleDateFormat) {
                    return sdf6.parse(dateString);
                }
            }
            SimpleDateFormat simpleDateFormat = sdf2;
            synchronized (simpleDateFormat) {
                return sdf2.parse(dateString);
            }
        }
        throw new ParseException("Unable to parse given string as a date with regular date formats", 0);
    }

    public static String getTimeZone(String dateString) {
        if (dateString.charAt(dateString.length() - 1) == 'Z') {
            return "GMT+0";
        }
        int index = dateString.lastIndexOf(43);
        if (index == -1) {
            index = dateString.lastIndexOf(45);
        }
        if (index > dateString.indexOf(84)) {
            return "GMT" + dateString.substring(index);
        }
        return DEFAULT_TIMEZONE;
    }

    public static long getTimeInMillis(String periodDuration) {
        long time = 0L;
        if (periodDuration.startsWith("P")) {
            if ((periodDuration = periodDuration.substring(1)).indexOf(89) != -1) {
                int nbYear = Integer.parseInt(periodDuration.substring(0, periodDuration.indexOf(89)));
                time += (long)nbYear * 31536000000L;
                periodDuration = periodDuration.substring(periodDuration.indexOf(89) + 1);
            }
            if (periodDuration.indexOf(77) != -1 && (periodDuration.indexOf(84) == -1 || periodDuration.indexOf(84) > periodDuration.indexOf(77))) {
                int nbMonth = Integer.parseInt(periodDuration.substring(0, periodDuration.indexOf(77)));
                time += (long)nbMonth * 2628000000L;
                periodDuration = periodDuration.substring(periodDuration.indexOf(77) + 1);
            }
            if (periodDuration.indexOf(87) != -1) {
                int nbWeek = Integer.parseInt(periodDuration.substring(0, periodDuration.indexOf(87)));
                time += (long)nbWeek * 604800000L;
                periodDuration = periodDuration.substring(periodDuration.indexOf(87) + 1);
            }
            if (periodDuration.indexOf(68) != -1) {
                int nbDay = Integer.parseInt(periodDuration.substring(0, periodDuration.indexOf(68)));
                time += (long)nbDay * 86400000L;
                periodDuration = periodDuration.substring(periodDuration.indexOf(68) + 1);
            }
            if (periodDuration.indexOf(84) != -1) {
                periodDuration = periodDuration.substring(1);
            }
            if (periodDuration.indexOf(72) != -1) {
                int nbHour = Integer.parseInt(periodDuration.substring(0, periodDuration.indexOf(72)));
                time += (long)nbHour * 3600000L;
                periodDuration = periodDuration.substring(periodDuration.indexOf(72) + 1);
            }
            if (periodDuration.indexOf(77) != -1) {
                int nbMin = Integer.parseInt(periodDuration.substring(0, periodDuration.indexOf(77)));
                time += (long)nbMin * 60000L;
                periodDuration = periodDuration.substring(periodDuration.indexOf(77) + 1);
            }
            if (periodDuration.indexOf(83) != -1) {
                int nbSec = Integer.parseInt(periodDuration.substring(0, periodDuration.indexOf(83)));
                time += (long)nbSec * 1000L;
                periodDuration = periodDuration.substring(periodDuration.indexOf(83) + 1);
            }
            if (periodDuration.length() != 0) {
                throw new IllegalArgumentException("The period descritpion is malformed");
            }
        } else if (periodDuration.startsWith("T")) {
            if ((periodDuration = periodDuration.substring(1)).indexOf(72) != -1) {
                int nbHour = Integer.parseInt(periodDuration.substring(0, periodDuration.indexOf(72)));
                time += (long)nbHour * 3600000L;
                periodDuration = periodDuration.substring(periodDuration.indexOf(72) + 1);
            }
            if (periodDuration.indexOf(77) != -1) {
                int nbMin = Integer.parseInt(periodDuration.substring(0, periodDuration.indexOf(77)));
                time += (long)nbMin * 60000L;
                periodDuration = periodDuration.substring(periodDuration.indexOf(77) + 1);
            }
            if (periodDuration.indexOf(83) != -1) {
                int nbSec = Integer.parseInt(periodDuration.substring(0, periodDuration.indexOf(83)));
                time += (long)nbSec * 1000L;
                periodDuration = periodDuration.substring(periodDuration.indexOf(83) + 1);
            }
            if (periodDuration.length() != 0) {
                throw new IllegalArgumentException("The period descritpion is malformed");
            }
        }
        return time;
    }

    public static Duration getDurationFromString(String periodDuration) {
        if (periodDuration == null) {
            return null;
        }
        String nbYear = null;
        String nbMonth = null;
        String nbWeek = null;
        String nbDay = null;
        String nbHour = null;
        String nbMin = null;
        String nbSec = null;
        if ((periodDuration = periodDuration.substring(1)).indexOf(89) != -1) {
            nbYear = periodDuration.substring(0, periodDuration.indexOf(89));
            periodDuration = periodDuration.substring(periodDuration.indexOf(89) + 1);
        }
        if (periodDuration.indexOf(77) != -1 && (periodDuration.indexOf(84) == -1 || periodDuration.indexOf(84) > periodDuration.indexOf(77))) {
            nbMonth = periodDuration.substring(0, periodDuration.indexOf(77));
            periodDuration = periodDuration.substring(periodDuration.indexOf(77) + 1);
        }
        if (periodDuration.indexOf(87) != -1) {
            nbWeek = periodDuration.substring(0, periodDuration.indexOf(87));
            periodDuration = periodDuration.substring(periodDuration.indexOf(87) + 1);
        }
        if (periodDuration.indexOf(68) != -1) {
            nbDay = periodDuration.substring(0, periodDuration.indexOf(68));
            periodDuration = periodDuration.substring(periodDuration.indexOf(68) + 1);
        }
        if (periodDuration.indexOf(84) != -1) {
            periodDuration = periodDuration.substring(1);
        }
        if (periodDuration.indexOf(72) != -1) {
            nbHour = periodDuration.substring(0, periodDuration.indexOf(72));
            periodDuration = periodDuration.substring(periodDuration.indexOf(72) + 1);
        }
        if (periodDuration.indexOf(77) != -1) {
            nbMin = periodDuration.substring(0, periodDuration.indexOf(77));
            periodDuration = periodDuration.substring(periodDuration.indexOf(77) + 1);
        }
        if (periodDuration.indexOf(83) != -1) {
            nbSec = periodDuration.substring(0, periodDuration.indexOf(83));
            periodDuration = periodDuration.substring(periodDuration.indexOf(83) + 1);
        }
        if (periodDuration.length() != 0) {
            throw new IllegalArgumentException("The period descritpion is malformed, should not respect ISO8601 : " + periodDuration);
        }
        return new DefaultPeriodDuration((InternationalString)(nbYear != null ? new SimpleInternationalString(nbYear) : null), (InternationalString)(nbMonth != null ? new SimpleInternationalString(nbMonth) : null), (InternationalString)(nbWeek != null ? new SimpleInternationalString(nbWeek) : null), (InternationalString)(nbDay != null ? new SimpleInternationalString(nbDay) : null), (InternationalString)(nbHour != null ? new SimpleInternationalString(nbHour) : null), (InternationalString)(nbMin != null ? new SimpleInternationalString(nbMin) : null), (InternationalString)(nbSec != null ? new SimpleInternationalString(nbSec) : null));
    }

    public static Date julianToDate(JulianDate jdt) {
        if (jdt == null) {
            return null;
        }
        int gregDays = 588829;
        int ja = jdt.getCoordinateValue().intValue();
        if (ja >= 588829) {
            int jalpha = (int)(((double)(ja - 1867216) - 0.25) / 36524.25);
            ja = ja + 1 + jalpha - jalpha / 4;
        }
        int jb = ja + 1524;
        int jc = (int)(6680.0 + ((double)(jb - 2439870) - 122.1) / 365.25);
        int jd = 365 * jc + jc / 4;
        int je = (int)((double)(jb - jd) / 30.6001);
        int day = jb - jd - (int)(30.6001 * (double)je);
        int month = je - 1;
        if (month > 12) {
            month -= 12;
        }
        int year = jc - 4715;
        if (month > 2) {
            --year;
        }
        if (year <= 0) {
            --year;
        }
        return new Date((long)year * 31536000000L + (long)month * 2628000000L + (long)day * 86400000L);
    }

    public static Date calendarDateToDate(CalendarDate calDate) {
        if (calDate == null) {
            return null;
        }
        int[] cal = calDate.getCalendarDate();
        if (cal.length > 3) {
            throw new IllegalArgumentException("The CalendarDate integer array is malformed ! see ISO 8601 format.");
        }
        return new Date((long)(cal.length > 0 ? cal[0] : 0) * 31536000000L + (long)(cal.length > 1 ? cal[1] : 0) * 2628000000L + (long)(cal.length > 2 ? cal[2] : 0) * 86400000L);
    }

    public static Date dateAndTimeToDate(DateAndTime dateAndTime) {
        if (dateAndTime == null && !(dateAndTime instanceof DefaultDateAndTime)) {
            return null;
        }
        DefaultDateAndTime dateTime = (DefaultDateAndTime)dateAndTime;
        int[] cal = dateTime.getCalendarDate();
        Number[] clock = dateTime.getClockTime();
        if (cal.length > 3) {
            throw new IllegalArgumentException("The CalendarDate integer array is malformed ! see ISO 8601 format.");
        }
        if (clock.length > 3) {
            throw new IllegalArgumentException("The ClockTime Number array is malformed ! see ISO 8601 format.");
        }
        return new Date((long)(cal.length > 0 ? cal[0] : 0) * 31536000000L + (long)(cal.length > 1 ? cal[1] : 0) * 2628000000L + (long)(cal.length > 2 ? cal[2] : 0) * 86400000L + (long)(clock.length > 0 ? clock[0].intValue() : 0) * 3600000L + (long)(clock.length > 1 ? clock[1].intValue() : 0) * 60000L + (long)(clock.length > 2 ? clock[2].intValue() : 0) * 1000L);
    }

    public static Date temporalCoordToDate(TemporalCoordinate temporalCoord) {
        if (temporalCoord == null) {
            return null;
        }
        if (!(temporalCoord instanceof DefaultTemporalCoordinate)) {
            throw new IllegalArgumentException("Can not convert a temporal coordinate which is not a DefaultTemporalCoordinate.");
        }
        DefaultTemporalCoordinate timeCoord = (DefaultTemporalCoordinate)temporalCoord;
        long value = timeCoord.getCoordinateValue().longValue();
        TemporalReferenceSystem frame = timeCoord.getFrame();
        if (frame instanceof DefaultTemporalCoordinateSystem) {
            DefaultTemporalCoordinateSystem coordSystem = (DefaultTemporalCoordinateSystem)frame;
            Date origin = coordSystem.getOrigin();
            String interval = coordSystem.getInterval().toString();
            long timeInMS = 0L;
            if ("year".equals(interval)) {
                timeInMS = value * 31536000000L;
            } else if ("month".equals(interval)) {
                timeInMS = value * 2628000000L;
            } else if ("week".equals(interval)) {
                timeInMS = value * 604800000L;
            } else if ("day".equals(interval)) {
                timeInMS = value * 86400000L;
            } else if ("hour".equals(interval)) {
                timeInMS = value * 3600000L;
            } else if ("minute".equals(interval)) {
                timeInMS = value * 60000L;
            } else if ("second".equals(interval)) {
                timeInMS = value * 1000L;
            } else {
                throw new IllegalArgumentException(" The interval of TemporalCoordinateSystem for this TemporalCoordinate object is unknown ! ");
            }
            return new Date(timeInMS += origin.getTime());
        }
        throw new IllegalArgumentException("The frame of this TemporalCoordinate object must be an instance of DefaultTemporalCoordinateSystem");
    }

    public static Date ordinalToDate(OrdinalPosition ordinalPosition) {
        if (ordinalPosition == null) {
            return null;
        }
        OrdinalEra era = ordinalPosition.getOrdinalPosition();
        if (era != null) {
            Date beginEra = era.getBegin();
            Date endEra = era.getEnd();
            long middle = (endEra.getTime() + beginEra.getTime()) / 2L;
            return new Date(middle);
        }
        return null;
    }

    public static Unit getUnitFromDuration(Duration duration) {
        if (duration == null) {
            return null;
        }
        if (!(duration instanceof DefaultDuration)) {
            throw new IllegalArgumentException("Can not evaluate best unit for Duration which is not a DefaultDuration.");
        }
        DefaultDuration dduration = (DefaultDuration)duration;
        long mills = dduration.getTimeInMillis();
        long temp = mills / 31536000000L;
        if (temp > 0L) {
            return YEAR_UNIT;
        }
        temp = mills / 2628000000L;
        if (temp > 0L) {
            return MONTH_UNIT;
        }
        temp = mills / 604800000L;
        if (temp > 0L) {
            return Units.WEEK;
        }
        temp = mills / 86400000L;
        if (temp > 0L) {
            return Units.DAY;
        }
        temp = mills / 3600000L;
        if (temp > 0L) {
            return Units.HOUR;
        }
        temp = mills / 60000L;
        if (temp > 0L) {
            return Units.MINUTE;
        }
        temp = mills / 1000L;
        if (temp > 0L) {
            return Units.SECOND;
        }
        return null;
    }

    @Deprecated
    public static Date parseDate(String date) throws ParseException, NullPointerException {
        return TemporalUtilities.parseDate(date, false);
    }

    @Deprecated
    public static Date parseDate(String date, boolean noGMTO) throws ParseException, NullPointerException {
        Calendar cal = TemporalUtilities.parseDateCal(date);
        return cal.getTime();
    }

    public static Calendar parseDateCal(String date) throws ParseException, NullPointerException {
        if (date.endsWith("BC")) {
            throw new ParseException("Date is marked as Before Christ, not possible to parse it", date.length());
        }
        int[] slashOccurences = StringUtilities.getIndexes(date, '/');
        if (slashOccurences.length == 1) {
            int month = TemporalUtilities.parseInt(date.substring(0, slashOccurences[0])) - 1;
            int year = TemporalUtilities.parseInt(date.substring(slashOccurences[0] + 1, date.length()));
            Calendar cal = Calendar.getInstance();
            cal.set(year, month, 1, 0, 0, 0);
            cal.set(14, 0);
            return cal;
        }
        if (slashOccurences.length == 2) {
            int day = TemporalUtilities.parseInt(date.substring(0, slashOccurences[0]));
            int month = TemporalUtilities.parseInt(date.substring(slashOccurences[0] + 1, slashOccurences[1])) - 1;
            int year = TemporalUtilities.parseInt(date.substring(slashOccurences[1] + 1));
            Calendar cal = Calendar.getInstance();
            cal.set(year, month, day, 0, 0, 0);
            cal.set(14, 0);
            return cal;
        }
        int[] spaceOccurences = StringUtilities.getIndexes(date, ' ');
        int[] dashOccurences = StringUtilities.getIndexes(date, '-');
        int[] dotsOccurences = StringUtilities.getIndexes(date, ':');
        if (dotsOccurences.length == 4 && spaceOccurences.length == 1) {
            int year = TemporalUtilities.parseInt(date.substring(0, dotsOccurences[0]));
            int month = TemporalUtilities.parseInt(date.substring(dotsOccurences[0] + 1, dotsOccurences[1])) - 1;
            int day = TemporalUtilities.parseInt(date.substring(dotsOccurences[1] + 1, spaceOccurences[0]));
            int hour = TemporalUtilities.parseInt(date.substring(spaceOccurences[0] + 1, dotsOccurences[2]));
            int min = TemporalUtilities.parseInt(date.substring(dotsOccurences[2] + 1, dotsOccurences[3]));
            int sec = TemporalUtilities.parseInt(date.substring(dotsOccurences[3] + 1));
            Calendar cal = Calendar.getInstance();
            cal.set(year, month, day, hour, min, sec);
            cal.set(14, 0);
            return cal;
        }
        if (spaceOccurences.length == 2) {
            int day = TemporalUtilities.parseInt(date.substring(0, spaceOccurences[0]));
            int month = FR_POOL.indexOf(date.substring(spaceOccurences[0] + 1, spaceOccurences[1]));
            int year = TemporalUtilities.parseInt(date.substring(spaceOccurences[1] + 1));
            Calendar cal = Calendar.getInstance();
            cal.set(year, month, day, 0, 0, 0);
            cal.set(14, 0);
            return cal;
        }
        if (spaceOccurences.length == 1 && dashOccurences.length < 3) {
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                df.parse(date);
                return df.getCalendar();
            }
            catch (ParseException ex) {
                LOGGER.log(Level.FINE, "Could not parse date : " + date + " with dateFormat : " + df);
                int month = FR_POOL.indexOf(date.substring(0, spaceOccurences[0]));
                int year = TemporalUtilities.parseInt(date.substring(spaceOccurences[0] + 1));
                Calendar cal = Calendar.getInstance();
                cal.set(year, month, 1, 0, 0, 0);
                cal.set(14, 0);
                return cal;
            }
        }
        if (dashOccurences.length == 1) {
            if (dashOccurences[0] == 2) {
                int month = TemporalUtilities.parseInt(date.substring(0, dashOccurences[0])) - 1;
                int year = TemporalUtilities.parseInt(date.substring(dashOccurences[0] + 1));
                Calendar cal = Calendar.getInstance();
                cal.set(year, month, 1, 0, 0, 0);
                cal.set(14, 0);
                return cal;
            }
            int year = TemporalUtilities.parseInt(date.substring(0, dashOccurences[0]));
            int month = TemporalUtilities.parseInt(date.substring(dashOccurences[0] + 1)) - 1;
            Calendar cal = Calendar.getInstance();
            cal.set(year, month, 1, 0, 0, 0);
            cal.set(14, 0);
            return cal;
        }
        if (dashOccurences.length >= 2) {
            try {
                ISODateParser fp = new ISODateParser();
                Calendar resultDate = fp.getCalendar(date);
                if (resultDate != null) {
                    return resultDate;
                }
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.FINE, "Could not parse date : " + date + " with getDateFromString method.");
            }
            if (dashOccurences[0] == 4) {
                int year = TemporalUtilities.parseInt(date.substring(0, dashOccurences[0]));
                int month = TemporalUtilities.parseInt(date.substring(dashOccurences[0] + 1, dashOccurences[1])) - 1;
                int day = date.endsWith("Z") ? TemporalUtilities.parseInt(date.substring(dashOccurences[1] + 1, date.length() - 1)) : TemporalUtilities.parseInt(date.substring(dashOccurences[1] + 1));
                Calendar cal = Calendar.getInstance();
                cal.set(year, month, day, 0, 0, 0);
                cal.set(14, 0);
                return cal;
            }
            int day = TemporalUtilities.parseInt(date.substring(0, dashOccurences[0]));
            int month = TemporalUtilities.parseInt(date.substring(dashOccurences[0] + 1, dashOccurences[1])) - 1;
            int year = TemporalUtilities.parseInt(date.substring(dashOccurences[1] + 1));
            Calendar cal = Calendar.getInstance();
            cal.set(year, month, day, 0, 0, 0);
            cal.set(14, 0);
            return cal;
        }
        if (dashOccurences.length == 0) {
            int year = TemporalUtilities.parseInt(date);
            Calendar cal = Calendar.getInstance();
            cal.set(year, 0, 1, 0, 0, 0);
            cal.set(14, 0);
            return cal;
        }
        throw new ParseException("Invalid date format : " + date, 0);
    }

    public static Date parseDateSafe(String date, boolean neverNull) {
        return TemporalUtilities.parseDateSafe(date, neverNull, false);
    }

    public static Date parseDateSafe(String date, boolean neverNull, boolean noGMTO) {
        if (date != null) {
            try {
                return TemporalUtilities.parseDate(date, noGMTO);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return neverNull ? new Date() : null;
    }

    private static int parseInt(String candidate) throws ParseException {
        try {
            return Integer.parseInt(candidate);
        }
        catch (NumberFormatException ex) {
            ParseException pex = new ParseException(ex.getLocalizedMessage(), 0);
            pex.initCause(ex);
            throw pex;
        }
    }

    public static String durationToString(long time) {
        int size;
        if (time == 0L) {
            return "0ms";
        }
        long years = time / 31536000000L;
        long months = (time %= 31536000000L) / 2628000000L;
        long days = (time %= 2628000000L) / 86400000L;
        long hours = (time %= 86400000L) / 3600000L;
        long minuts = (time %= 3600000L) / 60000L;
        long seconds = (time %= 60000L) / 1000L;
        long millis = time %= 1000L;
        StringBuilder sb = new StringBuilder();
        if (years > 0L) {
            sb.append(years).append("y ");
        }
        if (months > 0L) {
            sb.append(months).append("m ");
        }
        if (days > 0L) {
            sb.append(days).append("d ");
        }
        if (hours > 0L) {
            sb.append(hours).append("h ");
        }
        if (minuts > 0L) {
            sb.append(minuts).append("min ");
        }
        if (seconds > 0L) {
            sb.append(seconds).append("s ");
        }
        if (millis > 0L) {
            sb.append(millis).append("ms");
        }
        if (sb.charAt((size = sb.length()) - 1) == ' ') {
            return sb.substring(0, size - 1);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toISO8601(Date date) {
        if (date != null) {
            SimpleDateFormat simpleDateFormat = sdf4;
            synchronized (simpleDateFormat) {
                return sdf4.format(date);
            }
        }
        LOGGER.log(Level.INFO, "ISO 8601 format can not proceed because date is null.");
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toISO8601(Date date, TimeZone timezone) {
        if (date != null) {
            SimpleDateFormat simpleDateFormat = sdf5;
            synchronized (simpleDateFormat) {
                if (timezone != null) {
                    sdf5.setTimeZone(timezone);
                } else {
                    SimpleTimeZone tz = new SimpleTimeZone(0, "Out Timezone");
                    sdf5.setTimeZone(tz);
                }
                return sdf5.format(date);
            }
        }
        LOGGER.log(Level.INFO, "ISO 8601 format can not proceed because date is null.");
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toISO8601Z(Date date, TimeZone timezone) {
        if (date != null) {
            SimpleDateFormat simpleDateFormat = sdf7;
            synchronized (simpleDateFormat) {
                if (timezone != null) {
                    sdf7.setTimeZone(timezone);
                } else {
                    SimpleTimeZone tz = new SimpleTimeZone(0, "Out Timezone");
                    sdf7.setTimeZone(tz);
                }
                return sdf7.format(date);
            }
        }
        LOGGER.log(Level.INFO, "ISO 8601 format can not proceed because date is null.");
        return "";
    }

    public static boolean dateEquals(Date d1, Date d2) {
        if (d1 != null && d2 != null) {
            return d1.getTime() == d2.getTime();
        }
        return Objects.equals(d1, d2);
    }

    static {
        sdf2.setTimeZone(TimeZone.getTimeZone("GMT+0"));
        sdf3 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        sdf4 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        sdf5 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        sdf6 = new SimpleDateFormat("yyyy-MM-dd");
        sdf7 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        sdf6.setTimeZone(TimeZone.getDefault());
        TIME_ZONES = new UnSynchronizedCache<String, TimeZone>(50){

            @Override
            public TimeZone get(Object o) {
                TimeZone tz = (TimeZone)super.get(o);
                if (tz == null) {
                    tz = TimeZone.getTimeZone((String)o);
                    this.put((String)o, tz);
                }
                return tz;
            }
        };
        FR_POOL.add("janvier");
        FR_POOL.add("f\u00e9vrier");
        FR_POOL.add("mars");
        FR_POOL.add("avril");
        FR_POOL.add("mai");
        FR_POOL.add("juin");
        FR_POOL.add("juillet");
        FR_POOL.add("ao\u00fbt");
        FR_POOL.add("septembre");
        FR_POOL.add("octobre");
        FR_POOL.add("novembre");
        FR_POOL.add("d\u00e9cembre");
    }
}

