/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.simple;

import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Date;
import java.util.logging.Logger;
import org.apache.sis.internal.simple.SimpleCitation;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.metadata.sql.MetadataSource;
import org.apache.sis.metadata.sql.MetadataStoreException;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.xml.IdentifierSpace;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.citation.Responsibility;
import org.opengis.metadata.citation.Series;
import org.opengis.metadata.identification.BrowseGraphic;
import org.opengis.util.InternationalString;

public class CitationConstant
extends SimpleCitation {
    private static final long serialVersionUID = -8429121584437634107L;
    private static final Logger LOGGER = Logger.getLogger("org.apache.sis.sql");
    public final String namespace;
    private volatile transient Citation delegate;

    public CitationConstant(String name) {
        super(name);
        this.namespace = name;
    }

    public CitationConstant(String name, String namespace) {
        super(name);
        this.namespace = namespace;
    }

    public final void refresh() {
        this.delegate = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Citation delegate() {
        Citation c = this.delegate;
        if (c == null) {
            CitationConstant citationConstant = this;
            synchronized (citationConstant) {
                c = this.delegate;
                if (c == null) {
                    try {
                        c = MetadataSource.getProvided().lookup(Citation.class, this.title);
                    }
                    catch (MetadataStoreException e) {
                        Logging.unexpectedException(LOGGER, CitationConstant.class, "delegate", e);
                        c = new SimpleCitation(this.title);
                    }
                    this.delegate = c;
                }
            }
        }
        return c;
    }

    @Override
    public InternationalString getTitle() {
        InternationalString title = this.delegate().getTitle();
        return title != null ? title : super.getTitle();
    }

    public Collection<? extends InternationalString> getAlternateTitles() {
        return this.delegate().getAlternateTitles();
    }

    public Collection<? extends CitationDate> getDates() {
        return this.delegate().getDates();
    }

    public InternationalString getEdition() {
        return this.delegate().getEdition();
    }

    public Date getEditionDate() {
        return this.delegate().getEditionDate();
    }

    public Collection<? extends Identifier> getIdentifiers() {
        return this.delegate().getIdentifiers();
    }

    public Collection<? extends Responsibility> getCitedResponsibleParties() {
        return this.delegate().getCitedResponsibleParties();
    }

    public Collection<PresentationForm> getPresentationForms() {
        return this.delegate().getPresentationForms();
    }

    public Series getSeries() {
        return this.delegate().getSeries();
    }

    public Collection<? extends InternationalString> getOtherCitationDetails() {
        return this.delegate().getOtherCitationDetails();
    }

    public Collection<? extends OnlineResource> getOnlineResources() {
        return this.delegate().getOnlineResources();
    }

    public Collection<? extends BrowseGraphic> getGraphics() {
        return this.delegate().getGraphics();
    }

    public String getISBN() {
        return this.delegate().getISBN();
    }

    public String getISSN() {
        return this.delegate().getISSN();
    }

    protected Object readResolve() throws ObjectStreamException {
        Citation c = Citations.fromName(this.title);
        return c instanceof CitationConstant ? c : this;
    }

    public static class Authority<T>
    extends CitationConstant
    implements IdentifierSpace<T> {
        private static final long serialVersionUID = 2067932813561130294L;

        public Authority(String namespace) {
            super(namespace);
        }

        public Authority(String name, String namespace) {
            super(name, namespace);
        }

        @Override
        public final String getName() {
            return this.namespace;
        }

        @Override
        public final String toString() {
            return Strings.bracket(IdentifierSpace.class, (Object)this.title);
        }
    }
}

