/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.jsonoverlay;

import com.fasterxml.jackson.databind.JsonNode;
import com.reprezen.jsonoverlay.JsonOverlay;
import com.reprezen.jsonoverlay.ReferenceRegistry;
import com.reprezen.jsonoverlay.ScalarOverlay;
import com.reprezen.jsonoverlay.SerializationOptions;

public abstract class EnumOverlay<V extends Enum<V>>
extends ScalarOverlay<V> {
    private Class<V> enumClass = null;

    public EnumOverlay(JsonNode json, JsonOverlay<?> parent, ReferenceRegistry refReg) {
        super(json, parent, refReg);
    }

    public EnumOverlay(V value, JsonOverlay<?> parent, ReferenceRegistry refReg) {
        super(value, parent, refReg);
        this.enumClass = this.getEnumClass();
    }

    @Override
    protected V fromJson(JsonNode json) {
        if (!json.isTextual()) {
            return null;
        }
        if (this.enumClass == null) {
            this.enumClass = this.getEnumClass();
        }
        try {
            return Enum.valueOf(this.enumClass, json.asText());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public JsonNode _toJsonInternal(SerializationOptions options) {
        return this.value != null ? EnumOverlay.jsonScalar(((Enum)this.value).name()) : EnumOverlay.jsonMissing();
    }

    protected abstract Class<V> getEnumClass();
}

