/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.collections;

import io.restassured.http.ContentType;
import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opengis.cite.ogcapifeatures10.CommonDataFixture;
import org.opengis.cite.ogcapifeatures10.EtsAssert;
import org.opengis.cite.ogcapifeatures10.SuiteAttribute;
import org.opengis.cite.ogcapifeatures10.openapi3.OpenApiUtils;
import org.opengis.cite.ogcapifeatures10.openapi3.TestPoint;
import org.opengis.cite.ogcapifeatures10.openapi3.UriBuilder;
import org.opengis.cite.ogcapifeatures10.util.JsonUtils;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class FeatureCollections
extends CommonDataFixture {
    private final Map<TestPoint, Response> testPointAndResponses = new HashMap<TestPoint, Response>();
    private final Map<TestPoint, List<Map<String, Object>>> testPointAndCollections = new HashMap<TestPoint, List<Map<String, Object>>>();
    private Object[][] testPointsData;

    @DataProvider(name="collectionsUris")
    public Object[][] collectionsUris(ITestContext testContext) {
        if (this.testPointsData == null) {
            URI iut = (URI)testContext.getSuite().getAttribute(SuiteAttribute.IUT.getName());
            List<TestPoint> testPoints = OpenApiUtils.retrieveTestPointsForCollectionsMetadata(this.getApiModel(), iut);
            this.testPointsData = new Object[testPoints.size()][];
            int i = 0;
            for (TestPoint testPoint : testPoints) {
                this.testPointsData[i++] = new Object[]{testPoint};
            }
        }
        return this.testPointsData;
    }

    @AfterClass
    public void storeCollectionsInTestContext(ITestContext testContext) {
        ArrayList<Map<String, Object>> collections = new ArrayList<Map<String, Object>>();
        for (List<Map<String, Object>> testPointAndCollection : this.testPointAndCollections.values()) {
            collections.addAll(testPointAndCollection);
        }
        testContext.getSuite().setAttribute(SuiteAttribute.COLLECTIONS.getName(), collections);
    }

    @Test(description="Implements A.2.5. Feature Collections {root}/collections, Abstract Test 9 (Requirement /req/core/fc-md-op)", groups={"collections"}, dataProvider="collectionsUris", dependsOnGroups={"apidefinition", "conformance"})
    public void validateFeatureCollectionsMetadataOperation(TestPoint testPoint) {
        String testPointUri = new UriBuilder(testPoint).buildUrl();
        Response response = (Response)this.init().baseUri(testPointUri).accept(ContentType.JSON).when().request(Method.GET);
        ((ValidatableResponse)response.then()).statusCode(200);
        this.testPointAndResponses.put(testPoint, response);
    }

    @Test(description="A.2.5. Feature Collections {root}/collections, Abstract Test 10, Test Method 1 (Requirement /req/core/fc-md-success)", groups={"collections"}, dataProvider="collectionsUris", dependsOnMethods={"validateFeatureCollectionsMetadataOperation"}, alwaysRun=true)
    public void validateFeatureCollectionsMetadataOperationResponse_Links(TestPoint testPoint) {
        Response response = this.testPointAndResponses.get(testPoint);
        if (response == null) {
            throw new SkipException("Could not find a response for test point " + testPoint);
        }
        JsonPath jsonPath = response.jsonPath();
        List links = jsonPath.getList("links");
        Map<String, Object> linkToSelf = JsonUtils.findLinkByRel(links, "self");
        Assert.assertNotNull(linkToSelf, (String)"Feature Collections Metadata document must include a link for itself");
        EtsAssert.assertTrue(JsonUtils.linkIncludesRelAndType(linkToSelf), "Link to itself must include a rel and type parameter");
        List<String> mediaTypesToSupport = this.createListOfMediaTypesToSupportForOtherResources(linkToSelf);
        List<Map<String, Object>> alternateLinks = JsonUtils.findLinksWithSupportedMediaTypeByRel(links, mediaTypesToSupport, "alternate");
        List<String> typesWithoutLink = JsonUtils.findUnsupportedTypes(alternateLinks, mediaTypesToSupport);
        EtsAssert.assertTrue(typesWithoutLink.isEmpty(), "Feature Collections Metadata document must include links for alternate encodings. Missing links for types " + typesWithoutLink);
        List<String> linksWithoutRelOrType = JsonUtils.findLinksWithoutRelOrType(alternateLinks);
        EtsAssert.assertTrue(linksWithoutRelOrType.isEmpty(), "Links for alternate encodings must include a rel and type parameter. Missing for links " + linksWithoutRelOrType);
    }

    @Test(description="A.2.5. Feature Collections {root}/collections, Abstract Test 10, Test Method 2 (Requirement /req/core/fc-md-success)", groups={"collections"}, dataProvider="collectionsUris", dependsOnMethods={"validateFeatureCollectionsMetadataOperation"}, alwaysRun=true)
    public void validateFeatureCollectionsMetadataOperationResponse_Items(TestPoint testPoint) {
        Response response = this.testPointAndResponses.get(testPoint);
        if (response == null) {
            throw new SkipException("Could not find a response for test point " + testPoint);
        }
        JsonPath jsonPath = response.jsonPath();
        List collections = jsonPath.getList("collections");
        this.testPointAndCollections.put(testPoint, this.createCollectionsMap(collections));
    }

    @Test(description="A.2.5. Feature Collections {root}/collections, Abstract Test 10, Test Method 3 (Requirement /req/core/fc-md-success)", groups={"collections"}, dataProvider="collectionsUris", dependsOnMethods={"validateFeatureCollectionsMetadataOperation"}, alwaysRun=true)
    public void validateFeatureCollectionsMetadataOperationResponse_CrsProperty(TestPoint testPoint) {
        Response response = this.testPointAndResponses.get(testPoint);
        if (response == null) {
            throw new SkipException("Could not find a response for test point " + testPoint);
        }
    }

    @Test(description="A.2.5. Feature Collections {root}/collections, Abstract Test 10, Test Method 4 (Requirement /req/core/fc-md-success)", groups={"collections"}, dataProvider="collectionsUris", dependsOnMethods={"validateFeatureCollectionsMetadataOperation"}, alwaysRun=true)
    public void validateFeatureCollectionsMetadataOperationResponse_Content(TestPoint testPoint) {
        Response response = this.testPointAndResponses.get(testPoint);
        if (response == null) {
            throw new SkipException("Could not find a response for test point " + testPoint);
        }
        JsonPath jsonPath = response.jsonPath();
        List links = jsonPath.getList("links");
        boolean linksAreAvailable = links != null && !links.isEmpty();
        EtsAssert.assertTrue(linksAreAvailable, "Feature Collections Metadata document does not contain links.");
        List collections = jsonPath.getList("collections");
        boolean collectionssAreAvailable = collections != null && !collections.isEmpty();
        EtsAssert.assertTrue(collectionssAreAvailable, "Feature Collections Metadata document does not contain collections.");
    }

    private List<Map<String, Object>> createCollectionsMap(List<Object> collections) {
        ArrayList<Map<String, Object>> collectionsMap = new ArrayList<Map<String, Object>>();
        for (Object collection : collections) {
            collectionsMap.add((Map)collection);
            if (this.noOfCollections <= 0 || collectionsMap.size() < this.noOfCollections) continue;
            return collectionsMap;
        }
        return collectionsMap;
    }
}

