/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.conformance;

public enum RequirementClass {
    CORE("http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/core"),
    HTML("http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/html", "text/html", "text/html"),
    GEOJSON("http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/geojson", "application/geo+json", "application/json"),
    GMLSF0("http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/gmlsf0", "application/gml+xml;version=3.2;profile=http://www.opengis.net/def/profile/ogc/2.0/gml-sf0", "application/xml"),
    GMLSF2("http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/gmlsf2", "application/gml+xml;version=3.2;profile=http://www.opengis.net/def/profile/ogc/2.0/gml-sf2", "application/xml"),
    OPENAPI30("http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/oas30");

    private final String conformanceClass;
    private final String mediaTypeFeaturesAndCollections;
    private final String mediaTypeOtherResources;

    private RequirementClass(String conformanceClass) {
        this(conformanceClass, null, null);
    }

    private RequirementClass(String conformanceClass, String mediaTypeFeaturesAndCollections, String mediaTypeOtherResources) {
        this.conformanceClass = conformanceClass;
        this.mediaTypeFeaturesAndCollections = mediaTypeFeaturesAndCollections;
        this.mediaTypeOtherResources = mediaTypeOtherResources;
    }

    public boolean hasMediaTypeForFeaturesAndCollections() {
        return this.mediaTypeFeaturesAndCollections != null;
    }

    public String getMediaTypeFeaturesAndCollections() {
        return this.mediaTypeFeaturesAndCollections;
    }

    public boolean hasMediaTypeForOtherResources() {
        return this.mediaTypeOtherResources != null;
    }

    public String getMediaTypeOtherResources() {
        return this.mediaTypeOtherResources;
    }

    public static RequirementClass byConformanceClass(String conformanceClass) {
        for (RequirementClass requirementClass : RequirementClass.values()) {
            if (!requirementClass.conformanceClass.equals(conformanceClass)) continue;
            return requirementClass;
        }
        return null;
    }
}

