/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.openapi3;

import com.reprezen.kaizen.oasparser.model3.MediaType;
import com.reprezen.kaizen.oasparser.model3.OpenApi3;
import com.reprezen.kaizen.oasparser.model3.Operation;
import com.reprezen.kaizen.oasparser.model3.Parameter;
import com.reprezen.kaizen.oasparser.model3.Path;
import com.reprezen.kaizen.oasparser.model3.Response;
import com.reprezen.kaizen.oasparser.model3.Schema;
import com.reprezen.kaizen.oasparser.model3.Server;
import com.sun.jersey.api.uri.UriTemplate;
import com.sun.jersey.api.uri.UriTemplateParser;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.opengis.cite.ogcapifeatures10.openapi3.TestPoint;

public class OpenApiUtils {
    private static final String DEFAULT_SERVER_URL = "/";

    private OpenApiUtils() {
    }

    static List<TestPoint> retrieveTestPoints(OpenApi3 apiModel, URI iut) {
        List<Path> pathItemObjects = OpenApiUtils.identifyTestPoints(apiModel);
        List<PathItemAndServer> pathItemAndServers = OpenApiUtils.identifyServerUrls(apiModel, iut, pathItemObjects);
        return OpenApiUtils.processServerObjects(pathItemAndServers, true);
    }

    public static List<TestPoint> retrieveTestPointsForConformance(OpenApi3 apiModel, URI iut) {
        return OpenApiUtils.retrieveTestPoints(apiModel, iut, PATH.CONFORMANCE, false);
    }

    public static List<TestPoint> retrieveTestPointsForCollectionsMetadata(OpenApi3 apiModel, URI iut) {
        return OpenApiUtils.retrieveTestPoints(apiModel, iut, PATH.COLLECTIONS, false);
    }

    public static List<TestPoint> retrieveTestPointsForCollectionMetadata(OpenApi3 apiModel, URI iut, String collectionName) {
        StringBuilder requestedPath = new StringBuilder();
        requestedPath.append(DEFAULT_SERVER_URL);
        requestedPath.append(PATH.COLLECTIONS.getPathItem());
        requestedPath.append(DEFAULT_SERVER_URL);
        requestedPath.append(collectionName);
        List<TestPoint> testPoints = OpenApiUtils.retrieveTestPoints(apiModel, iut, requestedPath.toString(), true);
        return testPoints.stream().filter(new ExactMatchFilter(requestedPath.toString())).collect(Collectors.toList());
    }

    public static List<TestPoint> retrieveTestPointsForCollections(OpenApi3 apiModel, URI iut, int noOfCollection) {
        StringBuilder requestedPath = new StringBuilder();
        requestedPath.append(DEFAULT_SERVER_URL);
        requestedPath.append(PATH.COLLECTIONS.getPathItem());
        requestedPath.append("/.*/items");
        List<TestPoint> allTestPoints = OpenApiUtils.retrieveTestPoints(apiModel, iut, requestedPath.toString(), (a, b) -> a.matches((String)b), true);
        if (noOfCollection < 0 || allTestPoints.size() <= noOfCollection) {
            return allTestPoints;
        }
        return allTestPoints.subList(0, noOfCollection);
    }

    public static List<TestPoint> retrieveTestPointsForCollection(OpenApi3 apiModel, URI iut, String collectionName) {
        String requestedPath = OpenApiUtils.createCollectionPath(collectionName);
        List<TestPoint> testPoints = OpenApiUtils.retrieveTestPoints(apiModel, iut, requestedPath, true);
        return testPoints.stream().filter(new ExactMatchFilter(requestedPath)).collect(Collectors.toList());
    }

    public static List<TestPoint> retrieveTestPointsForFeature(OpenApi3 apiModel, URI iut, String collectionName, String featureId) {
        StringBuilder requestedPath = new StringBuilder();
        requestedPath.append(DEFAULT_SERVER_URL);
        requestedPath.append(PATH.COLLECTIONS.getPathItem());
        requestedPath.append(DEFAULT_SERVER_URL);
        requestedPath.append(collectionName);
        requestedPath.append("/items/");
        requestedPath.append(featureId);
        List<TestPoint> testPoints = OpenApiUtils.retrieveTestPoints(apiModel, iut, requestedPath.toString(), true);
        return testPoints.stream().filter(new ExactMatchFilter(requestedPath.toString())).collect(Collectors.toList());
    }

    public static Parameter retrieveParameterByName(String collectionItemPath, OpenApi3 apiModel, String name) {
        Path path = apiModel.getPath(collectionItemPath);
        if (path != null) {
            for (Parameter parameter : path.getParameters()) {
                if (!name.equals(parameter.getName())) continue;
                return parameter;
            }
            Operation get = path.getOperation("get");
            for (Parameter parameter : get.getParameters()) {
                if (!name.equals(parameter.getName())) continue;
                return parameter;
            }
        }
        return null;
    }

    public static boolean isFreeFormParameterSupportedForCollection(OpenApi3 apiModel, String collectionName) {
        String requestedPath = OpenApiUtils.createCollectionPath(collectionName);
        List<Path> paths = OpenApiUtils.identifyTestPoints(apiModel, requestedPath, new PathMatcher());
        for (Path path : paths) {
            List<Parameter> parameters = path.getGet().getParameters();
            for (Parameter parameter : parameters) {
                if (parameter.getSchema() == null || !parameter.getSchema().isAdditionalProperties()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isParameterSupportedForCollection(OpenApi3 apiModel, String collectionName, String queryParam) {
        String requestedPath = OpenApiUtils.createCollectionPath(collectionName);
        List<Path> paths = OpenApiUtils.identifyTestPoints(apiModel, requestedPath, new PathMatcher());
        for (Path path : paths) {
            List<Parameter> parameters = path.getGet().getParameters();
            for (Parameter parameter : parameters) {
                if (!queryParam.equalsIgnoreCase(parameter.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private static String createCollectionPath(String collectionName) {
        StringBuilder requestedPath = new StringBuilder();
        requestedPath.append(DEFAULT_SERVER_URL);
        requestedPath.append(PATH.COLLECTIONS.getPathItem());
        requestedPath.append(DEFAULT_SERVER_URL);
        requestedPath.append(collectionName);
        requestedPath.append("/items");
        return requestedPath.toString();
    }

    private static List<TestPoint> retrieveTestPoints(OpenApi3 apiModel, URI iut, PATH path, boolean allowEmptyTemplateReplacements) {
        String requestedPath = DEFAULT_SERVER_URL + path.getPathItem();
        return OpenApiUtils.retrieveTestPoints(apiModel, iut, requestedPath, allowEmptyTemplateReplacements);
    }

    private static List<TestPoint> retrieveTestPoints(OpenApi3 apiModel, URI iut, String requestedPath, boolean allowEmptyTemplateReplacements) {
        return OpenApiUtils.retrieveTestPoints(apiModel, iut, requestedPath, new PathMatcher(), allowEmptyTemplateReplacements);
    }

    private static List<TestPoint> retrieveTestPoints(OpenApi3 apiModel, URI iut, String requestedPath, PathMatcherFunction<Boolean, String, String> pathMatcher, boolean allowEmptyTemplateReplacements) {
        List<Path> pathItemObjects = OpenApiUtils.identifyTestPoints(apiModel, requestedPath, pathMatcher);
        List<PathItemAndServer> pathItemAndServers = OpenApiUtils.identifyServerUrls(apiModel, iut, pathItemObjects);
        return OpenApiUtils.processServerObjects(pathItemAndServers, allowEmptyTemplateReplacements);
    }

    private static List<Path> identifyTestPoints(OpenApi3 apiModel) {
        ArrayList<Path> allTestPoints = new ArrayList<Path>();
        for (PATH path : PATH.values()) {
            allTestPoints.addAll(OpenApiUtils.identifyTestPoints(apiModel, DEFAULT_SERVER_URL + path.getPathItem(), new PathMatcher()));
        }
        return allTestPoints;
    }

    private static List<Path> identifyTestPoints(OpenApi3 apiModel, String path, PathMatcherFunction<Boolean, String, String> pathMatch) {
        ArrayList<Path> pathItems = new ArrayList<Path>();
        Map<String, Path> pathItemObjects = apiModel.getPaths();
        for (Path pathItemObject : pathItemObjects.values()) {
            String pathString = pathItemObject.getPathString();
            if (!pathMatch.apply(pathString, path).booleanValue()) continue;
            pathItems.add(pathItemObject);
        }
        return pathItems;
    }

    private static List<PathItemAndServer> identifyServerUrls(OpenApi3 apiModel, URI iut, List<Path> pathItemObjects) {
        ArrayList<PathItemAndServer> pathItemAndServers = new ArrayList<PathItemAndServer>();
        for (Path pathItemObject : pathItemObjects) {
            Map<String, Operation> operationObjects = pathItemObject.getOperations();
            for (Operation operationObject : operationObjects.values()) {
                List<String> serverUrls = OpenApiUtils.identifyServerObjects(apiModel, pathItemObject, operationObject);
                for (String serverUrl : serverUrls) {
                    if (DEFAULT_SERVER_URL.equalsIgnoreCase(serverUrl)) {
                        serverUrl = iut.toString();
                    } else if (serverUrl.startsWith(DEFAULT_SERVER_URL)) {
                        URI resolvedUri = iut.resolve(serverUrl);
                        serverUrl = resolvedUri.toString();
                    }
                    PathItemAndServer pathItemAndServer = new PathItemAndServer(pathItemObject, operationObject, serverUrl);
                    pathItemAndServers.add(pathItemAndServer);
                }
            }
        }
        return pathItemAndServers;
    }

    private static List<TestPoint> processServerObjects(List<PathItemAndServer> pathItemAndServers, boolean allowEmptyTemplateReplacements) {
        ArrayList<TestPoint> uris = new ArrayList<TestPoint>();
        for (PathItemAndServer pathItemAndServer : pathItemAndServers) {
            OpenApiUtils.processServerObject(uris, pathItemAndServer, allowEmptyTemplateReplacements);
        }
        return uris;
    }

    private static void processServerObject(List<TestPoint> uris, PathItemAndServer pathItemAndServer, boolean allowEmptyTemplateReplacements) {
        String pathString = pathItemAndServer.pathItemObject.getPathString();
        Response response = OpenApiUtils.getResponse(pathItemAndServer);
        if (response == null) {
            return;
        }
        Map<String, MediaType> contentMediaTypes = response.getContentMediaTypes();
        UriTemplate uriTemplate = new UriTemplate(pathItemAndServer.serverUrl + pathString);
        if (uriTemplate.getNumberOfTemplateVariables() == 0) {
            TestPoint testPoint = new TestPoint(pathItemAndServer.serverUrl, pathString, contentMediaTypes);
            uris.add(testPoint);
        } else {
            List<Map<String, String>> templateReplacements = OpenApiUtils.collectTemplateReplacements(pathItemAndServer, uriTemplate);
            if (templateReplacements.isEmpty() && allowEmptyTemplateReplacements) {
                TestPoint testPoint = new TestPoint(pathItemAndServer.serverUrl, pathString, contentMediaTypes);
                uris.add(testPoint);
            } else {
                for (Map<String, String> templateReplacement : templateReplacements) {
                    TestPoint testPoint = new TestPoint(pathItemAndServer.serverUrl, pathString, templateReplacement, contentMediaTypes);
                    uris.add(testPoint);
                }
            }
        }
    }

    private static Response getResponse(PathItemAndServer pathItemAndServer) {
        if (pathItemAndServer.operationObject.hasResponse("200")) {
            return pathItemAndServer.operationObject.getResponse("200");
        }
        if (pathItemAndServer.operationObject.hasResponse("default")) {
            return pathItemAndServer.operationObject.getResponse("default");
        }
        return null;
    }

    private static List<Map<String, String>> collectTemplateReplacements(PathItemAndServer pathItemAndServer, UriTemplate uriTemplate) {
        ArrayList<Map<String, String>> templateReplacements = new ArrayList<Map<String, String>>();
        List<Parameter> parameters = pathItemAndServer.operationObject.getParameters();
        for (String templateVariable : uriTemplate.getTemplateVariables()) {
            for (Parameter parameter : parameters) {
                if (!templateVariable.equals(parameter.getName())) continue;
                Schema schema = parameter.getSchema();
                if (schema.hasEnums()) {
                    OpenApiUtils.addEnumTemplateValues(templateReplacements, templateVariable, schema);
                    continue;
                }
                if (schema.getDefault() == null) continue;
                OpenApiUtils.addDefaultTemplateValue(templateReplacements, templateVariable, schema);
            }
        }
        return templateReplacements;
    }

    private static void addEnumTemplateValues(List<Map<String, String>> templateReplacements, String templateVariable, Schema schema) {
        List<Object> enums = schema.getEnums();
        if (enums.size() == 1) {
            for (Object e : enums) {
                HashMap<String, String> replacement = new HashMap<String, String>();
                replacement.put(templateVariable, e.toString());
                templateReplacements.add(replacement);
            }
        } else {
            if (templateReplacements.isEmpty()) {
                HashMap replacement = new HashMap();
                templateReplacements.add(replacement);
            }
            ArrayList templateReplacementsToAdd = new ArrayList();
            for (Map<String, String> templateReplacement : templateReplacements) {
                for (Object e : enums) {
                    HashMap<String, String> newTemplateReplacement = new HashMap<String, String>();
                    newTemplateReplacement.putAll(templateReplacement);
                    newTemplateReplacement.put(templateVariable, e.toString());
                    templateReplacementsToAdd.add(newTemplateReplacement);
                }
            }
            templateReplacements.clear();
            templateReplacements.addAll(templateReplacementsToAdd);
        }
    }

    private static void addDefaultTemplateValue(List<Map<String, String>> templateReplacements, String templateVariable, Schema schema) {
        if (templateReplacements.isEmpty()) {
            HashMap replacement = new HashMap();
            templateReplacements.add(replacement);
        }
        for (Map<String, String> templateReplacement : templateReplacements) {
            templateReplacement.put(templateVariable, schema.getDefault().toString());
        }
    }

    private static List<String> identifyServerObjects(OpenApi3 apiModel, Path pathItemObject, Operation operationObject) {
        if (operationObject.hasServers()) {
            return OpenApiUtils.parseUrls(operationObject.getServers());
        }
        if (pathItemObject.hasServers()) {
            return OpenApiUtils.parseUrls(pathItemObject.getServers());
        }
        if (apiModel.hasServers()) {
            return OpenApiUtils.parseUrls(apiModel.getServers());
        }
        return Collections.singletonList(DEFAULT_SERVER_URL);
    }

    private static List<String> parseUrls(Collection<Server> servers) {
        ArrayList<String> urls = new ArrayList<String>();
        for (Server server : servers) {
            urls.add(server.getUrl());
        }
        return urls;
    }

    private static class PathItemAndServer {
        private final Path pathItemObject;
        private Operation operationObject;
        private String serverUrl;

        private PathItemAndServer(Path pathItemObject, Operation operationObject, String serverUrl) {
            this.pathItemObject = pathItemObject;
            this.operationObject = operationObject;
            this.serverUrl = serverUrl;
        }
    }

    private static class ExactMatchFilter
    implements Predicate<TestPoint> {
        private final String requestedPath;

        ExactMatchFilter(String requestedPath) {
            this.requestedPath = requestedPath;
        }

        @Override
        public boolean test(TestPoint testPoint) {
            UriTemplate uriTemplate = new UriTemplate(testPoint.getPath());
            HashMap<String, String> templateReplacement = new HashMap<String, String>(testPoint.getPredefinedTemplateReplacement());
            List<String> templateVariables = uriTemplate.getTemplateVariables();
            for (String templateVariable : templateVariables) {
                if (templateReplacement.containsKey(templateVariable)) continue;
                templateReplacement.put(templateVariable, ".*");
            }
            String uri = uriTemplate.createURI(templateReplacement);
            Pattern pattern = Pattern.compile(uri);
            return pattern.matcher(this.requestedPath).matches();
        }
    }

    private static class PathMatcher
    implements PathMatcherFunction<Boolean, String, String> {
        private PathMatcher() {
        }

        @Override
        public Boolean apply(String pathUnderTest, String pathToMatch) {
            UriTemplateParser parser = new UriTemplateParser(pathUnderTest);
            Matcher matcher = parser.getPattern().matcher(pathToMatch);
            return matcher.matches();
        }
    }

    static enum PATH {
        CONFORMANCE("conformance"),
        COLLECTIONS("collections");

        private String pathItem;

        private PATH(String pathItem) {
            this.pathItem = pathItem;
        }

        private String getPathItem() {
            return this.pathItem;
        }
    }

    @FunctionalInterface
    private static interface PathMatcherFunction<A, B, C> {
        public A apply(B var1, C var2);
    }
}

