/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.collections;

import com.reprezen.kaizen.oasparser.model3.Parameter;
import com.reprezen.kaizen.oasparser.model3.Schema;
import io.restassured.http.Method;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.opengis.cite.ogcapifeatures10.EtsAssert;
import org.opengis.cite.ogcapifeatures10.collections.AbstractFeatures;
import org.opengis.cite.ogcapifeatures10.openapi3.OpenApiUtils;
import org.opengis.cite.ogcapifeatures10.openapi3.TestPoint;
import org.opengis.cite.ogcapifeatures10.util.JsonUtils;
import org.opengis.cite.ogcapifeatures10.util.TemporalExtent;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class FeaturesTime
extends AbstractFeatures {
    @DataProvider(name="collectionItemUrisWithDateTimes")
    public Iterator<Object[]> collectionItemUrisWithDateTimes(ITestContext testContext) {
        ArrayList<Object[]> collectionsWithTimes = new ArrayList<Object[]>();
        for (Map collection : this.collections) {
            TemporalExtent temporalExtent = JsonUtils.parseTemporalExtent(collection);
            if (temporalExtent == null) continue;
            ZonedDateTime begin = temporalExtent.getBegin();
            ZonedDateTime end = temporalExtent.getEnd();
            Duration between = Duration.between(begin, end);
            Duration quarter = between.dividedBy(4L);
            ZonedDateTime beginInterval = begin.plus(quarter);
            ZonedDateTime endInterval = beginInterval.plus(quarter);
            collectionsWithTimes.add(new Object[]{collection, JsonUtils.formatDate(begin), beginInterval, null});
            collectionsWithTimes.add(new Object[]{collection, JsonUtils.formatDateRange(beginInterval, endInterval), beginInterval, endInterval});
            LocalDate beginIntervalDate = beginInterval.toLocalDate();
            LocalDate endIntervalDate = beginIntervalDate.plusDays(2L);
            collectionsWithTimes.add(new Object[]{collection, JsonUtils.formatDateRangeWithDuration(beginIntervalDate, endIntervalDate), beginIntervalDate, endIntervalDate});
        }
        return collectionsWithTimes.iterator();
    }

    @Test(description="A.2.7. Features {root}/collections/{collectionId}/items - Datetime, Abstract Test 14: (Requirement /req/core/fc-time-definition)", dataProvider="collectionPaths", dependsOnGroups={"featuresBase"}, alwaysRun=true)
    public void timeParameterDefinition(TestPoint testPoint) {
        Parameter time = OpenApiUtils.retrieveParameterByName(testPoint.getPath(), this.getApiModel(), "datetime");
        Assert.assertNotNull((Object)time, (String)("Required time parameter for collections with path '" + testPoint.getPath() + "'  in OpenAPI document is missing"));
        String msg = "Expected property '%s' with value '%s' but was '%s'";
        Assert.assertEquals((String)time.getName(), (String)"datetime", (String)String.format(msg, "name", "datetime", time.getName()));
        Assert.assertEquals((String)time.getIn(), (String)"query", (String)String.format(msg, "in", "query", time.getIn()));
        EtsAssert.assertFalse(this.isRequired(time), String.format(msg, "required", "false", time.getRequired()));
        Assert.assertEquals((String)time.getStyle(), (String)"form", (String)String.format(msg, "style", "form", time.getStyle()));
        EtsAssert.assertFalse(this.isExplode(time), String.format(msg, "explode", "false", time.getExplode()));
        Schema schema = time.getSchema();
        Assert.assertEquals((String)schema.getType(), (String)"string", (String)String.format(msg, "schema -> type", "string", schema.getType()));
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items - DateTIme, Abstract Test 13: (Requirement /req/core/fc-op)", dataProvider="collectionItemUrisWithDateTimes", dependsOnGroups={"featuresBase"}, alwaysRun=true)
    public void validateFeaturesWithDateTimeOperation(Map<String, Object> collection, String queryParameter, Object begin, Object end) {
        String collectionId = (String)collection.get("id");
        String getFeaturesUrl = this.findFeaturesUrlForGeoJson(collection);
        if (getFeaturesUrl.isEmpty()) {
            throw new SkipException("Could not find url for collection with id " + collectionId + " supporting GeoJson (type " + "application/geo+json" + ")");
        }
        ZonedDateTime timeStampBeforeResponse = ZonedDateTime.now();
        Response response = (Response)this.init().baseUri(getFeaturesUrl).accept("application/geo+json").param("datetime", new Object[]{queryParameter}).when().request(Method.GET);
        ((ValidatableResponse)response.then()).statusCode(200);
        ZonedDateTime timeStampAfterResponse = ZonedDateTime.now();
        AbstractFeatures.ResponseData responseData = new AbstractFeatures.ResponseData(this, response, timeStampBeforeResponse, timeStampAfterResponse);
        this.collectionIdAndResponse.put(this.asKey(collectionId, queryParameter), responseData);
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items - DateTime, Abstract Test 19: (Requirement /req/core/fc-time-response)", dataProvider="collectionItemUrisWithDateTimes", dependsOnGroups={"featuresBase"}, alwaysRun=true)
    public void validateFeaturesWithDateTimeResponse(Map<String, Object> collection, String queryParameter, Object begin, Object end) {
        String collectionId = (String)collection.get("id");
        AbstractFeatures.ResponseData response = (AbstractFeatures.ResponseData)this.collectionIdAndResponse.get(this.asKey(collectionId, queryParameter));
        if (response == null) {
            throw new SkipException("Could not find a response for collection with id " + collectionId);
        }
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items - DateTime, Abstract Test 22, Test Method 1 (Requirement /req/core/fc-response)", dataProvider="collectionItemUrisWithDateTimes", dependsOnMethods={"validateFeaturesWithDateTimeOperation"}, alwaysRun=true)
    public void validateFeaturesWithDateTimeResponse_TypeProperty(Map<String, Object> collection, String queryParameter, Object begin, Object end) {
        String collectionId = (String)collection.get("id");
        this.validateTypeProperty(this.asKey(collectionId, queryParameter));
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items - DateTime, Abstract Test 22, Test Method 2 (Requirement /req/core/fc-response)", dataProvider="collectionItemUrisWithDateTimes", dependsOnMethods={"validateFeaturesWithDateTimeOperation"}, alwaysRun=true)
    public void validateFeaturesWithDateTimeResponse_FeaturesProperty(Map<String, Object> collection, String queryParameter, Object begin, Object end) {
        String collectionId = (String)collection.get("id");
        this.validateFeaturesProperty(this.asKey(collectionId, queryParameter));
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items - DateTime, Abstract Test 22, Test Method 4 (Requirement /req/core/fc-response) - Abstract Test 23 (Requirement /req/core/fc-links, /req/core/fc-rel-type)", dataProvider="collectionItemUrisWithDateTimes", dependsOnMethods={"validateFeaturesWithDateTimeOperation"}, alwaysRun=true)
    public void validateFeaturesWithDateTimeResponse_Links(Map<String, Object> collection, String queryParameter, Object begin, Object end) {
        String collectionId = (String)collection.get("id");
        this.validateLinks(this.asKey(collectionId, queryParameter));
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items - DateTime, Abstract Test 22, Test Method 5 (Requirement /req/core/fc-response) - Abstract Test 24 (Requirement /req/core/fc-timeStamp)", dataProvider="collectionItemUrisWithDateTimes", dependsOnMethods={"validateFeaturesWithDateTimeOperation"}, alwaysRun=true)
    public void validateFeaturesWithDateTimeResponse_TimeStamp(Map<String, Object> collection, String queryParameter, Object begin, Object end) {
        String collectionId = (String)collection.get("id");
        this.validateTimeStamp(this.asKey(collectionId, queryParameter));
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items - DateTime, Abstract Test 22, Test Method 6 (Requirement /req/core/fc-response) - Abstract Test 25 (Requirement /req/core/fc-numberMatched)", dataProvider="collectionItemUrisWithDateTimes", dependsOnMethods={"validateFeaturesWithDateTimeOperation"}, alwaysRun=true)
    public void validateFeaturesWithDateTimeResponse_NumberMatched(Map<String, Object> collection, String queryParameter, Object begin, Object end) throws URISyntaxException {
        String collectionId = (String)collection.get("id");
        this.validateNumberMatched(this.asKey(collectionId, queryParameter));
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items - DateTime, Abstract Test 22, Test Method 5 (Requirement /req/core/fc-response) - Abstract Test 24 (Requirement /req/core/fc-timeStamp)", dataProvider="collectionItemUrisWithDateTimes", dependsOnMethods={"validateFeaturesWithDateTimeOperation"}, alwaysRun=true)
    public void validateFeaturesResponse_NumberReturned(Map<String, Object> collection, String queryParameter, Object begin, Object end) {
        String collectionId = (String)collection.get("id");
        this.validateNumberReturned(this.asKey(collectionId, queryParameter));
    }

    private CollectionIdWithTimeKey asKey(String collectionId, String queryParameter) {
        return new CollectionIdWithTimeKey(collectionId, queryParameter);
    }

    private class CollectionIdWithTimeKey
    extends AbstractFeatures.CollectionResponseKey {
        String queryParameter;

        public CollectionIdWithTimeKey(String collectionId, String queryParameter) {
            super(FeaturesTime.this, collectionId);
            this.queryParameter = queryParameter;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CollectionIdWithTimeKey that = (CollectionIdWithTimeKey)o;
            return Objects.equals(this.queryParameter, that.queryParameter);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.queryParameter);
        }
    }
}

