/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.config;

import io.restassured.config.Config;
import io.restassured.filter.log.LogDetail;
import java.io.PrintStream;
import org.apache.commons.lang3.Validate;

public class LogConfig
implements Config {
    private final PrintStream defaultPrintStream;
    private final boolean prettyPrintingEnabled;
    private final LogDetail logDetailIfValidationFails;
    private final boolean urlEncodeRequestUri;
    private final boolean isUserDefined;

    public LogConfig() {
        this(System.out, true, null, true, false);
    }

    public LogConfig(PrintStream defaultPrintStream, boolean prettyPrintingEnabled) {
        this(defaultPrintStream, prettyPrintingEnabled, null, true, true);
    }

    private LogConfig(PrintStream defaultPrintStream, boolean prettyPrintingEnabled, LogDetail logDetailIfValidationFails, boolean urlEncodeRequestUri, boolean isUserDefined) {
        Validate.notNull(defaultPrintStream, "Stream to write logs to cannot be null", new Object[0]);
        this.defaultPrintStream = defaultPrintStream;
        this.prettyPrintingEnabled = prettyPrintingEnabled;
        this.logDetailIfValidationFails = logDetailIfValidationFails;
        this.isUserDefined = isUserDefined;
        this.urlEncodeRequestUri = urlEncodeRequestUri;
    }

    public PrintStream defaultStream() {
        return this.defaultPrintStream;
    }

    public LogConfig defaultStream(PrintStream printStream) {
        return new LogConfig(printStream, true, this.logDetailIfValidationFails, this.urlEncodeRequestUri, true);
    }

    public boolean isPrettyPrintingEnabled() {
        return this.prettyPrintingEnabled;
    }

    public boolean isLoggingOfRequestAndResponseIfValidationFailsEnabled() {
        return this.logDetailIfValidationFails != null;
    }

    public LogDetail logDetailOfRequestAndResponseIfValidationFails() {
        return this.logDetailIfValidationFails;
    }

    public LogConfig enablePrettyPrinting(boolean shouldEnable) {
        return new LogConfig(this.defaultPrintStream, shouldEnable, this.logDetailIfValidationFails, this.urlEncodeRequestUri, true);
    }

    public LogConfig enableLoggingOfRequestAndResponseIfValidationFails() {
        return this.enableLoggingOfRequestAndResponseIfValidationFails(LogDetail.ALL);
    }

    public LogConfig enableLoggingOfRequestAndResponseIfValidationFails(LogDetail logDetail) {
        return new LogConfig(this.defaultPrintStream, this.prettyPrintingEnabled, logDetail, this.urlEncodeRequestUri, true);
    }

    public LogConfig urlEncodeRequestUri(boolean urlEncodeRequestUri) {
        return new LogConfig(this.defaultPrintStream, this.prettyPrintingEnabled, this.logDetailIfValidationFails, urlEncodeRequestUri, true);
    }

    public boolean shouldUrlEncodeRequestUri() {
        return this.urlEncodeRequestUri;
    }

    public static LogConfig logConfig() {
        return new LogConfig();
    }

    public LogConfig and() {
        return this;
    }

    public boolean isUserConfigured() {
        return this.isUserDefined;
    }
}

