/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10;

import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.core.MediaType;
import org.opengis.cite.ogcapifeatures10.CommonFixture;
import org.opengis.cite.ogcapifeatures10.util.ClientUtils;
import org.opengis.cite.ogcapifeatures10.util.XMLUtils;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;
import org.w3c.dom.Document;

public class TestFailureListener
extends TestListenerAdapter {
    @Override
    public void onTestFailure(ITestResult result) {
        super.onTestFailure(result);
        Object instance = result.getInstance();
        if (CommonFixture.class.isInstance(instance)) {
            CommonFixture fixture = (CommonFixture)CommonFixture.class.cast(instance);
            result.setAttribute("request", fixture.getRequest());
            result.setAttribute("response", fixture.getResponse());
        }
    }

    String getRequestMessageInfo(ClientRequest req) {
        if (null == req) {
            return "No request message.";
        }
        StringBuilder msgInfo = new StringBuilder();
        msgInfo.append("Method: ").append(req.getMethod()).append('\n');
        msgInfo.append("Target URI: ").append(req.getURI()).append('\n');
        msgInfo.append("Headers: ").append(req.getHeaders()).append('\n');
        if (null != req.getEntity()) {
            String body;
            Object entity = req.getEntity();
            if (Document.class.isInstance(entity)) {
                Document doc = (Document)Document.class.cast(entity);
                body = XMLUtils.writeNodeToString(doc);
            } else {
                body = entity.toString();
            }
            msgInfo.append(body).append('\n');
        }
        return msgInfo.toString();
    }

    String getResponseMessageInfo(ClientResponse rsp) {
        if (null == rsp) {
            return "No response message.";
        }
        StringBuilder msgInfo = new StringBuilder();
        msgInfo.append("Status: ").append(rsp.getStatus()).append('\n');
        msgInfo.append("Headers: ").append(rsp.getHeaders()).append('\n');
        if (rsp.hasEntity()) {
            if (rsp.getType().isCompatible(MediaType.APPLICATION_XML_TYPE)) {
                Document doc = ClientUtils.getResponseEntityAsDocument(rsp, null);
                msgInfo.append(XMLUtils.writeNodeToString(doc));
            } else {
                byte[] body = rsp.getEntity(byte[].class);
                msgInfo.append(new String(body, StandardCharsets.UTF_8));
            }
            msgInfo.append('\n');
        }
        return msgInfo.toString();
    }
}

