/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.collections;

import io.restassured.http.ContentType;
import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opengis.cite.ogcapifeatures10.CommonDataFixture;
import org.opengis.cite.ogcapifeatures10.SuiteAttribute;
import org.opengis.cite.ogcapifeatures10.openapi3.OpenApiUtils;
import org.opengis.cite.ogcapifeatures10.openapi3.TestPoint;
import org.opengis.cite.ogcapifeatures10.openapi3.UriBuilder;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class FeatureCollection
extends CommonDataFixture {
    private Map<String, Response> collectionIdAndResponse = new HashMap<String, Response>();

    @DataProvider(name="collections")
    public Object[][] collections(ITestContext testContext) {
        List testPointAndCollections = (List)testContext.getSuite().getAttribute(SuiteAttribute.COLLECTIONS.getName());
        int length = testPointAndCollections.size();
        Object[][] objects = new Object[length][];
        int i = 0;
        for (Map collection : testPointAndCollections) {
            objects[i++] = new Object[]{collection};
        }
        return objects;
    }

    @Test(description="Implements A.2.6. Feature Collection {root}/collections/{collectionId}, Abstract Test 11 (Requirement /req/core/sfc-md-op)", groups={"collection"}, dataProvider="collections", dependsOnGroups={"collections"})
    public void validateFeatureCollectionMetadataOperation(ITestContext testContext, Map<String, Object> collection) {
        String collectionId = (String)collection.get("id");
        Assert.assertNotNull(collectionId, "Id of the collection is not available");
        URI iut = (URI)testContext.getSuite().getAttribute(SuiteAttribute.IUT.getName());
        List<TestPoint> testPointsForNamedCollection = OpenApiUtils.retrieveTestPointsForCollectionMetadata(this.getApiModel(), iut, collectionId);
        if (testPointsForNamedCollection.isEmpty()) {
            throw new SkipException("Could not find collection with id " + collectionId + " in the OpenAPI document");
        }
        TestPoint testPoint = testPointsForNamedCollection.get(0);
        String testPointUri = new UriBuilder(testPoint).collectionName(collectionId).buildUrl();
        Response response = (Response)this.init().baseUri(testPointUri).accept(ContentType.JSON).when().request(Method.GET);
        ((ValidatableResponse)response.then()).statusCode(200);
        this.collectionIdAndResponse.put(collectionId, response);
    }

    @Test(description="Implements A.2.6. Feature Collection {root}/collections/{collectionId}, Abstract Test 12 (Requirement /req/core/sfc-md-success)", groups={"collection"}, dataProvider="collections", dependsOnMethods={"validateFeatureCollectionMetadataOperation"}, alwaysRun=true)
    public void validateFeatureCollectionMetadataResponse(Map<String, Object> collection) {
        String collectionId = (String)collection.get("id");
        Assert.assertNotNull(collectionId, "Id of the collection is not available");
        Response response = this.collectionIdAndResponse.get(collectionId);
        if (response == null) {
            throw new SkipException("Could not find a response for collection with id " + collectionId);
        }
        JsonPath jsonPath = response.jsonPath();
        this.assertEqualStringContent(collection, jsonPath, "id");
        this.assertEqualStringContent(collection, jsonPath, "title");
        this.assertEqualStringContent(collection, jsonPath, "description");
        this.assertExtent(collection, jsonPath);
    }

    private void assertEqualStringContent(Map<String, Object> collection, JsonPath jsonPath, String property) {
        String idFromCollections = (String)collection.get(property);
        String idFromCollection = (String)jsonPath.get(property);
        Assert.assertEquals(idFromCollection, idFromCollections, property + " from collection is not equal to the collections " + property);
    }

    private void assertExtent(Map<String, Object> collection, JsonPath jsonPath) {
        Map idFromCollections = (Map)collection.get("extent");
        Map idFromCollection = jsonPath.getMap("extent");
        Assert.assertEquals(idFromCollection, idFromCollections, " extent from collection is not equal to the collections extent");
    }
}

