/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.landingpage;

import io.restassured.http.ContentType;
import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opengis.cite.ogcapifeatures10.CommonFixture;
import org.opengis.cite.ogcapifeatures10.EtsAssert;
import org.testng.annotations.Test;

public class LandingPage
extends CommonFixture {
    private JsonPath response;

    @Test(description="Implements A.2.2. Landing Page {root}/, Abstract Test 3 (Requirement /req/core/root-op)", groups={"landingpage"})
    public void landingPageRetrieval() {
        Response request = (Response)this.init().baseUri(this.rootUri.toString()).accept(ContentType.JSON).when().request(Method.GET, "/", new Object[0]);
        ((ValidatableResponse)request.then()).statusCode(200);
        this.response = request.jsonPath();
    }

    @Test(description="Implements A.2.2. Landing Page {root}/, Abstract Test 4 (Requirement /req/core/root-success)", groups={"landingpage"}, dependsOnMethods={"landingPageRetrieval"})
    public void landingPageValidation() {
        List<Object> links = this.response.getList("links");
        Set<String> linkTypes = this.collectLinkTypes(links);
        boolean expectedLinkTypesExists = (linkTypes.contains("service-desc") || linkTypes.contains("service-doc")) && linkTypes.contains("conformance") && linkTypes.contains("data");
        EtsAssert.assertTrue(expectedLinkTypesExists, "The landing page must include at least links with relation type 'service-desc' or 'service-doc', 'conformance' and 'data', but contains " + String.join((CharSequence)", ", linkTypes));
    }

    private Set<String> collectLinkTypes(List<Object> links) {
        HashSet<String> linkTypes = new HashSet<String>();
        for (Object link : links) {
            Map linkMap = (Map)link;
            Object linkType = linkMap.get("rel");
            linkTypes.add((String)linkType);
        }
        return linkTypes;
    }
}

