/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10;

import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.cite.ogcapifeatures10.OgcApiFeatures10;
import org.opengis.cite.ogcapifeatures10.conformance.crs.query.crs.CoordinateSystem;

public class EtsAssert {
    private static Envelope CRS84_BBOX = new Envelope(-180.0, 180.0, -90.0, 90.0);

    public static void assertTrue(boolean valueToAssert, String failureMsg) {
        if (!valueToAssert) {
            throw new AssertionError((Object)failureMsg);
        }
    }

    public static void assertFalse(boolean valueToAssert, String failureMsg) {
        if (valueToAssert) {
            throw new AssertionError((Object)failureMsg);
        }
    }

    public static void assertValidCrsIdentifier(CoordinateSystem coordinateSystem, String failureMsg) {
        if (coordinateSystem == null) {
            throw new AssertionError((Object)failureMsg);
        }
        if (!coordinateSystem.isValid()) {
            throw new AssertionError((Object)failureMsg);
        }
    }

    public static CoordinateSystem assertDefaultCrs(List<String> valueToAssert, String failureMsg) {
        if (valueToAssert.contains("http://www.opengis.net/def/crs/OGC/1.3/CRS84")) {
            return OgcApiFeatures10.DEFAULT_CRS;
        }
        if (valueToAssert.contains("http://www.opengis.net/def/crs/OGC/1.3/CRS84h")) {
            return OgcApiFeatures10.DEFAULT_CRS_WITH_HEIGHT;
        }
        throw new AssertionError((Object)failureMsg);
    }

    public static void assertDefaultCrsAtFirst(List<String> valueToAssert, String failureMsg) {
        if (!valueToAssert.isEmpty()) {
            String firstCrs = valueToAssert.get(0);
            if ("http://www.opengis.net/def/crs/OGC/1.3/CRS84".equals(firstCrs)) {
                return;
            }
            if ("http://www.opengis.net/def/crs/OGC/1.3/CRS84h".equals(firstCrs)) {
                return;
            }
        }
        throw new AssertionError((Object)failureMsg);
    }

    public static void assertDefaultCrs(String crsHeaderValue, String failureMsg) {
        if (!crsHeaderValue.matches("<http://www.opengis.net/def/crs/OGC/1.3/CRS84>") && !crsHeaderValue.matches("<http://www.opengis.net/def/crs/OGC/1.3/CRS84h>")) {
            throw new AssertionError((Object)failureMsg);
        }
    }

    public static void assertCrsHeader(String crsHeaderValue, CoordinateSystem expectedCrs, String failureMsg) {
        if (!crsHeaderValue.matches(expectedCrs.getAsHeaderValue())) {
            throw new AssertionError((Object)failureMsg);
        }
    }

    public static void assertDefaultCrsHeader(String crsHeaderValue, String failureMsg) {
        if (!crsHeaderValue.matches("<http://www.opengis.net/def/crs/OGC/1.3/CRS84>") && !crsHeaderValue.matches("<http://www.opengis.net/def/crs/OGC/1.3/CRS84h>")) {
            throw new AssertionError((Object)failureMsg);
        }
    }

    public static void assertInCrs84(Geometry geometry, String failureMsg) {
        if (geometry == null) {
            return;
        }
        if (!CRS84_BBOX.contains(geometry.getEnvelopeInternal())) {
            throw new AssertionError((Object)failureMsg);
        }
    }
}

