/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.conformance.crs.discovery.collection;

import io.restassured.path.json.JsonPath;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opengis.cite.ogcapifeatures10.EtsAssert;
import org.opengis.cite.ogcapifeatures10.conformance.SuiteAttribute;
import org.opengis.cite.ogcapifeatures10.conformance.crs.discovery.collection.AbstractDiscoveryCollection;
import org.opengis.cite.ogcapifeatures10.conformance.crs.query.crs.CoordinateSystem;
import org.opengis.cite.ogcapifeatures10.util.JsonUtils;
import org.testng.ITestContext;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

public class DiscoveryCollectionDefaultCrs
extends AbstractDiscoveryCollection {
    private Map<String, CoordinateSystem> collectionIdAndDefaultCrs = new HashMap<String, CoordinateSystem>();

    @AfterClass
    public void storeCollectionInTestContext(ITestContext testContext) {
        testContext.getSuite().setAttribute(SuiteAttribute.COLLECTION_DEFAULT_CRS_BY_ID.getName(), this.collectionIdAndDefaultCrs);
    }

    @Test(description="Implements A.1 Discovery, Abstract Test 2 (Requirement /req/crs/fc-md-crs-list B), crs property contains default crs in the collection object in the path /collection", dataProvider="collectionIdAndJson", dependsOnGroups={"crs-conformance"}, groups={"crs-discovery"})
    public void verifyCollectionCrsIdentifierOfCrsProperty(String collectionId, JsonPath collection) {
        Object extent = collection.get("extent");
        if (JsonUtils.hasAtLeastOneSpatialFeatureCollection(extent)) {
            List<String> crs = JsonUtils.parseAsList("crs", collection);
            CoordinateSystem defaultCrs = EtsAssert.assertDefaultCrs(crs, String.format("Collection with id '%s' does not specify one of the default CRS '%s' or '%s' but provides at least one spatial feature collections", collectionId, "http://www.opengis.net/def/crs/OGC/1.3/CRS84", "http://www.opengis.net/def/crs/OGC/1.3/CRS84h"));
            this.collectionIdAndDefaultCrs.put(collectionId, defaultCrs);
        }
    }
}

