/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.conformance.crs.discovery.collections;

import io.restassured.path.json.JsonPath;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opengis.cite.ogcapifeatures10.conformance.CommonDataFixture;
import org.opengis.cite.ogcapifeatures10.conformance.SuiteAttribute;
import org.opengis.cite.ogcapifeatures10.openapi3.TestPoint;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;

public class AbstractDiscoveryCollections
extends CommonDataFixture {
    private Map<TestPoint, JsonPath> collectionsResponses;
    private List<Map<String, Object>> collections;

    @BeforeClass
    public void retrieveRequiredInformationFromTestContext(ITestContext testContext) {
        this.collectionsResponses = (Map)testContext.getSuite().getAttribute(SuiteAttribute.COLLECTIONS_RESPONSE.getName());
        this.collections = (List)testContext.getSuite().getAttribute(SuiteAttribute.COLLECTIONS.getName());
    }

    @DataProvider(name="collectionsResponses")
    public Iterator<Object[]> collectionsResponses(ITestContext testContext) {
        ArrayList<Object[]> collectionsData = new ArrayList<Object[]>();
        for (Map.Entry<TestPoint, JsonPath> collectionsResponse : this.collectionsResponses.entrySet()) {
            collectionsData.add(new Object[]{collectionsResponse.getKey(), collectionsResponse.getValue()});
        }
        return collectionsData.iterator();
    }

    @DataProvider(name="collectionItemUris")
    public Iterator<Object[]> collectionItemUris(ITestContext testContext) {
        TestPoint testPoint = (TestPoint)this.collectionsResponses.keySet().stream().findFirst().get();
        JsonPath jsonPath = this.collectionsResponses.get(testPoint);
        ArrayList<Object[]> collectionsData = new ArrayList<Object[]>();
        for (Map<String, Object> collection : this.collections) {
            collectionsData.add(new Object[]{testPoint, jsonPath, collection});
        }
        return collectionsData.iterator();
    }
}

