/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.conformance.crs.query.bboxcrs;

import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.opengis.cite.ogcapifeatures10.conformance.crs.query.bboxcrs.AbstractBBoxCrs;
import org.opengis.cite.ogcapifeatures10.util.BBox;
import org.opengis.cite.ogcapifeatures10.util.JsonUtils;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class BBoxCrsParameterInvalid
extends AbstractBBoxCrs {
    private static final BBox invalidBBox = new BBox(5.0, 49.0, 6.0, 50.0);

    @DataProvider(name="collectionIdAndJson")
    public Iterator<Object[]> collectionIdAndJson(ITestContext testContext) {
        ArrayList<Object[]> collectionsData = new ArrayList<Object[]>();
        for (Map.Entry collection : this.collectionsResponses.entrySet()) {
            collectionsData.add(new Object[]{collection.getKey(), collection.getValue()});
        }
        return collectionsData.iterator();
    }

    @Test(description="Implements A.2.2 Query, Parameter bbox-crs, Abstract Test 9 (Requirement /conf/crs/bbox-crs-parameter-invalid)", dataProvider="collectionIdAndJson", dependsOnGroups={"crs-conformance"}, priority=1)
    public void verifyBboxCrsParameterInvalid(String collectionId, JsonPath collection) {
        String featuredUrl = JsonUtils.findFeaturesUrlForGeoJson(this.rootUri, collection);
        if (featuredUrl == null) {
            throw new SkipException("Could not find url for collection with id " + collectionId + " supporting GeoJson (type " + "application/geo+json" + ")");
        }
        BBox bbox = JsonUtils.parseSpatialExtent((Map)collection.get());
        if (bbox == null) {
            throw new SkipException("Collection with id " + collectionId + " has no spatial extent");
        }
        Response responseWithBBox = (Response)this.init().baseUri(featuredUrl).param("bbox-crs", new Object[]{"http://www.opengis.net/def/crs/0/unsupported"}).param("bbox", new Object[]{invalidBBox.asQueryParameter()}).accept("application/geo+json").when().request(Method.GET);
        ((ValidatableResponse)responseWithBBox.then()).statusCode(400);
    }
}

