/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.conformance.crs.query.crs.features;

import io.restassured.path.json.JsonPath;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opengis.cite.ogcapifeatures10.conformance.CommonFixture;
import org.opengis.cite.ogcapifeatures10.conformance.SuiteAttribute;
import org.opengis.cite.ogcapifeatures10.conformance.crs.query.crs.CoordinateSystem;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;

public class AbstractFeaturesCrs
extends CommonFixture {
    private Map<String, JsonPath> collectionsResponses;
    private Map<String, List<CoordinateSystem>> collectionIdToCrs;
    private Map<String, CoordinateSystem> collectionIdToDefaultCrs;

    @BeforeClass
    public void retrieveRequiredInformationFromTestContext(ITestContext testContext) {
        this.collectionsResponses = (Map)testContext.getSuite().getAttribute(SuiteAttribute.COLLECTION_BY_ID.getName());
        this.collectionIdToCrs = (Map)testContext.getSuite().getAttribute(SuiteAttribute.COLLECTION_CRS_BY_ID.getName());
        this.collectionIdToDefaultCrs = (Map)testContext.getSuite().getAttribute(SuiteAttribute.COLLECTION_DEFAULT_CRS_BY_ID.getName());
    }

    @DataProvider(name="collectionIdAndJson")
    public Iterator<Object[]> collectionIdAndJson(ITestContext testContext) {
        ArrayList<Object[]> collectionsData = new ArrayList<Object[]>();
        for (Map.Entry<String, JsonPath> collection : this.collectionsResponses.entrySet()) {
            String collectionId = collection.getKey();
            JsonPath json = collection.getValue();
            collectionsData.add(new Object[]{collectionId, json});
        }
        return collectionsData.iterator();
    }

    @DataProvider(name="collectionIdAndJsonAndCrs")
    public Iterator<Object[]> collectionIdAndJsonAndCrs(ITestContext testContext) {
        ArrayList<Object[]> collectionsData = new ArrayList<Object[]>();
        for (Map.Entry<String, JsonPath> collection : this.collectionsResponses.entrySet()) {
            String collectionId = collection.getKey();
            JsonPath json = collection.getValue();
            for (CoordinateSystem crs : this.collectionIdToCrs.get(collectionId)) {
                collectionsData.add(new Object[]{collectionId, json, crs});
            }
        }
        return collectionsData.iterator();
    }

    @DataProvider(name="collectionIdAndJsonAndCrsAndDefaultCrs")
    public Iterator<Object[]> collectionIdAndJsonAndCrsAndDefaultCrs(ITestContext testContext) {
        ArrayList<Object[]> collectionsData = new ArrayList<Object[]>();
        for (Map.Entry<String, JsonPath> collection : this.collectionsResponses.entrySet()) {
            String collectionId = collection.getKey();
            JsonPath json = collection.getValue();
            CoordinateSystem defaultCrs = this.collectionIdToDefaultCrs.get(collectionId);
            if (defaultCrs == null) continue;
            for (CoordinateSystem crs : this.collectionIdToCrs.get(collectionId)) {
                collectionsData.add(new Object[]{collectionId, json, crs, defaultCrs});
            }
        }
        return collectionsData.iterator();
    }
}

