/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.jsonoverlay.gen;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.reprezen.jsonoverlay.BooleanOverlay;
import com.reprezen.jsonoverlay.Builder;
import com.reprezen.jsonoverlay.EnumOverlay;
import com.reprezen.jsonoverlay.IJsonOverlay;
import com.reprezen.jsonoverlay.IModelPart;
import com.reprezen.jsonoverlay.IntegerOverlay;
import com.reprezen.jsonoverlay.JsonOverlay;
import com.reprezen.jsonoverlay.ListOverlay;
import com.reprezen.jsonoverlay.MapOverlay;
import com.reprezen.jsonoverlay.NumberOverlay;
import com.reprezen.jsonoverlay.ObjectOverlay;
import com.reprezen.jsonoverlay.OverlayFactory;
import com.reprezen.jsonoverlay.Primitive;
import com.reprezen.jsonoverlay.PrimitiveOverlay;
import com.reprezen.jsonoverlay.PropertiesOverlay;
import com.reprezen.jsonoverlay.ReferenceManager;
import com.reprezen.jsonoverlay.StringOverlay;
import com.reprezen.jsonoverlay.gen.SimpleJavaGenerator;
import com.reprezen.jsonoverlay.gen.TypeData;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Generated;

public abstract class TypeGenerator {
    private File dir;
    protected String intfPackage;
    protected String implPackage;
    protected String suffix;
    private boolean preserve;
    private Set<String> requiredTypes = new HashSet<String>();
    private static Set<String> autoTypes = TypeGenerator.getAutoTypes();
    private static Map<String, String> knownTypes = TypeGenerator.getKnownTypes();

    public TypeGenerator(File dir2, String intfPackage, String implPackage, String suffix, boolean preserve) {
        this.dir = dir2;
        this.intfPackage = intfPackage;
        this.implPackage = implPackage;
        this.suffix = suffix;
        this.preserve = preserve;
    }

    protected abstract TypeDeclaration<?> getTypeDeclaration(TypeData.Type var1, String var2);

    public void generate(TypeData.Type type) throws IOException {
        String filename = String.format("%s%s.java", type.getName(), this.suffix);
        File javaFile = new File(this.dir, filename);
        System.out.println("Generating " + javaFile.getCanonicalFile());
        CompilationUnit existing = this.preserve && javaFile.exists() ? this.tryParse(javaFile) : null;
        TypeDeclaration<?> declaration = this.getTypeDeclaration(type, this.suffix);
        SimpleJavaGenerator gen = new SimpleJavaGenerator(this.getPackage(), declaration);
        if (existing != null) {
            this.copyFileComment(gen, existing);
            this.addManualMembers(gen, existing);
        }
        this.requireTypes(this.getImports(type));
        if (this.needIntfImports()) {
            gen.addImport(this.intfPackage + ".*");
        }
        this.addGeneratedMembers(type, gen);
        this.requireTypes(Generated.class);
        this.resolveImports(type, gen);
        Files.write(javaFile.toPath(), gen.format().getBytes(Charset.forName("UTF-8")), new OpenOption[0]);
    }

    protected abstract String getPackage();

    protected abstract Collection<String> getImports(TypeData.Type var1);

    protected boolean needIntfImports() {
        return false;
    }

    protected void requireTypes(Class<?> ... types) {
        this.requireTypes(Stream.of(types).map(Class::getSimpleName).collect(Collectors.toList()));
    }

    protected void requireTypes(TypeData.Type ... types) {
        this.requireTypes(Stream.of(types).map(TypeData.Type::getName).collect(Collectors.toList()));
    }

    protected void requireTypes(String ... types) {
        this.requireTypes(Arrays.asList(types));
    }

    protected void requireTypes(Collection<String> types) {
        this.requiredTypes.addAll(types.stream().map(t -> t.contains("<") ? t.substring(0, t.indexOf("<")) : t).collect(Collectors.toList()));
    }

    private void resolveImports(TypeData.Type type, SimpleJavaGenerator gen) {
        Map<String, String> importMap = type.getTypeData().getImports();
        Map<String, TypeData.Type> typeMap = type.getTypeData().getTypeMap();
        for (String requiredType : this.requiredTypes) {
            gen.addImport(this.resolveImport(requiredType, typeMap, importMap));
        }
    }

    private static Set<String> getAutoTypes() {
        HashSet<String> results = new HashSet<String>();
        List<Class> autos = Arrays.asList(String.class, Integer.class, Number.class, Boolean.class, Primitive.class, Object.class);
        for (Class cls : autos) {
            results.add(cls.getSimpleName());
        }
        return results;
    }

    private static Map<String, String> getKnownTypes() {
        HashMap<String, String> results = new HashMap<String, String>();
        List<Class> overlays = Arrays.asList(Generated.class, List.class, Map.class, Optional.class, Collectors.class, JsonNode.class, ObjectNode.class, JsonNodeFactory.class, JsonPointer.class, IJsonOverlay.class, JsonOverlay.class, IModelPart.class, PropertiesOverlay.class, OverlayFactory.class, Builder.class, ReferenceManager.class, StringOverlay.class, IntegerOverlay.class, NumberOverlay.class, BooleanOverlay.class, EnumOverlay.class, PrimitiveOverlay.class, ObjectOverlay.class, ListOverlay.class, MapOverlay.class);
        for (Class cls : overlays) {
            results.put(cls.getSimpleName(), cls.getName().replaceAll("\\$", "."));
        }
        return results;
    }

    private String resolveImport(String type, Map<String, TypeData.Type> typeMap, Map<String, String> importMap) {
        if (importMap.containsKey(type)) {
            String imp = importMap.get(type);
            if (imp.equals("_intf")) {
                return this.intfPackage + "." + type;
            }
            if (imp.equals("_impl")) {
                return this.implPackage + "." + type;
            }
            return imp;
        }
        if (typeMap.containsKey(type)) {
            return this.intfPackage + "." + type;
        }
        if (!this.suffix.isEmpty() && type.endsWith(this.suffix) && typeMap.containsKey(type.substring(0, type.length() - this.suffix.length()))) {
            return this.implPackage + "." + type;
        }
        if (autoTypes.contains(type)) {
            return null;
        }
        if (knownTypes.containsKey(type)) {
            return knownTypes.get(type);
        }
        throw new RuntimeException("Unable to resolve import for type: " + type);
    }

    protected void addGeneratedMembers(TypeData.Type type, SimpleJavaGenerator gen) {
        Members members = new Members();
        members.addAll(this.getConstructors(type));
        for (TypeData.Field field : type.getFields().values()) {
            if (this.skipField(field)) continue;
            members.addAll(this.getFieldMembers(field));
        }
        for (TypeData.Field field : type.getFields().values()) {
            if (this.skipField(field)) continue;
            members.addAll(this.getFieldMethods(field));
        }
        members.addAll(this.getOtherMembers(type));
        for (SimpleJavaGenerator.Member member : members) {
            this.maybeRename(member, type.getRenames());
        }
        gen.addGeneratedMembers(members);
    }

    private void maybeRename(SimpleJavaGenerator.Member member, Map<String, String> renames) {
        String name = member.getName();
        if (name != null && renames.containsKey(name)) {
            member.rename(name, renames.get(name));
        }
    }

    protected boolean skipField(TypeData.Field field) {
        return false;
    }

    private CompilationUnit tryParse(File file) {
        try {
            return JavaParser.parse((File)file);
        }
        catch (IOException e) {
            System.err.println("ABORTING AFTER PARTIAL GENERATION!");
            System.err.printf("Parsing of file %s failed; so generation cannot continue without destroying manual code.\n", file);
            System.err.println("Please restore generated code artifacts to a known good state before regenerating");
            System.err.println("Parse Error:");
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    private void copyFileComment(SimpleJavaGenerator gen, CompilationUnit existing) {
        Optional fileComment = existing.getComment();
        if (fileComment.isPresent()) {
            gen.setFileComment(((Comment)fileComment.get()).toString());
        }
    }

    private void addManualMembers(SimpleJavaGenerator gen, CompilationUnit existing) {
        for (TypeDeclaration type : existing.getTypes()) {
            for (BodyDeclaration member : type.getMembers()) {
                if (!(member instanceof MethodDeclaration) && !(member instanceof FieldDeclaration) && !(member instanceof ConstructorDeclaration) || this.isGenerated(member)) continue;
                gen.addMember(new SimpleJavaGenerator.Member(member));
            }
        }
    }

    private boolean isGenerated(BodyDeclaration<?> node) {
        for (AnnotationExpr annotation : node.getAnnotations()) {
            if (!annotation.getName().toString().equals("Generated")) continue;
            return true;
        }
        return false;
    }

    protected Members getConstructors(TypeData.Type type) {
        return new Members();
    }

    protected Members getFieldMembers(TypeData.Field field) {
        return new Members();
    }

    protected Members getFieldMethods(TypeData.Field field) {
        return new Members();
    }

    protected Members getOtherMembers(TypeData.Type type) {
        return new Members();
    }

    protected SimpleJavaGenerator.Member addMember(BodyDeclaration<?> declaration, Collection<String> code) {
        return this.addMember(declaration, null);
    }

    protected final SimpleJavaGenerator.Member addMember(BodyDeclaration<?> declaration) {
        return this.addMember(declaration, null);
    }

    protected static class Members
    extends ArrayList<SimpleJavaGenerator.Member> {
        private static final long serialVersionUID = 1L;

        protected Members() {
        }

        public SimpleJavaGenerator.Member addMember(String code) {
            return this.addMember(new SimpleJavaGenerator.Member(code));
        }

        public SimpleJavaGenerator.Member addMember(SimpleJavaGenerator.Member member) {
            this.add(member);
            return member;
        }
    }
}

