/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.conformance.core.collections;

import com.reprezen.kaizen.oasparser.model3.Parameter;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.opengis.cite.ogcapifeatures10.EtsAssert;
import org.opengis.cite.ogcapifeatures10.OgcApiFeatures10;
import org.opengis.cite.ogcapifeatures10.conformance.CommonDataFixture;
import org.opengis.cite.ogcapifeatures10.conformance.SuiteAttribute;
import org.opengis.cite.ogcapifeatures10.conformance.core.collections.FeaturesAssertions;
import org.opengis.cite.ogcapifeatures10.openapi3.OpenApiUtils;
import org.opengis.cite.ogcapifeatures10.openapi3.TestPoint;
import org.opengis.cite.ogcapifeatures10.util.JsonUtils;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;

public class AbstractFeatures
extends CommonDataFixture {
    protected final Map<CollectionResponseKey, ResponseData> collectionIdAndResponse = new HashMap<CollectionResponseKey, ResponseData>();
    protected List<Map<String, Object>> collections;
    protected URI iut;

    @DataProvider(name="collectionPaths")
    public Iterator<Object[]> collectionPaths(ITestContext testContext) {
        List<TestPoint> testPointsForCollections = OpenApiUtils.retrieveTestPointsForCollections(this.getApiModel(), this.iut, this.noOfCollections);
        ArrayList<Object[]> collectionsData = new ArrayList<Object[]>();
        for (TestPoint testPointForCollections : testPointsForCollections) {
            collectionsData.add(new Object[]{testPointForCollections});
        }
        return collectionsData.iterator();
    }

    @BeforeClass
    public void retrieveRequiredInformationFromTestContext(ITestContext testContext) {
        this.iut = (URI)testContext.getSuite().getAttribute(SuiteAttribute.IUT.getName());
        this.collections = (List)testContext.getSuite().getAttribute(SuiteAttribute.COLLECTIONS.getName());
    }

    public void validateTypeProperty(CollectionResponseKey collection) {
        ResponseData response = this.collectionIdAndResponse.get(collection);
        if (response == null) {
            throw new SkipException("Could not find a response for collection with id " + collection.id);
        }
        JsonPath jsonPath = response.jsonPath();
        String type = (String)jsonPath.get("type");
        Assert.assertNotNull(type, "type property is missing");
        Assert.assertEquals(type, "FeatureCollection", "Expected type property value of FeatureCollection but was " + type);
    }

    void validateFeaturesProperty(CollectionResponseKey collection) {
        ResponseData response = this.collectionIdAndResponse.get(collection);
        if (response == null) {
            throw new SkipException("Could not find a response for collection with id " + collection.id);
        }
        JsonPath jsonPath = response.jsonPath();
        List type = (List)jsonPath.get("features");
        Assert.assertNotNull(type, "features property is missing:");
    }

    void validateLinks(CollectionResponseKey collection) {
        ResponseData response = this.collectionIdAndResponse.get(collection);
        if (response == null) {
            throw new SkipException("Could not find a response for collection with id " + collection.id);
        }
        JsonPath jsonPath = response.jsonPath();
        List<Map<String, Object>> links = jsonPath.getList("links");
        Map<String, Object> linkToSelf = JsonUtils.findLinkByRel(links, "self");
        Assert.assertNotNull(linkToSelf, "Feature Collection Metadata document must include a link for itself");
        List<String> mediaTypesToSupport = this.createListOfMediaTypesToSupportForFeatureCollectionsAndFeatures(linkToSelf);
        List<Map<String, Object>> alternateLinks = JsonUtils.findLinksWithSupportedMediaTypeByRel(links, mediaTypesToSupport, "alternate");
        List<String> typesWithoutLink = JsonUtils.findUnsupportedTypes(alternateLinks, mediaTypesToSupport);
        EtsAssert.assertTrue(typesWithoutLink.isEmpty(), "Feature Collection Metadata document must include links for alternate encodings. Missing links for types " + typesWithoutLink);
        HashSet<String> rels = new HashSet<String>();
        rels.add("self");
        rels.add("alternate");
        List<String> linksWithoutRelOrType = JsonUtils.findLinksWithoutRelOrType(links, rels);
        EtsAssert.assertTrue(linksWithoutRelOrType.isEmpty(), "Links for alternate encodings must include a rel and type parameter. Missing for links " + linksWithoutRelOrType);
    }

    public void validateTimeStamp(CollectionResponseKey collection) {
        ResponseData response = this.collectionIdAndResponse.get(collection);
        if (response == null) {
            throw new SkipException("Could not find a response for collection with id " + collection.id);
        }
        JsonPath jsonPath = response.jsonPath();
        FeaturesAssertions.assertTimeStamp(collection.id, jsonPath, response.timeStampBeforeResponse, response.timeStampAfterResponse, true);
    }

    void validateNumberMatched(CollectionResponseKey collection) throws URISyntaxException {
        ResponseData response = this.collectionIdAndResponse.get(collection);
        if (response == null) {
            throw new SkipException("Could not find a response for collection with id " + collection.id);
        }
        JsonPath jsonPath = response.jsonPath();
        FeaturesAssertions.assertNumberMatched(this.getApiModel(), this.iut, collection.id, jsonPath, true);
    }

    void validateNumberReturned(CollectionResponseKey collection) {
        ResponseData response = this.collectionIdAndResponse.get(collection);
        if (response == null) {
            throw new SkipException("Could not find a response for collection with id " + collection.id);
        }
        JsonPath jsonPath = response.jsonPath();
        FeaturesAssertions.assertNumberReturned(collection.id, jsonPath, true);
    }

    void validateGeometriesInCrs84(CollectionResponseKey collection) throws ParseException {
        ResponseData response = this.collectionIdAndResponse.get(collection);
        if (response == null) {
            throw new SkipException("Could not find a response for collection with id " + collection.id);
        }
        JsonPath jsonPath = response.jsonPath();
        List features = jsonPath.getList("features");
        for (Map feature : features) {
            String featureId = feature.get("id").toString();
            Geometry geometry = JsonUtils.parseFeatureGeometry(feature, OgcApiFeatures10.DEFAULT_CRS);
            EtsAssert.assertInCrs84(geometry, String.format("Geometry of feature with id {} in collection with id {} is outside the valid area of the  ", featureId, collection.id));
        }
    }

    protected boolean isRequired(Parameter param) {
        return param.getRequired() != null && param.getRequired() != false;
    }

    protected Boolean isExplode(Parameter param) {
        return param.getExplode() != null && param.getExplode() != false;
    }

    protected class CollectionResponseKey {
        private final String id;

        protected CollectionResponseKey(String id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CollectionResponseKey that = (CollectionResponseKey)o;
            return Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }

    protected class ResponseData {
        private final Response response;
        protected final ZonedDateTime timeStampBeforeResponse;
        protected final ZonedDateTime timeStampAfterResponse;

        public ResponseData(Response response, ZonedDateTime timeStampBeforeResponse, ZonedDateTime timeStampAfterResponse) {
            this.response = response;
            this.timeStampBeforeResponse = timeStampBeforeResponse;
            this.timeStampAfterResponse = timeStampAfterResponse;
        }

        public JsonPath jsonPath() {
            return this.response.jsonPath();
        }
    }
}

