/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.conformance.crs.query.crs.feature;

import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opengis.cite.ogcapifeatures10.EtsAssert;
import org.opengis.cite.ogcapifeatures10.conformance.crs.query.crs.CoordinateSystem;
import org.opengis.cite.ogcapifeatures10.conformance.crs.query.crs.feature.AbstractFeatureCrs;
import org.opengis.cite.ogcapifeatures10.util.JsonUtils;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class FeatureCrsParameter
extends AbstractFeatureCrs {
    @DataProvider(name="collectionFeatureIdCrs")
    public Iterator<Object[]> collectionFeatureIdCrs(ITestContext testContext) {
        ArrayList<Object[]> collectionsData = new ArrayList<Object[]>();
        for (Map.Entry collection : this.collectionsResponses.entrySet()) {
            String collectionId = (String)collection.getKey();
            String featureId = (String)this.collectionIdToFeatureId.get(collectionId);
            JsonPath json = (JsonPath)collection.getValue();
            for (CoordinateSystem crs : (List)this.collectionIdToCrs.get(collectionId)) {
                collectionsData.add(new Object[]{collectionId, json, featureId, crs});
            }
        }
        return collectionsData.iterator();
    }

    @Test(description="Implements A.2.1 Query, Parameter crs, Abstract Test 1 (Requirement /req/crs/fc-crs-definition, /req/crs/fc-crs-valid-value B, /req/crs/ogc-crs-header, /req/crs/ogc-crs-header-value, /req/crs/geojson), Content-Crs header in the path /collections/{collectionId}/items/{featureId}", dataProvider="collectionFeatureIdCrs", dependsOnGroups={"crs-conformance"}, priority=1)
    public void verifyFeatureCrsParameter(String collectionId, JsonPath collection, String featureId, CoordinateSystem crs) {
        String featureUrl = JsonUtils.findFeatureUrlForGeoJson(this.rootUri, collection, featureId);
        if (featureUrl == null) {
            throw new SkipException("Could not find url for collection with id " + collectionId + " supporting GeoJson (type " + "application/geo+json" + ")");
        }
        Response response = (Response)this.init().baseUri(featureUrl).queryParam("crs", crs.getCode()).accept("application/geo+json").when().request(Method.GET);
        ((ValidatableResponse)response.then()).statusCode(200);
        String actualHeader = response.getHeader("Content-Crs");
        if (actualHeader == null) {
            throw new AssertionError((Object)String.format("Feature response at '%s' does not provide the expected header 'Content-Crs'", featureUrl));
        }
        EtsAssert.assertCrsHeader(actualHeader, crs, String.format("Features response at '%s' does not provide expected 'Content-Crs' header, was: '%s', expected: '%s'", featureUrl, actualHeader, crs));
    }
}

