/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.conformance.crs.query.crs.features;

import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.opengis.cite.ogcapifeatures10.EtsAssert;
import org.opengis.cite.ogcapifeatures10.conformance.crs.query.crs.features.AbstractFeaturesCrs;
import org.opengis.cite.ogcapifeatures10.util.JsonUtils;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class FeaturesCrsParameterDefault
extends AbstractFeaturesCrs {
    @Test(description="Implements A.2.1 Query, Parameter crs, Abstract Test 6 (Requirement /req/crs/fc-crs-default-value, /req/crs/ogc-crs-header, /req/crs/ogc-crs-header-value), Default CRS requesting path /collections/{collectionId}/items", dataProvider="collectionIdAndJson", dependsOnGroups={"crs-conformance"}, priority=1)
    public void verifyFeaturesCrsParameterDefault(String collectionId, JsonPath collection) {
        String featuresUrl = JsonUtils.findFeaturesUrlForGeoJson(this.rootUri, collection);
        if (featuresUrl == null) {
            throw new SkipException("Could not find url for collection with id " + collectionId + " supporting GeoJson (type " + "application/geo+json" + ")");
        }
        Response response = (Response)this.init().baseUri(featuresUrl).accept("application/geo+json").when().request(Method.GET);
        ((ValidatableResponse)response.then()).statusCode(200);
        String actualHeader = response.getHeader("Content-Crs");
        if (actualHeader == null) {
            throw new AssertionError((Object)String.format("Features response at '%s' does not provide the expected header 'Content-Crs'", featuresUrl));
        }
        EtsAssert.assertDefaultCrsHeader(actualHeader, String.format("Features response at '%s' does not provide default 'Content-Crs' header, was: '%s', expected: '%s' or '%s", featuresUrl, actualHeader, "http://www.opengis.net/def/crs/OGC/1.3/CRS84", "http://www.opengis.net/def/crs/OGC/1.3/CRS84h"));
    }
}

