/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.conformance;

import io.restassured.RestAssured;
import io.restassured.filter.Filter;
import io.restassured.filter.log.RequestLoggingFilter;
import io.restassured.filter.log.ResponseLoggingFilter;
import io.restassured.specification.RequestSpecification;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.net.URI;
import org.opengis.cite.ogcapifeatures10.conformance.SuiteAttribute;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;

public class CommonFixture {
    private ByteArrayOutputStream requestOutputStream = new ByteArrayOutputStream();
    private ByteArrayOutputStream responseOutputStream = new ByteArrayOutputStream();
    protected RequestLoggingFilter requestLoggingFilter;
    protected ResponseLoggingFilter responseLoggingFilter;
    protected URI rootUri;

    @BeforeClass
    public void initCommonFixture(ITestContext testContext) {
        this.initLogging();
        this.rootUri = (URI)testContext.getSuite().getAttribute(SuiteAttribute.IUT.getName());
    }

    @BeforeMethod
    public void clearMessages() {
        this.initLogging();
    }

    public String getRequest() {
        return this.requestOutputStream.toString();
    }

    public String getResponse() {
        return this.responseOutputStream.toString();
    }

    protected RequestSpecification init() {
        return (RequestSpecification)RestAssured.given().filters((Filter)this.requestLoggingFilter, new Filter[]{this.responseLoggingFilter}).log().all();
    }

    private void initLogging() {
        this.requestOutputStream = new ByteArrayOutputStream();
        this.responseOutputStream = new ByteArrayOutputStream();
        PrintStream requestPrintStream = new PrintStream(this.requestOutputStream, true);
        PrintStream responsePrintStream = new PrintStream(this.responseOutputStream, true);
        this.requestLoggingFilter = new RequestLoggingFilter(requestPrintStream);
        this.responseLoggingFilter = new ResponseLoggingFilter(responsePrintStream);
    }
}

