/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.conformance.crs.discovery.collection;

import io.restassured.path.json.JsonPath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opengis.cite.ogcapifeatures10.EtsAssert;
import org.opengis.cite.ogcapifeatures10.conformance.SuiteAttribute;
import org.opengis.cite.ogcapifeatures10.conformance.crs.query.crs.CoordinateSystem;
import org.opengis.cite.ogcapifeatures10.util.JsonUtils;
import org.testng.ITestContext;
import org.testng.annotations.AfterClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DiscoveryCollectionCrsUri {
    private Map<String, List<CoordinateSystem>> collectionIdAndValidCrs = new HashMap<String, List<CoordinateSystem>>();

    @DataProvider(name="collectionIdAndJsonAndCrs")
    public Iterator<Object[]> collectionIdAndJsonAndCrs(ITestContext testContext) {
        Map collectionsResponses = (Map)testContext.getSuite().getAttribute(SuiteAttribute.COLLECTION_BY_ID.getName());
        ArrayList<Object[]> collectionsData = new ArrayList<Object[]>();
        for (Map.Entry collection : collectionsResponses.entrySet()) {
            List<CoordinateSystem> crs = this.parseCrs((JsonPath)collection.getValue());
            for (CoordinateSystem coordinateSystem : crs) {
                collectionsData.add(new Object[]{collection.getKey(), coordinateSystem});
            }
        }
        return collectionsData.iterator();
    }

    @DataProvider(name="collectionIdAndJsonAndStorageCrs")
    public Iterator<Object[]> collectionIdAndJsonAndStorageCrs(ITestContext testContext) {
        Map collectionsResponses = (Map)testContext.getSuite().getAttribute(SuiteAttribute.COLLECTION_BY_ID.getName());
        ArrayList<Object[]> collectionsData = new ArrayList<Object[]>();
        for (Map.Entry collection : collectionsResponses.entrySet()) {
            CoordinateSystem storageCrs = this.parseStorageCrs((JsonPath)collection.getValue());
            if (storageCrs == null) continue;
            collectionsData.add(new Object[]{collection.getKey(), storageCrs});
        }
        return collectionsData.iterator();
    }

    @AfterClass
    public void storeCollectionInTestContext(ITestContext testContext) {
        testContext.getSuite().setAttribute(SuiteAttribute.COLLECTION_CRS_BY_ID.getName(), this.collectionIdAndValidCrs);
    }

    @Test(description="Implements A.1 Discovery, Abstract Test 1 (Requirement /req/crs/crs-uri, /req/crs/fc-md-crs-list A, /req/crs/fc-md-storageCrs, /req/crs/fc-md-crs-list-global), crs property in the collection object in the path /collection", dataProvider="collectionIdAndJsonAndCrs", dependsOnGroups={"crs-conformance"}, groups={"crs-discovery"})
    public void verifyCollectionCrsIdentifierOfCrsProperty(String collectionId, CoordinateSystem crs) {
        this.addCrs(collectionId, crs);
        EtsAssert.assertValidCrsIdentifier(crs, String.format("Collection with id '%s' contains invalid CRS identifier property 'crs': '%s'", collectionId, crs));
    }

    @Test(description="Implements A.1 Discovery, Abstract Test 1 (Requirement /req/crs/crs-uri, /req/crs/fc-md-crs-list A, /req/crs/fc-md-storageCrs, /req/crs/fc-md-crs-list-global), storageCrs property in the collection object in the path /collection", dataProvider="collectionIdAndJsonAndStorageCrs", dependsOnGroups={"crs-conformance"}, groups={"crs-discovery"})
    public void verifyCollectionCrsIdentifierOfStorageCrsProperty(String collectionId, CoordinateSystem storageCrs) {
        EtsAssert.assertValidCrsIdentifier(storageCrs, String.format("Collection with id '%s' contains invalid CRS identifier property 'storageCrs': '%s'", collectionId, storageCrs));
    }

    private List<CoordinateSystem> parseCrs(JsonPath collection) {
        return JsonUtils.parseAsList("crs", collection).stream().map(crsValue -> new CoordinateSystem((String)crsValue)).collect(Collectors.toList());
    }

    private CoordinateSystem parseStorageCrs(JsonPath collection) {
        String storageCrs = JsonUtils.parseAsString(collection.get("storageCrs"));
        if (storageCrs == null) {
            return null;
        }
        return new CoordinateSystem(storageCrs);
    }

    private void addCrs(String collectionId, CoordinateSystem coordinateSystem) {
        this.collectionIdAndValidCrs.putIfAbsent(collectionId, new ArrayList());
        this.collectionIdAndValidCrs.get(collectionId).add(coordinateSystem);
    }
}

