/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.jsonoverlay.gen;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.comments.Comment;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.expr.Expression;
import com.reprezen.jsonoverlay.gen.CodeGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Generated;

public class SimpleJavaGenerator {
    private String pkg;
    private Set<String> imports = new HashSet<String>();
    private TypeDeclaration<?> type;
    private List<Member> members = new ArrayList<Member>();
    private String fileComment;
    private static int indentation = 4;

    public SimpleJavaGenerator(String pkg, TypeDeclaration<?> type) {
        this.pkg = pkg;
        this.type = type;
    }

    public String getPackage() {
        return this.pkg;
    }

    public void setPackage(String pkg) {
        this.pkg = pkg;
    }

    public int getIndentation() {
        return indentation;
    }

    public void setIndentation(int indentation) {
        SimpleJavaGenerator.indentation = indentation;
    }

    public Collection<Member> getMembers() {
        return this.members;
    }

    public void addMember(Member member) {
        this.members.add(member);
    }

    public void addMembers(Collection<Member> members) {
        this.members.addAll(members);
    }

    public void addGeneratedMembers(Collection<Member> members) {
        for (Member member : members) {
            this.members.add(member.generated());
        }
    }

    public void setFileComment(String fileComment) {
        this.fileComment = fileComment;
    }

    public void addImport(String imp) {
        if (imp != null) {
            this.imports.add(imp);
        }
    }

    public String format() {
        CompilationUnit cu = new CompilationUnit();
        if (this.fileComment != null) {
            cu.addOrphanComment((Comment)new JavadocComment(this.fileComment));
        }
        cu.setPackageDeclaration(this.pkg);
        for (String imp : this.imports) {
            cu.addImport(imp);
        }
        cu.addType(this.type);
        for (Member member : this.gatherFinalMembers(this.members, cu)) {
            this.type.addMember(member.getDeclaration());
        }
        return cu.toString();
    }

    private Collection<Member> gatherFinalMembers(List<Member> members, CompilationUnit cu) {
        LinkedHashMap<String, Member> memberMap = new LinkedHashMap<String, Member>();
        for (Member member : members) {
            String key = member.getKey();
            if (!memberMap.containsKey(key)) {
                memberMap.put(key, member);
                continue;
            }
            BodyDeclaration copy = member.getDeclaration().clone();
            if (copy instanceof ConstructorDeclaration) {
                ((ConstructorDeclaration)copy).setBody(JavaParser.parseBlock((String)"{}"));
                ((ConstructorDeclaration)copy).setComment(null);
            } else if (copy instanceof MethodDeclaration) {
                ((MethodDeclaration)copy).setBody(null);
                ((MethodDeclaration)copy).setComment(null);
            } else if (copy instanceof FieldDeclaration) {
                ((FieldDeclaration)copy).getVariable(0).setInitializer((Expression)null);
                ((FieldDeclaration)copy).setComment(null);
            }
            copy.setAnnotations(new NodeList());
            Logger.getGlobal().warning(String.format("Suppressing already-present generated member in type %s: %s", cu.getType(0).getNameAsString(), copy.toString()));
        }
        return memberMap.values();
    }

    public static class Member {
        protected BodyDeclaration<?> declaration;

        public Member(BodyDeclaration<?> declaration) {
            this.declaration = declaration;
        }

        public Member(String code) {
            try {
                this.declaration = JavaParser.parseBodyDeclaration((String)code);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                System.out.println(code);
            }
        }

        public Member generated() {
            this.declaration.addSingleMemberAnnotation(Generated.class, "\"" + CodeGenerator.class.getName() + "\"");
            return this;
        }

        public Member comment(String comment) {
            if (comment != null) {
                this.declaration.setLineComment(comment);
            } else {
                this.declaration.removeComment();
            }
            return this;
        }

        public Member override() {
            this.declaration.addMarkerAnnotation(Override.class);
            return this;
        }

        public Member rename(String from, String to) {
            if (this.declaration instanceof MethodDeclaration) {
                ((MethodDeclaration)this.declaration).setName(to);
            } else if (this.declaration instanceof FieldDeclaration) {
                for (VariableDeclarator var : ((FieldDeclaration)this.declaration).getVariables()) {
                    if (!var.getName().getIdentifier().equals(from)) continue;
                    var.setName(to);
                    break;
                }
            }
            return this;
        }

        public BodyDeclaration<?> getDeclaration() {
            return this.declaration;
        }

        public String getKey() {
            if (this.declaration instanceof FieldDeclaration) {
                FieldDeclaration field = (FieldDeclaration)this.declaration;
                if (field.getVariables().size() != 1) {
                    throw new RuntimeException("Multiple fields in a single manual field declaration is not yet supported: " + field.toString());
                }
                return "F:" + field.getVariable(0).getNameAsString();
            }
            if (this.declaration instanceof MethodDeclaration) {
                MethodDeclaration method = (MethodDeclaration)this.declaration;
                return "M:" + method.getNameAsString() + ":" + method.getParameters().stream().map(p -> p.getType().toString()).collect(Collectors.joining(","));
            }
            if (this.declaration instanceof ConstructorDeclaration) {
                ConstructorDeclaration constructor = (ConstructorDeclaration)this.declaration;
                return "C:" + constructor.getParameters().stream().map(p -> p.getType().toString()).collect(Collectors.joining(","));
            }
            throw new RuntimeException("Unsupported manual member type encountered: " + this.declaration.getClass().getName());
        }

        public String format() {
            return this.declaration.toString();
        }

        public String getName() {
            NodeList vars;
            if (this.declaration instanceof MethodDeclaration) {
                return ((MethodDeclaration)this.declaration).getNameAsString();
            }
            if (this.declaration instanceof FieldDeclaration && (vars = ((FieldDeclaration)this.declaration).getVariables()).size() == 1) {
                return ((VariableDeclarator)vars.get(0)).getNameAsString();
            }
            return null;
        }
    }
}

