/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.conformance.core.collections;

import io.restassured.http.ContentType;
import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.opengis.cite.ogcapifeatures10.EtsAssert;
import org.opengis.cite.ogcapifeatures10.conformance.CommonDataFixture;
import org.opengis.cite.ogcapifeatures10.conformance.SuiteAttribute;
import org.opengis.cite.ogcapifeatures10.openapi3.OpenApiUtils;
import org.opengis.cite.ogcapifeatures10.openapi3.TestPoint;
import org.opengis.cite.ogcapifeatures10.openapi3.UriBuilder;
import org.opengis.cite.ogcapifeatures10.util.JsonUtils;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.AfterClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class FeatureCollections
extends CommonDataFixture {
    private final Map<TestPoint, Response> testPointAndResponses = new HashMap<TestPoint, Response>();
    private final Map<TestPoint, List<Map<String, Object>>> testPointAndCollections = new HashMap<TestPoint, List<Map<String, Object>>>();
    private Object[][] testPointsData;

    @DataProvider(name="collectionsUris")
    public Object[][] collectionsUris(ITestContext testContext) {
        if (this.testPointsData == null) {
            URI iut = (URI)testContext.getSuite().getAttribute(SuiteAttribute.IUT.getName());
            List<TestPoint> testPoints = OpenApiUtils.retrieveTestPointsForCollectionsMetadata(this.getApiModel(), iut);
            this.testPointsData = new Object[testPoints.size()][];
            int i = 0;
            for (TestPoint testPoint : testPoints) {
                this.testPointsData[i++] = new Object[]{testPoint};
            }
        }
        return this.testPointsData;
    }

    @AfterClass
    public void storeCollectionsInTestContext(ITestContext testContext) {
        ArrayList<Map<String, Object>> collections = new ArrayList<Map<String, Object>>();
        for (List<Map<String, Object>> testPointAndCollection : this.testPointAndCollections.values()) {
            collections.addAll(testPointAndCollection);
        }
        testContext.getSuite().setAttribute(SuiteAttribute.COLLECTIONS.getName(), collections);
    }

    @AfterClass
    public void storeCollectionsResponseInTestContext(ITestContext testContext) {
        HashMap<TestPoint, JsonPath> collectionsResponses = new HashMap<TestPoint, JsonPath>();
        for (Map.Entry<TestPoint, Response> testPointAndResponse : this.testPointAndResponses.entrySet()) {
            if (testPointAndResponse.getValue() == null) continue;
            JsonPath jsonPath = testPointAndResponse.getValue().jsonPath();
            collectionsResponses.put(testPointAndResponse.getKey(), jsonPath);
        }
        testContext.getSuite().setAttribute(SuiteAttribute.COLLECTIONS_RESPONSE.getName(), collectionsResponses);
    }

    @Test(description="Implements A.2.5. Feature Collections {root}/collections, Abstract Test 9 (Requirement /req/core/fc-md-op)", groups={"collections"}, dataProvider="collectionsUris", dependsOnGroups={"apidefinition", "conformance"})
    public void validateFeatureCollectionsMetadataOperation(TestPoint testPoint) {
        String testPointUri = new UriBuilder(testPoint).buildUrl();
        Response response = (Response)this.init().baseUri(testPointUri).accept(ContentType.JSON).when().request(Method.GET);
        ((ValidatableResponse)response.then()).statusCode(200);
        this.testPointAndResponses.put(testPoint, response);
    }

    @Test(description="A.2.5. Feature Collections {root}/collections, Abstract Test 10, Test Method 1 (Requirement /req/core/fc-md-success, /req/core/crs84)", groups={"collections"}, dataProvider="collectionsUris", dependsOnMethods={"validateFeatureCollectionsMetadataOperation"}, alwaysRun=true)
    public void validateFeatureCollectionsMetadataOperationResponse_Links(TestPoint testPoint) {
        Response response = this.testPointAndResponses.get(testPoint);
        if (response == null) {
            throw new SkipException("Could not find a response for test point " + testPoint);
        }
        JsonPath jsonPath = response.jsonPath();
        List<Map<String, Object>> links = JsonUtils.parseAsListOfMaps("links", jsonPath);
        Map<String, Object> linkToSelf = JsonUtils.findLinkByRel(links, "self");
        Assert.assertNotNull(linkToSelf, "Feature Collections Metadata document must include a link for itself");
        EtsAssert.assertTrue(JsonUtils.linkIncludesRelAndType(linkToSelf), "Link to itself must include a rel and type parameter");
        List<String> mediaTypesToSupport = this.createListOfMediaTypesToSupportForOtherResources(linkToSelf);
        List<Map<String, Object>> alternateLinks = JsonUtils.findLinksWithSupportedMediaTypeByRel(links, mediaTypesToSupport, "alternate");
        List<String> typesWithoutLink = JsonUtils.findUnsupportedTypes(alternateLinks, mediaTypesToSupport);
        EtsAssert.assertTrue(typesWithoutLink.isEmpty(), "Feature Collections Metadata document must include links for alternate encodings. Missing links for types " + typesWithoutLink);
        HashSet<String> rels = new HashSet<String>();
        rels.add("self");
        rels.add("alternate");
        List<String> linksWithoutRelOrType = JsonUtils.findLinksWithoutRelOrType(alternateLinks, rels);
        EtsAssert.assertTrue(linksWithoutRelOrType.isEmpty(), "Links for alternate encodings must include a rel and type parameter. Missing for links " + linksWithoutRelOrType);
    }

    @Test(description="A.2.5. Feature Collections {root}/collections, Abstract Test 10, Test Method 2 (Requirement /req/core/fc-md-success, /req/core/crs84)", groups={"collections"}, dataProvider="collectionsUris", dependsOnMethods={"validateFeatureCollectionsMetadataOperation"}, alwaysRun=true)
    public void validateFeatureCollectionsMetadataOperationResponse_Items(TestPoint testPoint) {
        Response response = this.testPointAndResponses.get(testPoint);
        if (response == null) {
            throw new SkipException("Could not find a response for test point " + testPoint);
        }
        JsonPath jsonPath = response.jsonPath();
        List<Object> collections = jsonPath.getList("collections");
        this.testPointAndCollections.put(testPoint, this.createCollectionsMap(collections));
    }

    @Test(description="A.2.5. Feature Collections {root}/collections, Abstract Test 10, Test Method 3 (Requirement /req/core/fc-md-success, /req/core/crs84)", groups={"collections"}, dataProvider="collectionsUris", dependsOnMethods={"validateFeatureCollectionsMetadataOperation"}, alwaysRun=true)
    public void validateFeatureCollectionsMetadataOperationResponse_CrsProperty(TestPoint testPoint) {
        Response response = this.testPointAndResponses.get(testPoint);
        if (response == null) {
            throw new SkipException("Could not find a response for test point " + testPoint);
        }
        JsonPath jsonPath = response.jsonPath();
        if (jsonPath.get("crs") != null) {
            List<String> crs = JsonUtils.parseAsList("crs", jsonPath);
            EtsAssert.assertDefaultCrsAtFirst(crs, String.format("Feature Collections Metadata document does not specify one of the default CRS '%s' or '%s' as first value.", "http://www.opengis.net/def/crs/OGC/1.3/CRS84", "http://www.opengis.net/def/crs/OGC/1.3/CRS84h"));
        }
    }

    @Test(description="A.2.5. Feature Collections {root}/collections, Abstract Test 10, Test Method 4 (Requirement /req/core/fc-md-success, /req/core/crs84)", groups={"collections"}, dataProvider="collectionsUris", dependsOnMethods={"validateFeatureCollectionsMetadataOperation"}, alwaysRun=true)
    public void validateFeatureCollectionsMetadataOperationResponse_Content(TestPoint testPoint) {
        Response response = this.testPointAndResponses.get(testPoint);
        if (response == null) {
            throw new SkipException("Could not find a response for test point " + testPoint);
        }
        JsonPath jsonPath = response.jsonPath();
        List<Map<String, Object>> links = JsonUtils.parseAsListOfMaps("links", jsonPath);
        boolean linksAreAvailable = links != null && !links.isEmpty();
        EtsAssert.assertTrue(linksAreAvailable, "Feature Collections Metadata document does not contain links.");
        List<Map<String, Object>> collections = JsonUtils.parseAsListOfMaps("collections", jsonPath);
        boolean collectionsAreAvailable = collections != null && !collections.isEmpty();
        EtsAssert.assertTrue(collectionsAreAvailable, "Feature Collections Metadata document does not contain collections.");
    }

    private List<Map<String, Object>> createCollectionsMap(List<Object> collections) {
        ArrayList<Map<String, Object>> collectionsMap = new ArrayList<Map<String, Object>>();
        for (Object collectionObj : collections) {
            Map collection = (Map)collectionObj;
            if (null == collection.get("id")) continue;
            String itemType = (String)collection.get("itemType");
            if (StringUtils.isEmpty(itemType) || itemType.equalsIgnoreCase("feature")) {
                List links = (List)collection.get("links");
                for (Object linkObj : links) {
                    Map link = (Map)linkObj;
                    if (!link.get("rel").equals("items")) continue;
                    collectionsMap.add(collection);
                    break;
                }
            }
            if (this.noOfCollections > 0 && collectionsMap.size() >= this.noOfCollections) {
                return collectionsMap;
            }
            if (collectionsMap.size() < 20) continue;
            return collectionsMap.subList(0, 20);
        }
        return collectionsMap;
    }
}

