/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.conformance.crs;

import java.util.List;
import org.opengis.cite.ogcapifeatures10.conformance.RequirementClass;
import org.opengis.cite.ogcapifeatures10.conformance.SuiteAttribute;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class CrsRequirementClassPrecondition {
    private List<RequirementClass> conformanceClasses;

    @BeforeClass
    public void conformanceClasses(ITestContext testContext) {
        this.conformanceClasses = (List)testContext.getSuite().getAttribute(SuiteAttribute.REQUIREMENTCLASSES.getName());
    }

    @Test(description="Precondition: conformance class http://www.opengis.net/spec/ogcapi-features-2/1.0/conf/crs must be implemented", groups={"crs-conformance"})
    public void verifyConformanceClass() {
        boolean conformanceClassIsImplemented;
        boolean bl = conformanceClassIsImplemented = this.conformanceClasses != null && this.conformanceClasses.contains((Object)RequirementClass.CRS);
        if (!conformanceClassIsImplemented) {
            throw new SkipException("Conformance class " + RequirementClass.CRS.name() + " is not supported by the test instance. Tests will be skipped.");
        }
        Assert.assertTrue(conformanceClassIsImplemented, "Conformance class " + RequirementClass.CRS.name() + " is not supported by the test instance. Tests will be skipped.");
    }
}

