/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.conformance.crs.query.crs;

import java.util.Objects;
import org.apache.commons.validator.routines.UrlValidator;
import org.opengis.cite.ogcapifeatures10.exception.UnknownCrsException;
import org.opengis.cite.ogcapifeatures10.util.OgcNameValidator;
import org.opengis.cite.ogcapifeatures10.util.UrnValidator;

public class CoordinateSystem {
    private final String code;

    public CoordinateSystem(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public String getAsHeaderValue() {
        return "<" + this.code + ">";
    }

    public int getSrid() {
        if (this.isDefaultCrs()) {
            return 84;
        }
        try {
            if (this.code.startsWith("http://www.opengis.net/def/crs/")) {
                return Integer.parseInt(this.code.substring(this.code.lastIndexOf("/") + 1));
            }
            if (this.code.startsWith("urn:ogc:def:crs:")) {
                return Integer.parseInt(this.code.substring(this.code.lastIndexOf(":") + 1));
            }
        }
        catch (NumberFormatException e) {
            throw new UnknownCrsException(String.format("Could not parse srid from crs '%s', crs is not supported.", this.code));
        }
        throw new UnknownCrsException(String.format("Could not parse srid from crs '%s', crs is not supported.", this.code));
    }

    public String getCodeWithAuthority() {
        if (this.isDefaultCrs()) {
            return "OGC:CRS84";
        }
        if (this.code.startsWith("urn:ogc:def:crs:EPSG") || this.code.startsWith("http://www.opengis.net/def/crs/EPSG")) {
            int srid = this.getSrid();
            return String.format("EPSG:%s", srid);
        }
        throw new UnknownCrsException(String.format("CRS %s is not supported, only OGC URNs (starting with urn:ogc:def:crs:epsg) and OGC http-URIs (starting with http://www.opengis.net/def/crs/epsg) with EPSG auhority are supported.", this.code));
    }

    public boolean isValid() {
        if (this.code.startsWith("http:") && !this.code.startsWith("http://www.opengis.net/def/crs/")) {
            return this.assertValidHttpCrsIdentifier(this.code);
        }
        if (this.code.startsWith("https:")) {
            return this.assertValidHttpCrsIdentifier(this.code);
        }
        if (this.code.startsWith("urn:") && !this.code.startsWith("urn:ogc:def:crs:")) {
            return this.assertValidUrnCrsIdentifier(this.code);
        }
        if (this.code.startsWith("urn:ogc:def:crs:") || this.code.startsWith("http://www.opengis.net/def/crs/")) {
            return this.assertValidOgcNameCrsIdentifier(this.code);
        }
        return false;
    }

    public String toString() {
        return this.code;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinateSystem that = (CoordinateSystem)o;
        return this.code.equals(that.code);
    }

    public int hashCode() {
        return Objects.hash(this.code);
    }

    private boolean assertValidHttpCrsIdentifier(String valueToAssert) {
        UrlValidator urlValidator = new UrlValidator();
        return urlValidator.isValid(valueToAssert);
    }

    private boolean assertValidUrnCrsIdentifier(String valueToAssert) {
        UrnValidator urnValidator = new UrnValidator();
        return urnValidator.isValid(valueToAssert);
    }

    private boolean assertValidOgcNameCrsIdentifier(String valueToAssert) {
        OgcNameValidator ogcNameValidator = new OgcNameValidator();
        return ogcNameValidator.isValid(valueToAssert);
    }

    private boolean isDefaultCrs() {
        return "http://www.opengis.net/def/crs/OGC/1.3/CRS84".equals(this.code) || "http://www.opengis.net/def/crs/OGC/1.3/CRS84h".equals(this.code);
    }
}

