/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.conformance.crs.query.crs.features;

import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.MultiKeyMap;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.opengis.cite.ogcapifeatures10.EtsAssert;
import org.opengis.cite.ogcapifeatures10.conformance.crs.query.crs.CoordinateSystem;
import org.opengis.cite.ogcapifeatures10.conformance.crs.query.crs.features.AbstractFeaturesCrs;
import org.opengis.cite.ogcapifeatures10.util.GeometryTransformer;
import org.opengis.cite.ogcapifeatures10.util.JsonUtils;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class FeaturesCrsParameterTransform
extends AbstractFeaturesCrs {
    private MultiKeyMap collectionIdAndFeatureIdToGeometry = new MultiKeyMap();

    @Test(description="Implements A.2.1 Query, Parameter crs, Abstract Test 7 (Requirement /req/crs/crs-action), Geometries in the path /collections/{collectionId}/items", dataProvider="collectionIdAndJson", dependsOnGroups={"crs-conformance"}, priority=1)
    public void verifyFeaturesCrsParameterTransformWithoutCrsParameter(String collectionId, JsonPath collection) throws ParseException {
        if (collectionId == null & collection == null) {
            throw new AssertionError((Object)"No crs information for collection available.");
        }
        String featuresUrl = JsonUtils.findFeaturesUrlForGeoJson(this.rootUri, collection);
        if (featuresUrl == null) {
            throw new SkipException("Could not find url for collection with id " + collectionId + " supporting GeoJson (type " + "application/geo+json" + ")");
        }
        Response response = (Response)this.init().baseUri(featuresUrl).accept("application/geo+json").when().request(Method.GET);
        ((ValidatableResponse)response.then()).statusCode(200);
        String crsHeader = response.getHeader("Content-Crs");
        if (crsHeader == null) {
            throw new AssertionError((Object)String.format("Features response at '%s' does not provide the expected header 'Content-Crs'", featuresUrl));
        }
        EtsAssert.assertDefaultCrs(crsHeader, String.format("Features response at '%s' does not provide default 'Content-Crs' header, was: '%s', expected: '%s' or '%s'", featuresUrl, crsHeader, "http://www.opengis.net/def/crs/OGC/1.3/CRS84", "http://www.opengis.net/def/crs/OGC/1.3/CRS84h"));
        String crs = crsHeader.substring(1, crsHeader.length() - 1);
        JsonPath jsonPath = response.jsonPath();
        List features = jsonPath.getList("features");
        for (Map feature : features) {
            String featureId = feature.get("id").toString();
            Geometry geometry = JsonUtils.parseFeatureGeometry(feature, new CoordinateSystem(crs));
            this.collectionIdAndFeatureIdToGeometry.put(collectionId, featureId, geometry);
        }
    }

    @Test(description="Implements A.2.1 Query, Parameter crs, Abstract Test 7 (Requirement /req/crs/crs-action), Transformed geometries in the path /collections/{collectionId}/items", dataProvider="collectionIdAndJsonAndCrsAndDefaultCrs", dependsOnGroups={"crs-conformance"}, dependsOnMethods={"verifyFeaturesCrsParameterTransformWithoutCrsParameter"}, priority=1)
    public void verifyFeaturesCrsParameterTransformWithCrsParameter(String collectionId, JsonPath collection, CoordinateSystem crs, CoordinateSystem defaultCRS) throws ParseException {
        if (collectionId == null & collection == null & crs == null & defaultCRS == null) {
            throw new AssertionError((Object)"No crs information for collection available.");
        }
        String featuresUrl = JsonUtils.findFeaturesUrlForGeoJson(this.rootUri, collection);
        if (featuresUrl == null) {
            throw new SkipException(String.format("Could not find url for collection with id %s supporting GeoJson (type %s)", collectionId, "application/geo+json"));
        }
        Response response = (Response)this.init().baseUri(featuresUrl).queryParam("crs", crs.getCode()).accept("application/geo+json").when().request(Method.GET);
        ((ValidatableResponse)response.then()).statusCode(200);
        JsonPath jsonPath = response.jsonPath();
        List features = jsonPath.getList("features");
        for (Map feature : features) {
            String featureId = feature.get("id").toString();
            Geometry geometry = JsonUtils.parseFeatureGeometry(feature, crs);
            Geometry geometryInDefaultCrs = (Geometry)this.collectionIdAndFeatureIdToGeometry.get(collectionId, featureId);
            GeometryTransformer geometryTransformer = new GeometryTransformer(crs, defaultCRS);
            Geometry transformedGeometry = geometryTransformer.transform(geometry);
            geometryInDefaultCrs.equalsExact(transformedGeometry, 0.001);
        }
    }
}

