/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.datum;

import java.io.Serializable;
import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.datum.Ellipsoid;

public class GeocentricConverter
implements Serializable {
    double a;
    double b;
    double a2;
    double b2;
    double e2;
    double ep2;

    public GeocentricConverter(Ellipsoid ellipsoid) {
        this(ellipsoid.getA(), ellipsoid.getB());
    }

    public GeocentricConverter(double a, double b) {
        this.a = a;
        this.b = b;
        this.a2 = a * a;
        this.b2 = b * b;
        this.e2 = (this.a2 - this.b2) / this.a2;
        this.ep2 = (this.a2 - this.b2) / this.b2;
    }

    public void overrideWithWGS84Params() {
        this.a = Ellipsoid.WGS84.getA();
        this.e2 = Ellipsoid.WGS84.getEccentricitySquared();
    }

    public void convertGeodeticToGeocentric(ProjCoordinate p) {
        double Height;
        double Longitude = p.x;
        double Latitude = p.y;
        double d = Height = p.hasValidZOrdinate() ? p.z : 0.0;
        if (Latitude < -1.5707963267948966 && Latitude > -1.5723671231216914) {
            Latitude = -1.5707963267948966;
        } else if (Latitude > 1.5707963267948966 && Latitude < 1.5723671231216914) {
            Latitude = 1.5707963267948966;
        } else if (Latitude < -1.5707963267948966 || Latitude > 1.5707963267948966) {
            throw new IllegalStateException("Latitude is out of range: " + Latitude);
        }
        if (Longitude > Math.PI) {
            Longitude -= Math.PI * 2;
        }
        double Sin_Lat = Math.sin(Latitude);
        double Cos_Lat = Math.cos(Latitude);
        double Sin2_Lat = Sin_Lat * Sin_Lat;
        double Rn = this.a / Math.sqrt(1.0 - this.e2 * Sin2_Lat);
        double X2 = (Rn + Height) * Cos_Lat * Math.cos(Longitude);
        double Y = (Rn + Height) * Cos_Lat * Math.sin(Longitude);
        double Z = (Rn * (1.0 - this.e2) + Height) * Sin_Lat;
        p.x = X2;
        p.y = Y;
        p.z = Z;
    }

    public void convertGeocentricToGeodetic(ProjCoordinate p) {
        this.convertGeocentricToGeodeticIter(p);
    }

    public void convertGeocentricToGeodeticIter(ProjCoordinate p) {
        double SPHI;
        double CPHI;
        double Height;
        double SDPHI;
        double Longitude;
        double genau = 1.0E-12;
        double genau2 = genau * genau;
        int maxiter = 30;
        double X2 = p.x;
        double Y = p.y;
        double Z = p.hasValidZOrdinate() ? p.z : 0.0;
        boolean At_Pole = false;
        double P = Math.sqrt(X2 * X2 + Y * Y);
        double RR = Math.sqrt(X2 * X2 + Y * Y + Z * Z);
        if (P / this.a < genau) {
            At_Pole = true;
            Longitude = 0.0;
            if (RR / this.a < genau) {
                double Latitude = 1.5707963267948966;
                double Height2 = -this.b;
                p.x = Longitude;
                p.y = Latitude;
                p.z = Height2;
                return;
            }
        } else {
            Longitude = Math.atan2(Y, X2);
        }
        double CT = Z / RR;
        double ST2 = P / RR;
        double RX = 1.0 / Math.sqrt(1.0 - this.e2 * (2.0 - this.e2) * ST2 * ST2);
        double CPHI0 = ST2 * (1.0 - this.e2) * RX;
        double SPHI0 = CT * RX;
        int iter = 0;
        do {
            ++iter;
            double RN = this.a / Math.sqrt(1.0 - this.e2 * SPHI0 * SPHI0);
            Height = P * CPHI0 + Z * SPHI0 - RN * (1.0 - this.e2 * SPHI0 * SPHI0);
            double RK = this.e2 * RN / (RN + Height);
            RX = 1.0 / Math.sqrt(1.0 - RK * (2.0 - RK) * ST2 * ST2);
            CPHI = ST2 * (1.0 - RK) * RX;
            SPHI = CT * RX;
            SDPHI = SPHI * CPHI0 - CPHI * SPHI0;
            CPHI0 = CPHI;
            SPHI0 = SPHI;
        } while (SDPHI * SDPHI > genau2 && iter < maxiter);
        double Latitude = Math.atan(SPHI / Math.abs(CPHI));
        p.x = Longitude;
        p.y = Latitude;
        p.z = Height;
    }
}

