/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.conformance.core.collections;

import com.reprezen.kaizen.oasparser.model3.OpenApi3;
import com.reprezen.kaizen.oasparser.model3.Parameter;
import io.restassured.path.json.JsonPath;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.ZonedDateTime;
import java.util.List;
import org.opengis.cite.ogcapifeatures10.EtsAssert;
import org.opengis.cite.ogcapifeatures10.openapi3.OpenApiUtils;
import org.opengis.cite.ogcapifeatures10.openapi3.TestPoint;
import org.opengis.cite.ogcapifeatures10.util.JsonUtils;
import org.testng.Assert;
import org.testng.SkipException;

public class FeaturesAssertions {
    static void assertIntegerGreaterOrEqualsZero(Object value, String propertyName) {
        if (value instanceof Number) {
            FeaturesAssertions.assertIntegerGreaterOrEqualsZero(((Number)value).intValue(), propertyName);
        } else if (value instanceof String) {
            try {
                int valueAsInt = Integer.parseInt((String)value);
                FeaturesAssertions.assertIntegerGreaterOrEqualsZero(valueAsInt, propertyName);
            }
            catch (NumberFormatException e) {
                String msg = "Expected property '%s' to be an integer, but was '%s'";
                throw new AssertionError((Object)String.format(msg, propertyName, value));
            }
        }
    }

    static void assertIntegerGreaterOrEqualsZero(int value, String propertyName) {
        String msg = "Expected property '%s' to be an integer greater than or equals 0, but was '%s'";
        EtsAssert.assertTrue(value >= 0, String.format(msg, propertyName, value));
    }

    static void assertTimeStamp(String collectionName, JsonPath jsonPath, ZonedDateTime timeStampBeforeResponse, ZonedDateTime timeStampAfterResponse, boolean skipIfNoTimeStamp) {
        String timeStamp = jsonPath.getString("timeStamp");
        if (timeStamp == null) {
            if (skipIfNoTimeStamp) {
                throw new SkipException("No server response timeStamp set for collection items request ( '" + collectionName + "').");
            }
            return;
        }
        ZonedDateTime date = JsonUtils.parseAsDate(timeStamp);
        Assert.assertNotNull(date, "Not valid timestamp.");
    }

    static void assertNumberReturned(String collectionName, JsonPath jsonPath, boolean skipIfNoNumberReturned) {
        if (!JsonUtils.hasProperty("numberReturned", jsonPath)) {
            if (skipIfNoNumberReturned) {
                throw new SkipException("Property numberReturned is not set in collection items '" + collectionName + "'");
            }
            return;
        }
        int numberReturned = jsonPath.getInt("numberReturned");
        int numberOfFeatures = JsonUtils.parseAsList("features", jsonPath).size();
        Assert.assertEquals(numberReturned, numberOfFeatures, "Value of numberReturned (" + numberReturned + ") does not match the number of features in the response (" + numberOfFeatures + ")");
    }

    static void assertNumberMatched(OpenApi3 apiModel, URI iut, String collectionName, JsonPath jsonPath, boolean skipIfNoNumberMatched) throws URISyntaxException {
        Number maximumLimitNumber;
        TestPoint testPoint;
        Parameter limitParameter;
        if (!JsonUtils.hasProperty("numberMatched", jsonPath)) {
            if (skipIfNoNumberMatched) {
                throw new SkipException("Property numberMatched is not set in collection items '" + collectionName + "'");
            }
            return;
        }
        int maximumLimit = -1;
        List<TestPoint> testPoints = OpenApiUtils.retrieveTestPointsForCollection(apiModel, iut, collectionName);
        if (!testPoints.isEmpty() && (limitParameter = OpenApiUtils.retrieveParameterByName((testPoint = testPoints.get(0)).getPath(), apiModel, "limit")) != null && limitParameter.getSchema() != null && (maximumLimitNumber = limitParameter.getSchema().getMaximum()) != null) {
            maximumLimit = maximumLimitNumber.intValue();
        }
        int numberMatched = jsonPath.getInt("numberMatched");
        int numberOfAllReturnedFeatures = JsonUtils.collectNumberOfAllReturnedFeatures(jsonPath, maximumLimit);
        Assert.assertEquals(numberMatched, numberOfAllReturnedFeatures, "Value of numberReturned (" + numberMatched + ") does not match the number of features in all responses (" + numberOfAllReturnedFeatures + ")");
    }
}

