/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.conformance.crs.query.bboxcrs;

import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opengis.cite.ogcapifeatures10.conformance.crs.query.bboxcrs.AbstractBBoxCrs;
import org.opengis.cite.ogcapifeatures10.conformance.crs.query.crs.CoordinateSystem;
import org.opengis.cite.ogcapifeatures10.util.BBox;
import org.opengis.cite.ogcapifeatures10.util.GeometryTransformer;
import org.opengis.cite.ogcapifeatures10.util.JsonUtils;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class BBoxCrsParameter
extends AbstractBBoxCrs {
    private Map<String, Response> collectionIdToResponseWithDefaultCRs = new HashMap<String, Response>();
    private Map<String, BBox> collectionIdToSpatialExtent = new HashMap<String, BBox>();

    @DataProvider(name="collectionDefaultCrs")
    public Iterator<Object[]> collectionDefaultCrs(ITestContext testContext) {
        ArrayList<Object[]> collectionsData = new ArrayList<Object[]>();
        try {
            for (Map.Entry collection : this.collectionsResponses.entrySet()) {
                String collectionId = (String)collection.getKey();
                JsonPath json = (JsonPath)collection.getValue();
                CoordinateSystem defaultCrs = (CoordinateSystem)this.collectionIdToDefaultCrs.get(collectionId);
                if (defaultCrs == null) continue;
                collectionsData.add(new Object[]{collectionId, json, defaultCrs});
            }
        }
        catch (Exception e) {
            collectionsData.add(new Object[]{null, null, null});
        }
        return collectionsData.iterator();
    }

    @DataProvider(name="collectionCrsAndDefaultCrs")
    public Iterator<Object[]> collectionCrs(ITestContext testContext) {
        ArrayList<Object[]> collectionsData = new ArrayList<Object[]>();
        try {
            for (Map.Entry collection : this.collectionsResponses.entrySet()) {
                String collectionId = (String)collection.getKey();
                JsonPath json = (JsonPath)collection.getValue();
                CoordinateSystem defaultCrs = (CoordinateSystem)this.collectionIdToDefaultCrs.get(collectionId);
                if (defaultCrs == null) continue;
                for (CoordinateSystem crs : (List)this.collectionIdToCrs.get(collectionId)) {
                    collectionsData.add(new Object[]{collectionId, json, crs, defaultCrs});
                }
            }
        }
        catch (Exception e) {
            collectionsData.add(new Object[]{null, null, null, null});
        }
        return collectionsData.iterator();
    }

    @Test(description="Implements A.2.2 Query, Parameter bbox-crs, Abstract Test 8 (Requirement /req/crs/fc-bbox-crs-definition, /req/crs/bbox-crs-action)", dataProvider="collectionDefaultCrs", dependsOnGroups={"crs-conformance"}, priority=1)
    public void verifyBboxCrsParameterWithDefaultCrs(String collectionId, JsonPath collection, CoordinateSystem defaultCrs) {
        if (collectionId == null & collection == null & defaultCrs == null) {
            throw new AssertionError((Object)"No crs information for collection available.");
        }
        String featuredUrl = JsonUtils.findFeaturesUrlForGeoJson(this.rootUri, collection);
        if (featuredUrl == null) {
            throw new SkipException(String.format("Could not find url for collection with id %s supporting GeoJson (type 5s)", collectionId, "application/geo+json"));
        }
        BBox bbox = JsonUtils.parseSpatialExtent((Map)collection.get());
        if (bbox == null) {
            throw new SkipException(String.format("Collection with id %s has no spatial extent", collectionId));
        }
        GeometryTransformer geometryTransformer = new GeometryTransformer(bbox.getCrs(), defaultCrs);
        BBox transformedBboxInDefaultCrs = geometryTransformer.transform(bbox);
        String bboxParameterValueDefaultCrs = transformedBboxInDefaultCrs.asQueryParameter();
        Response response = (Response)this.init().baseUri(featuredUrl).accept("application/geo+json").param("bbox", bboxParameterValueDefaultCrs).when().request(Method.GET);
        ((ValidatableResponse)response.then()).statusCode(200);
        this.collectionIdToResponseWithDefaultCRs.put(collectionId, response);
        this.collectionIdToSpatialExtent.put(collectionId, bbox);
    }

    @Test(description="Implements A.2.2 Query, Parameter bbox-crs, Abstract Test 8 (Requirement /req/crs/fc-bbox-crs-definition, /req/crs/bbox-crs-action)", dataProvider="collectionCrsAndDefaultCrs", dependsOnGroups={"crs-conformance"}, dependsOnMethods={"verifyBboxCrsParameterWithDefaultCrs"}, priority=1)
    public void verifyBboxCrsParameter(String collectionId, JsonPath collection, CoordinateSystem crs, CoordinateSystem defaultCrs) {
        if (collectionId == null & collection == null & crs == null & defaultCrs == null) {
            throw new AssertionError((Object)"No crs information for collection available.");
        }
        if (!this.collectionIdToResponseWithDefaultCRs.containsKey(collectionId)) {
            throw new SkipException(String.format("Collection with id %s could not be requested with bbox in default crs", collectionId));
        }
        String featuredUrl = JsonUtils.findFeaturesUrlForGeoJson(this.rootUri, collection);
        if (featuredUrl == null) {
            throw new SkipException(String.format("Could not find url for collection with id %s supporting GeoJson (type 5s)", collectionId, "application/geo+json"));
        }
        BBox bbox = this.collectionIdToSpatialExtent.get(collectionId);
        GeometryTransformer geometryTransformer = new GeometryTransformer(bbox.getCrs(), crs);
        BBox maxExtent = new BBox(-180.0, -90.0, 180.0, 90.0);
        if (bbox.equals(maxExtent) && !crs.getCode().equals("http://www.opengis.net/def/crs/EPSG/0/4326") && !crs.getCode().equals("http://www.opengis.net/def/crs/OGC/1.3/CRS84")) {
            bbox = new BBox(-175.0, -85.0, 175.0, 85.0);
        }
        BBox transformedBbox = geometryTransformer.transform(bbox);
        Response response = (Response)this.init().baseUri(featuredUrl).param("bbox-crs", transformedBbox.getCrs().getCode()).param("bbox", transformedBbox.asQueryParameter()).accept("application/geo+json").when().request(Method.GET);
        ((ValidatableResponse)response.then()).statusCode(200);
        Response responseWithBBoxInDefaultCrs = this.collectionIdToResponseWithDefaultCRs.get(collectionId);
        this.assertSameFeatures(response.jsonPath(), responseWithBBoxInDefaultCrs.jsonPath());
    }
}

