/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.openapi3;

import com.sun.jersey.api.uri.UriTemplate;
import com.sun.jersey.api.uri.UriTemplateParser;
import java.util.HashMap;
import java.util.Map;
import org.opengis.cite.ogcapifeatures10.openapi3.TestPoint;

public class UriBuilder {
    private final TestPoint testPoint;
    private final Map<String, String> templateReplacements = new HashMap<String, String>();

    public UriBuilder(TestPoint testPoint) {
        this.testPoint = testPoint;
        this.templateReplacements.putAll(testPoint.getPredefinedTemplateReplacement());
    }

    public UriBuilder collectionName(String collectionName) {
        String templateName = this.retrieveCollectionNameTemplateName();
        this.addTemplateReplacement(collectionName, templateName);
        return this;
    }

    public UriBuilder featureId(String featureId) {
        String templateName = this.retrieveFeatureIdTemplateName();
        this.addTemplateReplacement(featureId, templateName);
        return this;
    }

    public String buildUrl() {
        UriTemplate uriTemplate = new UriTemplate(this.testPoint.getServerUrl() + this.testPoint.getPath());
        return uriTemplate.createURI(this.templateReplacements);
    }

    private void addTemplateReplacement(String collectionName, String templateName) {
        if (templateName != null) {
            this.templateReplacements.put(templateName, collectionName);
        }
    }

    private String retrieveCollectionNameTemplateName() {
        String path = this.testPoint.getPath();
        UriTemplateParser uriTemplateParser = new UriTemplateParser(path);
        for (String templateName : uriTemplateParser.getNames()) {
            if (!path.contains("/collections/{" + templateName + "}")) continue;
            return templateName;
        }
        return null;
    }

    private String retrieveFeatureIdTemplateName() {
        String path = this.testPoint.getPath();
        UriTemplateParser uriTemplateParser = new UriTemplateParser(path);
        for (String templateName : uriTemplateParser.getNames()) {
            if (!path.endsWith("items/{" + templateName + "}")) continue;
            return templateName;
        }
        return null;
    }
}

