/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.conformance.crs.discovery.collections;

import io.restassured.path.json.JsonPath;
import java.util.List;
import java.util.Map;
import org.opengis.cite.ogcapifeatures10.EtsAssert;
import org.opengis.cite.ogcapifeatures10.conformance.crs.discovery.collections.AbstractDiscoveryCollections;
import org.opengis.cite.ogcapifeatures10.openapi3.TestPoint;
import org.opengis.cite.ogcapifeatures10.util.JsonUtils;
import org.testng.annotations.Test;

public class DiscoveryCollectionsDefaultCrs
extends AbstractDiscoveryCollections {
    @Test(description="Implements A.1 Discovery, Abstract Test 2 (Requirement /req/crs/fc-md-crs-list B), crs property contains default crs in the collection objects in the path /collections", dataProvider="collectionItemUris", dependsOnGroups={"crs-conformance"})
    public void verifyCollectionsPathCollectionCrsPropertyContainsDefaultCrs(TestPoint testPoint, JsonPath jsonPath, Map<String, Object> collection) {
        if (JsonUtils.hasAtLeastOneSpatialFeatureCollection(collection)) {
            String collectionId = (String)collection.get("id");
            List<String> crs = JsonUtils.parseAsList("crs", collection);
            if (crs.size() == 1 && "#/crs".equals(crs.get(0))) {
                List<String> globalCrsList = JsonUtils.parseAsList("crs", jsonPath);
                EtsAssert.assertDefaultCrs(globalCrsList, String.format("Collection with id '%s' at collections path %s references to global crs section but provides at least one spatial feature collections. The global crs section does not specify one of the default CRS '%s' or '%s'", collectionId, testPoint.getPath(), "http://www.opengis.net/def/crs/OGC/1.3/CRS84", "http://www.opengis.net/def/crs/OGC/0/CRS84h"));
            } else {
                EtsAssert.assertDefaultCrs(crs, String.format("Collection with id '%s' at collections path %s does not specify one of the default CRS '%s' or '%s' but provides at least one spatial feature collections", collectionId, testPoint.getPath(), "http://www.opengis.net/def/crs/OGC/1.3/CRS84", "http://www.opengis.net/def/crs/OGC/0/CRS84h"));
            }
        }
    }
}

