/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.conformance.crs.query.crs.feature;

import io.restassured.path.json.JsonPath;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opengis.cite.ogcapifeatures10.conformance.CommonFixture;
import org.opengis.cite.ogcapifeatures10.conformance.SuiteAttribute;
import org.opengis.cite.ogcapifeatures10.conformance.crs.query.crs.CoordinateSystem;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;

public class AbstractFeatureCrs
extends CommonFixture {
    protected Map<String, JsonPath> collectionsResponses;
    protected Map<String, List<CoordinateSystem>> collectionIdToCrs;
    protected Map<String, CoordinateSystem> collectionIdToDefaultCrs;
    protected Map<String, String> collectionIdToFeatureId;

    @BeforeClass
    public void retrieveRequiredInformationFromTestContext(ITestContext testContext) {
        this.collectionsResponses = (Map)testContext.getSuite().getAttribute(SuiteAttribute.COLLECTION_BY_ID.getName());
        this.collectionIdToCrs = (Map)testContext.getSuite().getAttribute(SuiteAttribute.COLLECTION_CRS_BY_ID.getName());
        this.collectionIdToDefaultCrs = (Map)testContext.getSuite().getAttribute(SuiteAttribute.COLLECTION_DEFAULT_CRS_BY_ID.getName());
        this.collectionIdToFeatureId = (Map)testContext.getSuite().getAttribute(SuiteAttribute.FEATUREIDS.getName());
    }

    @DataProvider(name="collectionFeatureId")
    public Iterator<Object[]> collectionFeatureId(ITestContext testContext) {
        ArrayList<Object[]> collectionsData = new ArrayList<Object[]>();
        try {
            for (Map.Entry<String, JsonPath> collection : this.collectionsResponses.entrySet()) {
                String collectionId = collection.getKey();
                if (this.collectionIdToFeatureId == null || !this.collectionIdToFeatureId.containsKey(collectionId)) continue;
                String featureId = this.collectionIdToFeatureId.get(collectionId);
                JsonPath json = collection.getValue();
                collectionsData.add(new Object[]{collectionId, json, featureId});
            }
        }
        catch (Exception e) {
            collectionsData.add(new Object[]{null, null, null});
        }
        return collectionsData.iterator();
    }
}

