/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.conformance.crs.discovery.collections;

import io.restassured.path.json.JsonPath;
import java.util.List;
import java.util.Map;
import org.opengis.cite.ogcapifeatures10.conformance.crs.discovery.collections.AbstractDiscoveryCollections;
import org.opengis.cite.ogcapifeatures10.openapi3.TestPoint;
import org.opengis.cite.ogcapifeatures10.util.JsonUtils;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class DiscoveryCollectionsStorageCrs
extends AbstractDiscoveryCollections {
    @Test(description="Implements A.1 Discovery, Abstract Test 2 (Requirement /req/crs/fc-md-storageCrs-valid-value), storageCrs property in the collection objects in the path /collections", dataProvider="collectionItemUris", dependsOnGroups={"crs-conformance"})
    public void verifyCollectionsPathCollectionCrsPropertyContainsDefaultCrs(TestPoint testPoint, JsonPath jsonPath, Map<String, Object> collection) {
        String collectionId = (String)collection.get("id");
        String storageCrs = (String)collection.get("storageCrs");
        if (storageCrs == null) {
            throw new SkipException(String.format("Collection with id '%s' at collections path %s does not specify a storageCrs", collectionId, testPoint.getPath()));
        }
        List<String> crs = JsonUtils.parseAsList("crs", collection);
        if (crs.size() == 1 && "#/crs".equals(crs.get(0))) {
            List<String> globalCrsList = JsonUtils.parseAsList("crs", jsonPath);
            if (!globalCrsList.contains(storageCrs)) {
                throw new AssertionError((Object)String.format("Collection with id '%s' at collections path %s specifies the storageCrs '%s' which is not declared in the global list of CRSs", collectionId, testPoint.getPath(), storageCrs));
            }
        } else if (!crs.contains(storageCrs)) {
            throw new AssertionError((Object)String.format("Collection with id '%s' at collections path %s specifies the storageCrs '%s' which is not declared as crs property", collectionId, testPoint.getPath(), storageCrs));
        }
    }
}

