/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.spi.executors.testng;

import com.occamlab.te.spi.executors.TestRunExecutor;
import com.occamlab.te.spi.executors.testng.AlterSuiteParametersListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import org.testng.TestNG;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TestNGExecutor
implements TestRunExecutor {
    private static final Logger LOGR = Logger.getLogger(TestNGExecutor.class.getPackage().getName());
    private boolean useDefaultListeners;
    private File outputDir;
    private URI testngConfig;

    public TestNGExecutor(String testngSuite) {
        this(testngSuite, System.getProperty("java.io.tmpdir"), false);
    }

    public TestNGExecutor(String testngSuite, String outputDirPath, boolean useDefaultListeners) {
        this.useDefaultListeners = useDefaultListeners;
        this.outputDir = new File(outputDirPath, "testng");
        if (!this.outputDir.exists() && !this.outputDir.mkdirs()) {
            LOGR.config("Failed to create output directory at " + this.outputDir);
            this.outputDir = new File(System.getProperty("java.io.tmpdir"));
        }
        if (null != testngSuite && !testngSuite.isEmpty()) {
            this.testngConfig = URI.create(testngSuite);
        }
    }

    @Override
    public Source execute(Document testRunArgs) {
        if (null == testRunArgs) {
            throw new IllegalArgumentException("No test run arguments were supplied.");
        }
        TestNG driver = new TestNG();
        this.setTestSuites(driver, this.testngConfig);
        driver.setVerbose(0);
        driver.setUseDefaultListeners(this.useDefaultListeners);
        UUID runId = UUID.randomUUID();
        File runDir = new File(this.outputDir, runId.toString());
        if (!runDir.mkdir()) {
            runDir = this.outputDir;
            LOGR.config("Created test run directory at " + runDir.getAbsolutePath());
        }
        driver.setOutputDirectory(runDir.getAbsolutePath());
        AlterSuiteParametersListener listener = new AlterSuiteParametersListener();
        listener.setTestRunArgs(testRunArgs);
        listener.setTestRunId(runId);
        driver.addAlterSuiteListener(listener);
        driver.run();
        SAXSource source = null;
        try {
            File resultsFile = this.getResultsFile(this.getPreferredMediaType(testRunArgs), driver.getOutputDirectory());
            FileInputStream inStream = new FileInputStream(resultsFile);
            InputSource inSource = new InputSource(new InputStreamReader((InputStream)inStream, StandardCharsets.UTF_8));
            source = new SAXSource(inSource);
            source.setSystemId(resultsFile.toURI().toString());
        }
        catch (IOException e) {
            LOGR.log(Level.SEVERE, "Error reading test results: " + e.getMessage());
        }
        return source;
    }

    File getResultsFile(String mediaType, String outputDirectory) throws FileNotFoundException {
        String contentType = mediaType.split(";")[0];
        String fileName = contentType.endsWith("rdf+xml") ? "earl.rdf" : "testng-results.xml";
        File resultsFile = new File(outputDirectory, fileName);
        if (!resultsFile.exists()) {
            throw new FileNotFoundException("Test run results not found at " + resultsFile.getAbsolutePath());
        }
        return resultsFile;
    }

    String getPreferredMediaType(Document testRunArgs) {
        String mediaType = "application/xml";
        NodeList entries = testRunArgs.getElementsByTagName("entry");
        for (int i = 0; i < entries.getLength(); ++i) {
            Element entry = (Element)entries.item(i);
            if (!entry.getAttribute("key").equals("acceptMediaType")) continue;
            mediaType = entry.getTextContent().trim();
        }
        return mediaType;
    }

    private void setTestSuites(TestNG driver, URI ets) {
        if (ets.getScheme().equalsIgnoreCase("jar")) {
            String[] jarPath = ets.getSchemeSpecificPart().split("!");
            File jarFile = new File(URI.create(jarPath[0]));
            driver.setTestJar(jarFile.getAbsolutePath());
            driver.setXmlPathInJar(jarPath[1].substring(1));
        } else {
            ArrayList<String> testSuites = new ArrayList<String>();
            File tngFile = new File(ets);
            if (!tngFile.exists()) {
                throw new IllegalArgumentException("A valid TestNG config file reference is required.");
            }
            LOGR.log(Level.CONFIG, "Using TestNG config file {0}", tngFile.getAbsolutePath());
            testSuites.add(tngFile.getAbsolutePath());
            driver.setTestSuites(testSuites);
        }
    }
}

