/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.kaizen.oasparser.val3;

import com.reprezen.jsonoverlay.MapOverlay;
import com.reprezen.jsonoverlay.Overlay;
import com.reprezen.kaizen.oasparser.model3.OpenApi3;
import com.reprezen.kaizen.oasparser.model3.SecurityParameter;
import com.reprezen.kaizen.oasparser.model3.SecurityRequirement;
import com.reprezen.kaizen.oasparser.val.ObjectValidatorBase;
import com.reprezen.kaizen.oasparser.val.msg.Messages;
import com.reprezen.kaizen.oasparser.val3.OpenApi3Messages;
import com.reprezen.kaizen.oasparser.val3.SecurityParameterValidator;
import java.util.Map;
import java.util.Set;

public class SecurityRequirementValidator
extends ObjectValidatorBase<SecurityRequirement> {
    @Override
    public void runObjectValidations() {
        Overlay<Map<String, SecurityParameter>> requirements = this.validateMapField("requirements", false, false, SecurityParameter.class, new SecurityParameterValidator());
        this.checkAllSchemesDefined(requirements);
    }

    public void checkAllSchemesDefined(Overlay<Map<String, SecurityParameter>> requirements) {
        OpenApi3 model = (OpenApi3)this.value.getModel();
        Set<String> definedSchemes = model.getSecuritySchemes().keySet();
        MapOverlay mapOverlay = Overlay.getMapOverlay(requirements);
        for (String name : mapOverlay.keySet()) {
            if (definedSchemes.contains(name)) continue;
            this.results.addError(Messages.msg(OpenApi3Messages.UnkSecScheme, name), Overlay.of(mapOverlay, name));
        }
    }
}

