/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.precision;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateList;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.util.GeometryTransformer;
import org.locationtech.jts.operation.overlayng.PrecisionReducer;

class PrecisionReducerTransformer
extends GeometryTransformer {
    private PrecisionModel targetPM;
    private boolean isPointwise = false;

    public static Geometry reduce(Geometry geom, PrecisionModel targetPM) {
        return PrecisionReducerTransformer.reduce(geom, targetPM, false);
    }

    public static Geometry reduce(Geometry geom, PrecisionModel targetPM, boolean isPointwise) {
        PrecisionReducerTransformer trans = new PrecisionReducerTransformer(targetPM, isPointwise);
        return trans.transform(geom);
    }

    PrecisionReducerTransformer(PrecisionModel targetPM) {
        this(targetPM, false);
    }

    PrecisionReducerTransformer(PrecisionModel targetPM, boolean isPointwise) {
        this.targetPM = targetPM;
        this.isPointwise = isPointwise;
    }

    @Override
    protected CoordinateSequence transformCoordinates(CoordinateSequence coordinates, Geometry parent) {
        if (coordinates.size() == 0) {
            return null;
        }
        Coordinate[] coordsReduce = this.isPointwise ? this.reducePointwise(coordinates) : this.reduceCompress(coordinates);
        int minLength = 0;
        if (parent instanceof LineString) {
            minLength = 2;
        }
        if (parent instanceof LinearRing) {
            minLength = 4;
        }
        if (coordsReduce.length < minLength) {
            return null;
        }
        return this.factory.getCoordinateSequenceFactory().create(coordsReduce);
    }

    private Coordinate[] reduceCompress(CoordinateSequence coordinates) {
        CoordinateList noRepeatCoordList = new CoordinateList();
        for (int i = 0; i < coordinates.size(); ++i) {
            Coordinate coord = coordinates.getCoordinate(i).copy();
            this.targetPM.makePrecise(coord);
            noRepeatCoordList.add(coord, false);
        }
        Coordinate[] noRepeatCoords = noRepeatCoordList.toCoordinateArray();
        return noRepeatCoords;
    }

    private Coordinate[] reducePointwise(CoordinateSequence coordinates) {
        Coordinate[] coordReduce = new Coordinate[coordinates.size()];
        for (int i = 0; i < coordinates.size(); ++i) {
            Coordinate coord = coordinates.getCoordinate(i).copy();
            this.targetPM.makePrecise(coord);
            coordReduce[i] = coord;
        }
        return coordReduce;
    }

    @Override
    protected Geometry transformPolygon(Polygon geom, Geometry parent) {
        if (this.isPointwise) {
            Geometry trans = super.transformPolygon(geom, parent);
            if (trans instanceof Polygon) {
                return trans;
            }
            return this.factory.createPolygon();
        }
        return this.reduceArea(geom);
    }

    @Override
    protected Geometry transformMultiPolygon(MultiPolygon geom, Geometry parent) {
        if (this.isPointwise) {
            return super.transformMultiPolygon(geom, parent);
        }
        return this.reduceArea(geom);
    }

    private Geometry reduceArea(Geometry geom) {
        Geometry reduced = PrecisionReducer.reducePrecision(geom, this.targetPM);
        return reduced;
    }
}

