/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.jsonoverlay;

import com.fasterxml.jackson.databind.JsonNode;
import com.reprezen.jsonoverlay.Builder;
import com.reprezen.jsonoverlay.JsonOverlay;
import com.reprezen.jsonoverlay.OverlayFactory;
import com.reprezen.jsonoverlay.ReferenceManager;
import com.reprezen.jsonoverlay.ScalarOverlay;
import com.reprezen.jsonoverlay.SerializationOptions;

public final class BooleanOverlay
extends ScalarOverlay<Boolean> {
    public static OverlayFactory<Boolean> factory = new OverlayFactory<Boolean>(){

        @Override
        protected Class<BooleanOverlay> getOverlayClass() {
            return BooleanOverlay.class;
        }

        public BooleanOverlay _create(Boolean value, JsonOverlay<?> parent, ReferenceManager refMgr) {
            return new BooleanOverlay(value, parent, refMgr);
        }

        public BooleanOverlay _create(JsonNode json, JsonOverlay<?> parent, ReferenceManager refMgr) {
            return new BooleanOverlay(json, parent, refMgr);
        }
    };

    private BooleanOverlay(Boolean value, JsonOverlay<?> parent, ReferenceManager refMgr) {
        super(value, parent, factory, refMgr);
    }

    private BooleanOverlay(JsonNode json, JsonOverlay<?> parent, ReferenceManager refMgr) {
        super(json, parent, factory, refMgr);
    }

    @Override
    protected Boolean _fromJson(JsonNode json) {
        return json.isBoolean() ? Boolean.valueOf(json.booleanValue()) : null;
    }

    @Override
    protected JsonNode _toJsonInternal(SerializationOptions options) {
        return this.value != null ? BooleanOverlay._jsonBoolean((Boolean)this.value) : BooleanOverlay._jsonMissing();
    }

    @Override
    protected OverlayFactory<Boolean> _getFactory() {
        return factory;
    }

    public static Builder<Boolean> builder(JsonOverlay<?> modelMember) {
        return new Builder<Boolean>(factory, modelMember);
    }

    public static JsonOverlay<Boolean> create(JsonOverlay<?> modelMember) {
        return BooleanOverlay.builder(modelMember).build();
    }

    public static JsonOverlay<Boolean> create(boolean value, JsonOverlay<?> modelMember) {
        JsonOverlay<Boolean> result = BooleanOverlay.create(modelMember);
        result._set(value);
        return result;
    }
}

