/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.util;

import io.restassured.RestAssured;
import io.restassured.http.Method;
import io.restassured.path.json.JsonPath;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONObject;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.geojson.GeoJsonReader;
import org.opengis.cite.ogcapifeatures10.OgcApiFeatures10;
import org.opengis.cite.ogcapifeatures10.conformance.crs.query.crs.CoordinateSystem;
import org.opengis.cite.ogcapifeatures10.util.BBox;
import org.opengis.cite.ogcapifeatures10.util.TemporalExtent;

public class JsonUtils {
    private JsonUtils() {
    }

    public static String parseAsString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static String parseFeatureId(JsonPath collectionItemJson) {
        List features = (List)collectionItemJson.get("features");
        if (features == null) {
            return null;
        }
        for (Map feature : features) {
            if (!feature.containsKey("id")) continue;
            return feature.get("id").toString();
        }
        return null;
    }

    public static TemporalExtent parseTemporalExtent(Map<String, Object> collection) {
        Object extent = collection.get("extent");
        if (extent == null || !(extent instanceof Map)) {
            return null;
        }
        Object spatial = ((Map)extent).get("temporal");
        if (spatial == null || !(spatial instanceof List)) {
            return null;
        }
        List coords = (List)spatial;
        if (coords.size() == 2) {
            ZonedDateTime begin = JsonUtils.parseAsDate((String)coords.get(0));
            ZonedDateTime end = JsonUtils.parseAsDate((String)coords.get(1));
            return new TemporalExtent(begin, end);
        }
        throw new IllegalArgumentException("Temporal extent with " + coords.size() + " items is invalid");
    }

    public static ZonedDateTime parseAsDate(String dateTime) {
        return ZonedDateTime.parse(dateTime);
    }

    public static String formatDate(ZonedDateTime dateTime) {
        return DateTimeFormatter.ISO_INSTANT.format(dateTime);
    }

    public static String formatDate(LocalDate date) {
        return DateTimeFormatter.ISO_DATE.format(date);
    }

    public static String formatDateRange(ZonedDateTime beginDateTime, ZonedDateTime endDateTime) {
        return JsonUtils.formatDate(beginDateTime) + "/" + JsonUtils.formatDate(endDateTime);
    }

    public static String formatDateRangeWithDuration(LocalDate beginDate, LocalDate endDate) {
        Period betweenDate = Period.between(beginDate, endDate);
        return JsonUtils.formatDate(beginDate) + "/" + betweenDate;
    }

    public static BBox parseSpatialExtent(Map<String, Object> collection) {
        Object extent = collection.get("extent");
        if (extent == null || !(extent instanceof Map)) {
            return null;
        }
        Object spatial = ((Map)extent).get("spatial");
        if (spatial == null || !(spatial instanceof Map)) {
            return null;
        }
        Object bbox = ((Map)spatial).get("bbox");
        if (bbox == null || !(bbox instanceof List)) {
            return null;
        }
        List bboxesOrCoordinates = (List)bbox;
        if (bboxesOrCoordinates.isEmpty()) {
            return null;
        }
        if (JsonUtils.containsMultipleBboxes(bboxesOrCoordinates)) {
            if (bboxesOrCoordinates.isEmpty()) {
                return null;
            }
            Object firstBbox = bboxesOrCoordinates.get(0);
            if (firstBbox == null || !(firstBbox instanceof List)) {
                return null;
            }
            List coordinatesOfFirstBBox = (List)firstBbox;
            return JsonUtils.parseBbox(coordinatesOfFirstBBox, (Map)spatial);
        }
        return JsonUtils.parseBbox(bboxesOrCoordinates, (Map)spatial);
    }

    private static BBox parseBbox(List<Object> coords, Map<String, Object> spatial) {
        if (coords.size() == 4) {
            CoordinateSystem crs = JsonUtils.parseCrs(spatial);
            double minX = JsonUtils.parseValueAsDouble(coords.get(0));
            double minY = JsonUtils.parseValueAsDouble(coords.get(1));
            double maxX = JsonUtils.parseValueAsDouble(coords.get(2));
            double maxY = JsonUtils.parseValueAsDouble(coords.get(3));
            return new BBox(minX, minY, maxX, maxY, crs);
        }
        if (coords.size() == 6) {
            throw new IllegalArgumentException("BBox with " + coords.size() + " coordinates is currently not supported");
        }
        throw new IllegalArgumentException("BBox with " + coords.size() + " coordinates is invalid");
    }

    private static CoordinateSystem parseCrs(Map<String, Object> spatial) {
        String crs = JsonUtils.parseAsString(spatial.get("crs"));
        if (crs != null) {
            return new CoordinateSystem(crs);
        }
        return OgcApiFeatures10.DEFAULT_CRS;
    }

    private static boolean containsMultipleBboxes(List<Object> bboxes) {
        Object first = bboxes.get(0);
        return first instanceof List;
    }

    public static List<Map<String, Object>> findLinksWithSupportedMediaTypeByRel(List<Map<String, Object>> links, List<String> mediaTypesToSupport, String expectedRel) {
        ArrayList<Map<String, Object>> alternateLinks = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> link : links) {
            Object type = link.get("type");
            Object rel = link.get("rel");
            if (!expectedRel.equals(rel) || !JsonUtils.isSupportedMediaType(type, mediaTypesToSupport)) continue;
            alternateLinks.add(link);
        }
        return alternateLinks;
    }

    public static List<String> findUnsupportedTypes(List<Map<String, Object>> links, List<String> mediaTypesToSuppport) {
        ArrayList<String> unsupportedType = new ArrayList<String>();
        for (String contentMediaType : mediaTypesToSuppport) {
            boolean hasLinkForContentType = JsonUtils.hasLinkForContentType(links, contentMediaType);
            if (hasLinkForContentType) continue;
            unsupportedType.add(contentMediaType);
        }
        return unsupportedType;
    }

    public static List<String> findLinksWithoutRelOrType(List<Map<String, Object>> links, Set<String> rels) {
        ArrayList<String> linksWithoutRelOrType = new ArrayList<String>();
        for (Map<String, Object> link : links) {
            if (!rels.contains(link.get("rel")) || JsonUtils.linkIncludesRelAndType(link)) continue;
            linksWithoutRelOrType.add((String)link.get("href"));
        }
        return linksWithoutRelOrType;
    }

    public static Map<String, Object> findLinkByRel(List<Map<String, Object>> links, String expectedRel) {
        if (links == null) {
            return null;
        }
        for (Map<String, Object> link : links) {
            Object rel = link.get("rel");
            if (!expectedRel.equals(rel)) continue;
            return link;
        }
        return null;
    }

    public static boolean linkIncludesRelAndType(Map<String, Object> link) {
        Object rel = link.get("rel");
        Object type = link.get("type");
        return rel != null && type != null;
    }

    public static boolean hasProperty(String propertyName, JsonPath jsonPath) {
        return jsonPath.get(propertyName) != null;
    }

    public static boolean hasAtLeastOneSpatialFeatureCollection(JsonPath jsonPath) {
        List collections = jsonPath.getList("collections");
        for (Object collectionObj : collections) {
            if (!JsonUtils.hasAtLeastOneSpatialFeatureCollection((Map)collectionObj)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAtLeastOneSpatialFeatureCollection(Map<String, Object> collection) {
        Object extent = collection.get("extent");
        return JsonUtils.hasAtLeastOneSpatialFeatureCollection(extent);
    }

    public static boolean hasAtLeastOneSpatialFeatureCollection(Object extent) {
        Object spatial;
        return extent != null && extent instanceof Map && (spatial = ((Map)extent).get("spatial")) != null;
    }

    public static List<String> parseAsList(String propertyName, JsonPath jsonPath) {
        Object value = jsonPath.get(propertyName);
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof String) {
            return Collections.singletonList((String)value);
        }
        return jsonPath.getList(propertyName);
    }

    public static List<Map<String, Object>> parseAsListOfMaps(String propertyName, JsonPath jsonPath) {
        Object value = jsonPath.get(propertyName);
        if (value == null) {
            return Collections.emptyList();
        }
        return jsonPath.getList(propertyName);
    }

    public static List<String> parseAsList(String propertyName, Map<String, Object> json) {
        Object value = json.get(propertyName);
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof String) {
            return Collections.singletonList((String)value);
        }
        return (List)json.get(propertyName);
    }

    public static int collectNumberOfAllReturnedFeatures(JsonPath jsonPath, int maximumLimit) throws URISyntaxException {
        int numberOfAllReturnedFeatures = JsonUtils.parseAsList("features", jsonPath).size();
        Map<String, Object> nextLink = JsonUtils.findLinkByRel(jsonPath.getList("links"), "next");
        for (int count = 0; nextLink != null && count <= 3; ++count) {
            String nextUrl = (String)nextLink.get("href");
            URI uri = new URI(nextUrl);
            RequestSpecification accept = ((RequestSpecification)RestAssured.given().log().all()).baseUri(nextUrl).accept("application/geo+json");
            String[] pairs = uri.getQuery().split("&");
            String limitParamFromUri = null;
            for (String pair : pairs) {
                int idx = pair.indexOf("=");
                String key = pair.substring(0, idx);
                String value = pair.substring(idx + 1);
                if ("limit".equals(key)) {
                    limitParamFromUri = value;
                    continue;
                }
                accept.param(key, new Object[]{value});
            }
            if (maximumLimit > 0) {
                accept.param("limit", new Object[]{maximumLimit});
            } else if (limitParamFromUri != null) {
                accept.param("limit", new Object[]{limitParamFromUri});
            }
            Response response = (Response)accept.when().request(Method.GET);
            ((ValidatableResponse)response.then()).statusCode(200);
            JsonPath nextJsonPath = response.jsonPath();
            int features = JsonUtils.parseAsList("features", nextJsonPath).size();
            if (features > 0) {
                numberOfAllReturnedFeatures += features;
                nextLink = JsonUtils.findLinkByRel(nextJsonPath.getList("links"), "next");
                continue;
            }
            nextLink = null;
        }
        return numberOfAllReturnedFeatures;
    }

    public static String findFeaturesUrlForGeoJson(URI rootUri, JsonPath collection) {
        List links = (List)collection.get("links");
        return JsonUtils.findFeaturesUrlForGeoJson(rootUri, links);
    }

    public static String findFeaturesUrlForGeoJson(URI rootUri, Map<String, Object> collection) {
        List links = (List)collection.get("links");
        return JsonUtils.findFeaturesUrlForGeoJson(rootUri, links);
    }

    public static String findFeatureUrlForGeoJson(URI rootUri, JsonPath collection, String featureId) {
        List links = (List)collection.get("links");
        return JsonUtils.findFeatureUrlForGeoJson(rootUri, featureId, links);
    }

    public static String findFeatureUrlForGeoJson(URI rootUri, Map<String, Object> collection, String featureId) {
        List links = (List)collection.get("links");
        return JsonUtils.findFeatureUrlForGeoJson(rootUri, featureId, links);
    }

    public static Geometry parseFeatureGeometry(Map<String, Object> feature, CoordinateSystem crs) throws ParseException {
        Map geometry = (Map)feature.get("geometry");
        if (geometry == null) {
            return null;
        }
        JSONObject jsonObject = new JSONObject(geometry);
        String geomAsString = jsonObject.toJSONString();
        GeoJsonReader geoJsonReader = new GeoJsonReader();
        Geometry parsedGeometry = geoJsonReader.read(geomAsString);
        parsedGeometry.setSRID(crs.getSrid());
        return parsedGeometry;
    }

    private static String findFeaturesUrlForGeoJson(URI rootUri, List<Object> links) {
        for (Object linkObject : links) {
            Map link = (Map)linkObject;
            Object rel = link.get("rel");
            Object type = link.get("type");
            if (!"items".equals(rel) || !"application/geo+json".equals(type)) continue;
            String url = (String)link.get("href");
            if (!url.startsWith("http")) {
                String path = url;
                if (null != rootUri.getScheme() && !rootUri.getScheme().isEmpty()) {
                    url = rootUri.getScheme() + ":";
                }
                if (null != rootUri.getAuthority() && !rootUri.getAuthority().isEmpty()) {
                    url = url + "//" + rootUri.getAuthority();
                }
                url = url + path;
                if (null != rootUri.getQuery() && !rootUri.getQuery().isEmpty()) {
                    url = url + "?" + rootUri.getQuery();
                }
                if (null != rootUri.getFragment() && !rootUri.getFragment().isEmpty()) {
                    url = url + "#" + rootUri.getFragment();
                }
            }
            return url;
        }
        return null;
    }

    private static String findFeatureUrlForGeoJson(URI rootUri, String featureId, List<Object> links) {
        String featuresUrlForGeoJson = JsonUtils.findFeaturesUrlForGeoJson(rootUri, links);
        if (featuresUrlForGeoJson != null) {
            return JsonUtils.createFeatureUrl(featuresUrlForGeoJson, featureId);
        }
        return null;
    }

    private static String createFeatureUrl(String getFeatureUrl, String featureId) {
        if (getFeatureUrl.indexOf("?") != -1) {
            return getFeatureUrl.substring(0, getFeatureUrl.indexOf("?")) + "/" + featureId;
        }
        if (getFeatureUrl.matches("^.*\\/items.[a-zA-Z]*$")) {
            return getFeatureUrl.substring(0, getFeatureUrl.lastIndexOf(".")) + "/" + featureId + getFeatureUrl.substring(getFeatureUrl.lastIndexOf("."));
        }
        return getFeatureUrl + "/" + featureId;
    }

    private static boolean isSameMediaType(String mediaType1, String mediaType2) {
        if (mediaType1.contains(";") || mediaType2.contains(";")) {
            String parameter;
            int i;
            String[] components1 = mediaType1.toLowerCase().split(";");
            String[] components2 = mediaType2.toLowerCase().split(";");
            if (!components1[0].trim().equals(components2[0].trim())) {
                return false;
            }
            HashSet<String> parameters1 = new HashSet<String>();
            HashSet<String> parameters2 = new HashSet<String>();
            for (i = 1; i < components1.length; ++i) {
                parameter = components1[i].trim().replace("\"", "");
                if (parameter.isEmpty()) continue;
                parameters1.add(parameter);
            }
            for (i = 1; i < components2.length; ++i) {
                parameter = components2[i].trim().replace("\"", "");
                if (parameter.isEmpty()) continue;
                parameters2.add(parameter);
            }
            if (parameters1.size() != parameters2.size()) {
                return false;
            }
            if (!parameters1.containsAll(parameters2)) {
                return false;
            }
        } else if (!mediaType1.trim().equalsIgnoreCase(mediaType2.trim())) {
            return false;
        }
        return true;
    }

    private static boolean hasLinkForContentType(List<Map<String, Object>> alternateLinks, String mediaType) {
        for (Map<String, Object> alternateLink : alternateLinks) {
            Object type = alternateLink.get("type");
            if (!(type instanceof String) || !JsonUtils.isSameMediaType(mediaType, (String)type)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSupportedMediaType(Object type, List<String> mediaTypes) {
        for (String mediaType : mediaTypes) {
            if (!(type instanceof String) || !JsonUtils.isSameMediaType(mediaType, (String)type)) continue;
            return true;
        }
        return false;
    }

    private static double parseValueAsDouble(Object value) {
        if (value instanceof Integer) {
            return ((Integer)value).doubleValue();
        }
        if (value instanceof Float) {
            return ((Float)value).doubleValue();
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        return Double.parseDouble(value.toString());
    }
}

