/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.jsonoverlay.gen;

import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.reprezen.jsonoverlay.gen.ImplGenerator;
import com.reprezen.jsonoverlay.gen.InterfaceGenerator;
import com.reprezen.jsonoverlay.gen.TypeData;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.yaml.snakeyaml.Yaml;

public class CodeGenerator {
    private Opts opts;

    public static void main(String[] args) throws Exception {
        Opts opts = new Opts(args);
        Object parsedYaml = new Yaml().load(new FileInputStream(opts.typeDataFile));
        TypeData typeData = new YAMLMapper().convertValue(parsedYaml, TypeData.class);
        typeData.init();
        new CodeGenerator(opts).generate(typeData);
    }

    private CodeGenerator(Opts opts) {
        this.opts = opts;
    }

    private void generate(TypeData typeData) throws IOException {
        this.generateInterfaces(typeData);
        this.generateImpls(typeData);
        if (!this.opts.preserve) {
            System.err.println("WARNING: Preservation of non-generated code is suppressed!");
            System.err.println("This is normally appropriate only when modifying the code generator and/or input data,");
            System.err.println("during which compilation errors are likely to be present in generated code.");
            System.err.println("");
            System.err.println("Please be sure to revert the generated code to a known good state and then regenerate");
            System.err.println("after completing modifications, so as to carry forward any non-generated code that");
            System.err.println("has been previously added.");
        }
    }

    private void generateInterfaces(TypeData typeData) throws IOException {
        File intfDir = this.getIntfDir();
        String intfPackage = this.getIntfPackage();
        String implPackage = this.getImplPackage();
        for (TypeData.Type type : typeData.getTypes()) {
            if (type.isNoGen()) {
                return;
            }
            new InterfaceGenerator(intfDir, intfPackage, implPackage, "", this.opts.preserve).generate(type);
        }
    }

    private void generateImpls(TypeData typeData) throws IOException {
        File implDir = this.getImplDir();
        String intfPackage = this.getIntfPackage();
        String implPackage = this.getImplPackage();
        for (TypeData.Type type : typeData.getTypes()) {
            if (type.isNoGen()) {
                return;
            }
            new ImplGenerator(implDir, intfPackage, implPackage, this.opts.classSuffix, this.opts.preserve).generate(type);
        }
    }

    private File getImplDir() {
        return new File(this.opts.topDir, this.opts.classDir.getPath());
    }

    private String getImplPackage() {
        return this.opts.pkg + "." + this.opts.classPackage;
    }

    private File getIntfDir() {
        return new File(this.opts.topDir, this.opts.interfaceDir.getPath());
    }

    private String getIntfPackage() {
        return this.opts.pkg + "." + this.opts.interfacePackage;
    }

    private static class Opts {
        private static Options options = new Options().addOption("t", "typeData", true, "type data file").addOption("d", "dir", true, "top-level generation directory").addOption("i", "interfaces", true, "directory to write interfaces").addOption("c", "classes", true, "directory to write implementation classes").addOption("p", "package", true, "containing package").addOption("I", "interface-package", true, "subpackage for interfaces").addOption("C", "class-package", true, "subpackage for classes").addOption("s", "suffix", true, "suffix for implementation classes").addOption("n", "noPreserve", false, "suppress preservation of non-genereated methods");
        public File topDir = new File(".");
        public File typeDataFile = new File("type-data.yaml");
        public String interfacePackage = "";
        public File interfaceDir = new File(".");
        public File classDir = new File("impl");
        public String pkg = CodeGenerator.class.getPackage().getName();
        public String classPackage = "impl";
        public String classSuffix = "Impl";
        public boolean preserve = true;

        public Opts(String[] args) throws ParseException {
            CommandLine cmd = new DefaultParser().parse(options, args);
            if (cmd.hasOption('t')) {
                this.typeDataFile = new File(cmd.getOptionValue('t'));
            }
            if (cmd.hasOption('d')) {
                this.topDir = new File(cmd.getOptionValue('d'));
            }
            if (cmd.hasOption('i')) {
                this.interfaceDir = new File(cmd.getOptionValue('i'));
            }
            if (cmd.hasOption('I')) {
                this.interfacePackage = cmd.getOptionValue('I');
            }
            if (cmd.hasOption('c')) {
                this.classDir = new File(cmd.getOptionValue('c'));
            }
            if (cmd.hasOption('C')) {
                this.classPackage = cmd.getOptionValue('C');
            }
            if (cmd.hasOption('s')) {
                this.classSuffix = cmd.getOptionValue('s');
            }
            if (cmd.hasOption('p')) {
                this.pkg = cmd.getOptionValue('p');
            }
            if (cmd.hasOption('n')) {
                this.preserve = false;
            }
        }
    }
}

