/*
 * Decompiled with CFR 0.152.
 */
package com.reprezen.jsonoverlay.gen;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.reprezen.jsonoverlay.Builder;
import com.reprezen.jsonoverlay.EnumOverlay;
import com.reprezen.jsonoverlay.IJsonOverlay;
import com.reprezen.jsonoverlay.JsonOverlay;
import com.reprezen.jsonoverlay.ListOverlay;
import com.reprezen.jsonoverlay.MapOverlay;
import com.reprezen.jsonoverlay.OverlayFactory;
import com.reprezen.jsonoverlay.ReferenceManager;
import com.reprezen.jsonoverlay.gen.SimpleJavaGenerator;
import com.reprezen.jsonoverlay.gen.TypeData;
import com.reprezen.jsonoverlay.gen.TypeGenerator;
import java.io.File;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ImplGenerator
extends TypeGenerator {
    public ImplGenerator(File dir2, String intfPackage, String implPackage, String suffix, boolean preserve) {
        super(dir2, intfPackage, implPackage, suffix, preserve);
    }

    @Override
    public String getPackage() {
        return this.implPackage;
    }

    @Override
    public Collection<String> getImports(TypeData.Type type) {
        return type.getRequiredImports("impl", "both");
    }

    @Override
    public boolean needIntfImports() {
        return true;
    }

    @Override
    public TypeGenerator.Members getOtherMembers(TypeData.Type type) {
        TypeGenerator.Members members = new TypeGenerator.Members();
        boolean _isEnum = this.isEnum(type);
        if (_isEnum) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("@Override");
            _builder.newLine();
            _builder.append("protected Class<");
            String _name = type.getName();
            _builder.append(_name);
            _builder.append("> getEnumClass() {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("return ");
            String _name_1 = type.getName();
            _builder.append(_name_1, "\t");
            _builder.append(".class;");
            _builder.newLineIfNotEmpty();
            _builder.append("}");
            _builder.newLine();
            SimpleJavaGenerator.Member _member = new SimpleJavaGenerator.Member(_builder.toString());
            members.add(_member);
            members.add(this.getEnumFactoryMember(type));
        } else {
            boolean _tripleNotEquals;
            members.addAll(this.getFieldNameConstants(type));
            members.add(this.getElaborateJsonMethod(type));
            members.addAll(this.getFactoryMembers(type));
            String _modelType = type.getTypeData().getModelType();
            boolean bl = _tripleNotEquals = _modelType != null;
            if (_tripleNotEquals) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("@Override");
                _builder_1.newLine();
                _builder_1.append("public Class<?> _getModelType() {");
                _builder_1.newLine();
                _builder_1.append("\t");
                _builder_1.append("return ");
                String _modelType_1 = type.getTypeData().getModelType();
                _builder_1.append(_modelType_1, "\t");
                _builder_1.append(".class;");
                _builder_1.newLineIfNotEmpty();
                _builder_1.append("}");
                _builder_1.newLine();
                members.addMember(_builder_1.toString());
            }
        }
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("@Override");
        _builder_2.newLine();
        _builder_2.append("protected OverlayFactory<?> _getFactory() {");
        _builder_2.newLine();
        _builder_2.append("\t");
        _builder_2.append("return factory;");
        _builder_2.newLine();
        _builder_2.append("}");
        _builder_2.newLine();
        SimpleJavaGenerator.Member _member_1 = new SimpleJavaGenerator.Member(_builder_2.toString());
        members.add(_member_1);
        members.addAll(this.getBuilderMethods(type));
        return members;
    }

    @Override
    public TypeDeclaration<?> getTypeDeclaration(TypeData.Type type, String suffix) {
        ClassOrInterfaceDeclaration decl = new ClassOrInterfaceDeclaration();
        decl.setInterface(false);
        decl.setPublic(true);
        String _name = type.getName();
        String _plus = _name + suffix;
        decl.setName(_plus);
        boolean _isEnum = this.isEnum(type);
        if (_isEnum) {
            this.requireTypes(EnumOverlay.class);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("EnumOverlay<");
            String _name_1 = type.getName();
            _builder.append(_name_1);
            _builder.append(">");
            decl.addExtendedType(_builder.toString());
        } else {
            decl.addExtendedType(this.getSuperType(type));
            decl.addImplementedType(type.getName());
        }
        return decl;
    }

    private boolean isEnum(TypeData.Type type) {
        boolean _isEmpty = type.getEnumValues().isEmpty();
        return !_isEmpty;
    }

    private String getSuperType(TypeData.Type type) {
        String superType = type.getExtensionOf();
        if (superType == null) {
            this.requireTypes("PropertiesOverlay");
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("PropertiesOverlay<");
            String _name = type.getName();
            _builder.append(_name);
            _builder.append(">");
            return _builder.toString();
        }
        return superType + this.suffix;
    }

    @Override
    public TypeGenerator.Members getConstructors(TypeData.Type type) {
        boolean _tripleEquals_1;
        boolean _tripleEquals;
        TypeGenerator.Members members = new TypeGenerator.Members();
        this.requireTypes(JsonNode.class, JsonOverlay.class);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("public ");
        String _implType = type.getImplType();
        _builder.append(_implType);
        _builder.append("(JsonNode json, JsonOverlay<?> parent, ReferenceManager refMgr) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("super(json, parent, ");
        String _extensionOf = type.getExtensionOf();
        boolean bl = _tripleEquals = _extensionOf == null;
        if (_tripleEquals) {
            _builder.append("factory, ");
        }
        _builder.append("refMgr);");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        members.addMember(_builder.toString());
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("public ");
        String _implType_1 = type.getImplType();
        _builder_1.append(_implType_1);
        _builder_1.append("(");
        String _name = type.getName();
        _builder_1.append(_name);
        _builder_1.append(" ");
        String _lcName = type.getLcName();
        _builder_1.append(_lcName);
        _builder_1.append(", JsonOverlay<?> parent, ReferenceManager refMgr) {");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("\t");
        _builder_1.append("super(");
        String _lcName_1 = type.getLcName();
        _builder_1.append(_lcName_1, "\t");
        _builder_1.append(", parent, ");
        String _extensionOf_1 = type.getExtensionOf();
        boolean bl2 = _tripleEquals_1 = _extensionOf_1 == null;
        if (_tripleEquals_1) {
            _builder_1.append("factory, ");
        }
        _builder_1.append("refMgr);");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("}");
        _builder_1.newLine();
        members.addMember(_builder_1.toString());
        return members;
    }

    private TypeGenerator.Members getBuilderMethods(TypeData.Type type) {
        boolean _not;
        TypeGenerator.Members members = new TypeGenerator.Members();
        this.requireTypes(Builder.class, OverlayFactory.class, IJsonOverlay.class);
        String _xifexpression = null;
        boolean _isEnum = this.isEnum(type);
        if (_isEnum) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("IJsonOverlay<");
            String _name = type.getName();
            _builder.append(_name);
            _builder.append(">");
            _xifexpression = _builder.toString();
        } else {
            _xifexpression = type.getName();
        }
        String createType = _xifexpression;
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("public static <OV extends IJsonOverlay<?>> Builder<");
        String _name_1 = type.getName();
        _builder_1.append(_name_1);
        _builder_1.append("> builder(OV modelMember) {");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("\t");
        _builder_1.append("return new Builder<");
        String _name_2 = type.getName();
        _builder_1.append(_name_2, "\t");
        _builder_1.append(">(factory, modelMember);");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("}");
        _builder_1.newLine();
        members.addMember(_builder_1.toString());
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("public static <OV extends IJsonOverlay<?>> ");
        _builder_2.append(createType);
        _builder_2.append(" create(OV modelMember) {");
        _builder_2.newLineIfNotEmpty();
        _builder_2.append("\t");
        _builder_2.append("return ");
        boolean _isEnum_1 = this.isEnum(type);
        boolean bl = _not = !_isEnum_1;
        if (_not) {
            _builder_2.append("(");
            String _name_3 = type.getName();
            _builder_2.append(_name_3, "\t");
            _builder_2.append(") ");
        }
        _builder_2.append("builder(modelMember).build();");
        _builder_2.newLineIfNotEmpty();
        _builder_2.append("}");
        _builder_2.newLine();
        members.addMember(_builder_2.toString());
        return members;
    }

    @Override
    public boolean skipField(TypeData.Field field) {
        return field.isNoImpl();
    }

    @Override
    public TypeGenerator.Members getFieldMethods(TypeData.Field field) {
        TypeGenerator.Members methods = new TypeGenerator.Members();
        boolean first = true;
        TypeData.Structure _structure = field.getStructure();
        if (_structure != null) {
            switch (_structure) {
                case scalar: {
                    TypeGenerator.Members _scalarMethods = this.getScalarMethods(field);
                    for (SimpleJavaGenerator.Member method : _scalarMethods) {
                        SimpleJavaGenerator.Member _override = methods.addMember(method).override();
                        String _xifexpression = null;
                        if (first) {
                            _xifexpression = field.getName();
                        }
                        _override.comment(_xifexpression);
                        first = false;
                    }
                    break;
                }
                case collection: {
                    TypeGenerator.Members _collectionMethods = this.getCollectionMethods(field);
                    for (SimpleJavaGenerator.Member method_1 : _collectionMethods) {
                        SimpleJavaGenerator.Member _override = methods.addMember(method_1).override();
                        String _xifexpression = null;
                        if (first) {
                            _xifexpression = field.getName();
                        }
                        _override.comment(_xifexpression);
                        first = false;
                    }
                    break;
                }
                case map: {
                    TypeGenerator.Members _mapMethods = this.getMapMethods(field);
                    for (SimpleJavaGenerator.Member method_2 : _mapMethods) {
                        SimpleJavaGenerator.Member _override = methods.addMember(method_2).override();
                        String _xifexpression = null;
                        if (first) {
                            _xifexpression = field.getName();
                        }
                        _override.comment(_xifexpression);
                        first = false;
                    }
                    break;
                }
            }
        }
        return methods;
    }

    private TypeGenerator.Members getScalarMethods(TypeData.Field f) {
        boolean _isBoolean;
        TypeGenerator.Members methods = new TypeGenerator.Members();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("public ");
        String _type = f.getType();
        _builder.append(_type);
        _builder.append(" get");
        String _name = f.getName();
        _builder.append(_name);
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return _get(\"");
        String _propertyName = f.getPropertyName();
        _builder.append(_propertyName, "\t");
        _builder.append("\", ");
        String _type_1 = f.getType();
        _builder.append(_type_1, "\t");
        _builder.append(".class);");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        methods.addMember(_builder.toString());
        if (Objects.equal((Object)f.getStructure(), (Object)TypeData.Structure.scalar) && !f.isScalarType()) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("public ");
            String _type_2 = f.getType();
            _builder_1.append(_type_2);
            _builder_1.append(" get");
            String _name_1 = f.getName();
            _builder_1.append(_name_1);
            _builder_1.append("(boolean elaborate) {");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t");
            _builder_1.append("return _get(\"");
            String _propertyName_1 = f.getPropertyName();
            _builder_1.append(_propertyName_1, "\t");
            _builder_1.append("\", elaborate, ");
            String _type_3 = f.getType();
            _builder_1.append(_type_3, "\t");
            _builder_1.append(".class);");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("}");
            _builder_1.newLine();
            methods.addMember(_builder_1.toString());
        }
        if (_isBoolean = f.isBoolean()) {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("public boolean is");
            String _name_2 = f.getName();
            _builder_2.append(_name_2);
            _builder_2.append("() {");
            _builder_2.newLineIfNotEmpty();
            _builder_2.append("\t");
            _builder_2.append("Boolean bool = _get(\"");
            String _propertyName_2 = f.getPropertyName();
            _builder_2.append(_propertyName_2, "\t");
            _builder_2.append("\", Boolean.class);");
            _builder_2.newLineIfNotEmpty();
            _builder_2.append("\t");
            _builder_2.append("return bool != null ? bool : ");
            boolean _boolDefault = f.getBoolDefault();
            _builder_2.append((Object)_boolDefault, "\t");
            _builder_2.append(";");
            _builder_2.newLineIfNotEmpty();
            _builder_2.append("}");
            _builder_2.newLine();
            methods.addMember(_builder_2.toString());
        }
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append("public void set");
        String _name_3 = f.getName();
        _builder_3.append(_name_3);
        _builder_3.append("(");
        String _type_4 = f.getType();
        _builder_3.append(_type_4);
        _builder_3.append(" ");
        String _lcName = f.getLcName();
        _builder_3.append(_lcName);
        _builder_3.append(") {");
        _builder_3.newLineIfNotEmpty();
        _builder_3.append("\t");
        _builder_3.append("_setScalar(\"");
        String _propertyName_3 = f.getPropertyName();
        _builder_3.append(_propertyName_3, "\t");
        _builder_3.append("\", ");
        String _lcName_1 = f.getLcName();
        _builder_3.append(_lcName_1, "\t");
        _builder_3.append(", ");
        String _type_5 = f.getType();
        _builder_3.append(_type_5, "\t");
        _builder_3.append(".class);");
        _builder_3.newLineIfNotEmpty();
        _builder_3.append("}");
        _builder_3.newLine();
        methods.addMember(_builder_3.toString());
        return methods;
    }

    private TypeGenerator.Members getCollectionMethods(TypeData.Field f) {
        this.requireTypes(List.class, ListOverlay.class);
        TypeGenerator.Members methods = new TypeGenerator.Members();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("public List<");
        String _type = f.getType();
        _builder.append(_type);
        _builder.append("> get");
        String _plural = f.getPlural();
        _builder.append(_plural);
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return _getList(\"");
        String _propertyName = f.getPropertyName();
        _builder.append(_propertyName, "\t");
        _builder.append("\", ");
        String _type_1 = f.getType();
        _builder.append(_type_1, "\t");
        _builder.append(".class);");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        methods.addMember(_builder.toString());
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("public List<");
        String _type_2 = f.getType();
        _builder_1.append(_type_2);
        _builder_1.append("> get");
        String _plural_1 = f.getPlural();
        _builder_1.append(_plural_1);
        _builder_1.append("(boolean elaborate) {");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("\t");
        _builder_1.append("return _getList(\"");
        String _propertyName_1 = f.getPropertyName();
        _builder_1.append(_propertyName_1, "\t");
        _builder_1.append("\", elaborate, ");
        String _type_3 = f.getType();
        _builder_1.append(_type_3, "\t");
        _builder_1.append(".class);");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("}");
        _builder_1.newLine();
        methods.addMember(_builder_1.toString());
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("public boolean has");
        String _plural_2 = f.getPlural();
        _builder_2.append(_plural_2);
        _builder_2.append("() {");
        _builder_2.newLineIfNotEmpty();
        _builder_2.append("\t");
        _builder_2.append("return _isPresent(\"");
        String _propertyName_2 = f.getPropertyName();
        _builder_2.append(_propertyName_2, "\t");
        _builder_2.append("\");");
        _builder_2.newLineIfNotEmpty();
        _builder_2.append("}");
        _builder_2.newLine();
        methods.addMember(_builder_2.toString());
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append("public ");
        String _type_4 = f.getType();
        _builder_3.append(_type_4);
        _builder_3.append(" get");
        String _name = f.getName();
        _builder_3.append(_name);
        _builder_3.append("(int index) {");
        _builder_3.newLineIfNotEmpty();
        _builder_3.append("\t");
        _builder_3.append("return _get(\"");
        String _propertyName_3 = f.getPropertyName();
        _builder_3.append(_propertyName_3, "\t");
        _builder_3.append("\", index, ");
        String _type_5 = f.getType();
        _builder_3.append(_type_5, "\t");
        _builder_3.append(".class);");
        _builder_3.newLineIfNotEmpty();
        _builder_3.append("}");
        _builder_3.newLine();
        methods.addMember(_builder_3.toString());
        StringConcatenation _builder_4 = new StringConcatenation();
        _builder_4.append("public void set");
        String _plural_3 = f.getPlural();
        _builder_4.append(_plural_3);
        _builder_4.append("(List<");
        String _type_6 = f.getType();
        _builder_4.append(_type_6);
        _builder_4.append("> ");
        String _lcPlural = f.getLcPlural();
        _builder_4.append(_lcPlural);
        _builder_4.append(") {");
        _builder_4.newLineIfNotEmpty();
        _builder_4.append("\t");
        _builder_4.append("_setList(\"");
        String _propertyName_4 = f.getPropertyName();
        _builder_4.append(_propertyName_4, "\t");
        _builder_4.append("\", ");
        String _lcPlural_1 = f.getLcPlural();
        _builder_4.append(_lcPlural_1, "\t");
        _builder_4.append(", ");
        String _type_7 = f.getType();
        _builder_4.append(_type_7, "\t");
        _builder_4.append(".class);");
        _builder_4.newLineIfNotEmpty();
        _builder_4.append("}");
        _builder_4.newLine();
        methods.addMember(_builder_4.toString());
        StringConcatenation _builder_5 = new StringConcatenation();
        _builder_5.append("public void set");
        String _name_1 = f.getName();
        _builder_5.append(_name_1);
        _builder_5.append("(int index, ");
        String _type_8 = f.getType();
        _builder_5.append(_type_8);
        _builder_5.append(" ");
        String _lcName = f.getLcName();
        _builder_5.append(_lcName);
        _builder_5.append(") {");
        _builder_5.newLineIfNotEmpty();
        _builder_5.append("\t");
        _builder_5.append("_set(\"");
        String _propertyName_5 = f.getPropertyName();
        _builder_5.append(_propertyName_5, "\t");
        _builder_5.append("\", index, ");
        String _lcName_1 = f.getLcName();
        _builder_5.append(_lcName_1, "\t");
        _builder_5.append(", ");
        String _type_9 = f.getType();
        _builder_5.append(_type_9, "\t");
        _builder_5.append(".class);");
        _builder_5.newLineIfNotEmpty();
        _builder_5.append("}");
        _builder_5.newLine();
        methods.addMember(_builder_5.toString());
        StringConcatenation _builder_6 = new StringConcatenation();
        _builder_6.append("public void add");
        String _name_2 = f.getName();
        _builder_6.append(_name_2);
        _builder_6.append("(");
        String _type_10 = f.getType();
        _builder_6.append(_type_10);
        _builder_6.append(" ");
        String _lcName_2 = f.getLcName();
        _builder_6.append(_lcName_2);
        _builder_6.append(") {");
        _builder_6.newLineIfNotEmpty();
        _builder_6.append("\t");
        _builder_6.append("_add(\"");
        String _propertyName_6 = f.getPropertyName();
        _builder_6.append(_propertyName_6, "\t");
        _builder_6.append("\", ");
        String _lcName_3 = f.getLcName();
        _builder_6.append(_lcName_3, "\t");
        _builder_6.append(", ");
        String _type_11 = f.getType();
        _builder_6.append(_type_11, "\t");
        _builder_6.append(".class);");
        _builder_6.newLineIfNotEmpty();
        _builder_6.append("}");
        _builder_6.newLine();
        methods.addMember(_builder_6.toString());
        StringConcatenation _builder_7 = new StringConcatenation();
        _builder_7.append("public void insert");
        String _name_3 = f.getName();
        _builder_7.append(_name_3);
        _builder_7.append("(int index, ");
        String _type_12 = f.getType();
        _builder_7.append(_type_12);
        _builder_7.append(" ");
        String _lcName_4 = f.getLcName();
        _builder_7.append(_lcName_4);
        _builder_7.append(") {");
        _builder_7.newLineIfNotEmpty();
        _builder_7.append("\t");
        _builder_7.append("_insert(\"");
        String _propertyName_7 = f.getPropertyName();
        _builder_7.append(_propertyName_7, "\t");
        _builder_7.append("\", index, ");
        String _lcName_5 = f.getLcName();
        _builder_7.append(_lcName_5, "\t");
        _builder_7.append(", ");
        String _type_13 = f.getType();
        _builder_7.append(_type_13, "\t");
        _builder_7.append(".class);");
        _builder_7.newLineIfNotEmpty();
        _builder_7.append("}");
        _builder_7.newLine();
        methods.addMember(_builder_7.toString());
        StringConcatenation _builder_8 = new StringConcatenation();
        _builder_8.append("public void remove");
        String _name_4 = f.getName();
        _builder_8.append(_name_4);
        _builder_8.append("(int index) {");
        _builder_8.newLineIfNotEmpty();
        _builder_8.append("\t");
        _builder_8.append("_remove(\"");
        String _propertyName_8 = f.getPropertyName();
        _builder_8.append(_propertyName_8, "\t");
        _builder_8.append("\", index, ");
        String _type_14 = f.getType();
        _builder_8.append(_type_14, "\t");
        _builder_8.append(".class);");
        _builder_8.newLineIfNotEmpty();
        _builder_8.append("}");
        _builder_8.newLine();
        methods.addMember(_builder_8.toString());
        return methods;
    }

    private TypeGenerator.Members getMapMethods(TypeData.Field f) {
        this.requireTypes(Map.class, MapOverlay.class);
        TypeGenerator.Members methods = new TypeGenerator.Members();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("public Map<String, ");
        String _type = f.getType();
        _builder.append(_type);
        _builder.append("> get");
        String _plural = f.getPlural();
        _builder.append(_plural);
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("return _getMap(\"");
        String _propertyName = f.getPropertyName();
        _builder.append(_propertyName, "\t");
        _builder.append("\", ");
        String _type_1 = f.getType();
        _builder.append(_type_1, "\t");
        _builder.append(".class);");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        methods.addMember(_builder.toString());
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("public Map<String, ");
        String _type_2 = f.getType();
        _builder_1.append(_type_2);
        _builder_1.append("> get");
        String _plural_1 = f.getPlural();
        _builder_1.append(_plural_1);
        _builder_1.append("(boolean elaborate) {");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("\t");
        _builder_1.append("return _getMap(\"");
        String _propertyName_1 = f.getPropertyName();
        _builder_1.append(_propertyName_1, "\t");
        _builder_1.append("\", elaborate, ");
        String _type_3 = f.getType();
        _builder_1.append(_type_3, "\t");
        _builder_1.append(".class);");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("}");
        _builder_1.newLine();
        methods.addMember(_builder_1.toString());
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("public boolean has");
        String _plural_2 = f.getPlural();
        _builder_2.append(_plural_2);
        _builder_2.append("() {");
        _builder_2.newLineIfNotEmpty();
        _builder_2.append("\t");
        _builder_2.append("return _isPresent(\"");
        String _propertyName_2 = f.getPropertyName();
        _builder_2.append(_propertyName_2, "\t");
        _builder_2.append("\");");
        _builder_2.newLineIfNotEmpty();
        _builder_2.append("}");
        _builder_2.newLine();
        methods.addMember(_builder_2.toString());
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append("public boolean has");
        String _name = f.getName();
        _builder_3.append(_name);
        _builder_3.append("(String ");
        String _keyName = f.getKeyName();
        _builder_3.append(_keyName);
        _builder_3.append(") {");
        _builder_3.newLineIfNotEmpty();
        _builder_3.append("\t");
        _builder_3.append("return _getMap(\"");
        String _propertyName_3 = f.getPropertyName();
        _builder_3.append(_propertyName_3, "\t");
        _builder_3.append("\", ");
        String _type_4 = f.getType();
        _builder_3.append(_type_4, "\t");
        _builder_3.append(".class).containsKey(");
        String _keyName_1 = f.getKeyName();
        _builder_3.append(_keyName_1, "\t");
        _builder_3.append(");");
        _builder_3.newLineIfNotEmpty();
        _builder_3.append("}");
        _builder_3.newLine();
        methods.addMember(_builder_3.toString());
        StringConcatenation _builder_4 = new StringConcatenation();
        _builder_4.append("public ");
        String _type_5 = f.getType();
        _builder_4.append(_type_5);
        _builder_4.append(" get");
        String _name_1 = f.getName();
        _builder_4.append(_name_1);
        _builder_4.append("(String ");
        String _keyName_2 = f.getKeyName();
        _builder_4.append(_keyName_2);
        _builder_4.append(") {");
        _builder_4.newLineIfNotEmpty();
        _builder_4.append("\t");
        _builder_4.append("return _get(\"");
        String _propertyName_4 = f.getPropertyName();
        _builder_4.append(_propertyName_4, "\t");
        _builder_4.append("\", ");
        String _keyName_3 = f.getKeyName();
        _builder_4.append(_keyName_3, "\t");
        _builder_4.append(", ");
        String _type_6 = f.getType();
        _builder_4.append(_type_6, "\t");
        _builder_4.append(".class);");
        _builder_4.newLineIfNotEmpty();
        _builder_4.append("}");
        _builder_4.newLine();
        methods.addMember(_builder_4.toString());
        StringConcatenation _builder_5 = new StringConcatenation();
        _builder_5.append("public void set");
        String _plural_3 = f.getPlural();
        _builder_5.append(_plural_3);
        _builder_5.append("(Map<String, ");
        String _type_7 = f.getType();
        _builder_5.append(_type_7);
        _builder_5.append("> ");
        String _lcPlural = f.getLcPlural();
        _builder_5.append(_lcPlural);
        _builder_5.append(") {");
        _builder_5.newLineIfNotEmpty();
        _builder_5.append("\t");
        _builder_5.append("_setMap(\"");
        String _propertyName_5 = f.getPropertyName();
        _builder_5.append(_propertyName_5, "\t");
        _builder_5.append("\", ");
        String _lcPlural_1 = f.getLcPlural();
        _builder_5.append(_lcPlural_1, "\t");
        _builder_5.append(", ");
        String _type_8 = f.getType();
        _builder_5.append(_type_8, "\t");
        _builder_5.append(".class);");
        _builder_5.newLineIfNotEmpty();
        _builder_5.append("}");
        _builder_5.newLine();
        methods.addMember(_builder_5.toString());
        StringConcatenation _builder_6 = new StringConcatenation();
        _builder_6.append("public void set");
        String _name_2 = f.getName();
        _builder_6.append(_name_2);
        _builder_6.append("(String ");
        String _keyName_4 = f.getKeyName();
        _builder_6.append(_keyName_4);
        _builder_6.append(", ");
        String _type_9 = f.getType();
        _builder_6.append(_type_9);
        _builder_6.append(" ");
        String _lcName = f.getLcName();
        _builder_6.append(_lcName);
        _builder_6.append(") {");
        _builder_6.newLineIfNotEmpty();
        _builder_6.append("\t");
        _builder_6.append("_set(\"");
        String _propertyName_6 = f.getPropertyName();
        _builder_6.append(_propertyName_6, "\t");
        _builder_6.append("\", ");
        String _keyName_5 = f.getKeyName();
        _builder_6.append(_keyName_5, "\t");
        _builder_6.append(", ");
        String _lcName_1 = f.getLcName();
        _builder_6.append(_lcName_1, "\t");
        _builder_6.append(", ");
        String _type_10 = f.getType();
        _builder_6.append(_type_10, "\t");
        _builder_6.append(".class);");
        _builder_6.newLineIfNotEmpty();
        _builder_6.append("}");
        _builder_6.newLine();
        methods.addMember(_builder_6.toString());
        StringConcatenation _builder_7 = new StringConcatenation();
        _builder_7.append("public void remove");
        String _name_3 = f.getName();
        _builder_7.append(_name_3);
        _builder_7.append("(String ");
        String _keyName_6 = f.getKeyName();
        _builder_7.append(_keyName_6);
        _builder_7.append(") {");
        _builder_7.newLineIfNotEmpty();
        _builder_7.append("\t");
        _builder_7.append("_remove(\"");
        String _propertyName_7 = f.getPropertyName();
        _builder_7.append(_propertyName_7, "\t");
        _builder_7.append("\", ");
        String _keyName_7 = f.getKeyName();
        _builder_7.append(_keyName_7, "\t");
        _builder_7.append(", ");
        String _type_11 = f.getType();
        _builder_7.append(_type_11, "\t");
        _builder_7.append(".class);");
        _builder_7.newLineIfNotEmpty();
        _builder_7.append("}");
        _builder_7.newLine();
        methods.addMember(_builder_7.toString());
        return methods;
    }

    private TypeGenerator.Members getFieldNameConstants(TypeData.Type type) {
        TypeGenerator.Members members = new TypeGenerator.Members();
        Functions.Function1 _function = it -> {
            boolean _isNoImpl = it.isNoImpl();
            return !_isNoImpl;
        };
        Iterable _filter = IterableExtensions.filter(type.getFields().values(), (Functions.Function1)_function);
        for (TypeData.Field f : _filter) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("public static final String F_");
            String _propertyName = f.getPropertyName();
            _builder.append(_propertyName);
            _builder.append(" = \"");
            String _propertyName_1 = f.getPropertyName();
            _builder.append(_propertyName_1);
            _builder.append("\";");
            _builder.newLineIfNotEmpty();
            SimpleJavaGenerator.Member _member = new SimpleJavaGenerator.Member(_builder.toString());
            members.add(_member);
        }
        return members;
    }

    private SimpleJavaGenerator.Member getElaborateJsonMethod(TypeData.Type type) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("protected void _elaborateJson() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("super._elaborateJson();");
        _builder.newLine();
        Functions.Function1 _function = it -> {
            boolean _isNoImpl = it.isNoImpl();
            return !_isNoImpl;
        };
        Iterable _filter = IterableExtensions.filter(type.getFields().values(), (Functions.Function1)_function);
        for (TypeData.Field f : _filter) {
            _builder.append("\t");
            String _elaborateStatement = this.getElaborateStatement(f);
            _builder.append(_elaborateStatement, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("}");
        _builder.newLine();
        return new SimpleJavaGenerator.Member(_builder.toString()).override();
    }

    private String getElaborateStatement(TypeData.Field f) {
        this.requireTypes(f.getImplType());
        String _switchResult = null;
        TypeData.Structure _structure = f.getStructure();
        if (_structure != null) {
            switch (_structure) {
                case scalar: {
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append("_createScalar(\"");
                    String _propertyName = f.getPropertyName();
                    _builder.append(_propertyName);
                    _builder.append("\", \"");
                    String _parentPath = f.getParentPath();
                    _builder.append(_parentPath);
                    _builder.append("\", ");
                    String _implType = f.getImplType();
                    _builder.append(_implType);
                    _builder.append(".factory);");
                    _switchResult = _builder.toString();
                    break;
                }
                case collection: {
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append("_createList(\"");
                    String _propertyName_1 = f.getPropertyName();
                    _builder_1.append(_propertyName_1);
                    _builder_1.append("\", \"");
                    String _parentPath_1 = f.getParentPath();
                    _builder_1.append(_parentPath_1);
                    _builder_1.append("\", ");
                    String _implType_1 = f.getImplType();
                    _builder_1.append(_implType_1);
                    _builder_1.append(".factory);");
                    _switchResult = _builder_1.toString();
                    break;
                }
                case map: {
                    boolean _tripleNotEquals;
                    String _xblockexpression = null;
                    String _xifexpression = null;
                    String _keyPattern = f.getKeyPattern();
                    boolean bl = _tripleNotEquals = _keyPattern != null;
                    if (_tripleNotEquals) {
                        StringConcatenation _builder_2 = new StringConcatenation();
                        _builder_2.append("\"");
                        String _replaceAll = f.getKeyPattern().replaceAll("\\\\", "\\\\\\\\");
                        _builder_2.append(_replaceAll);
                        _builder_2.append("\"");
                        _xifexpression = _builder_2.toString();
                    } else {
                        _xifexpression = "null";
                    }
                    String pat = _xifexpression;
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append("_createMap(\"");
                    String _propertyName_2 = f.getPropertyName();
                    _builder_3.append(_propertyName_2);
                    _builder_3.append("\", \"");
                    String _parentPath_2 = f.getParentPath();
                    _builder_3.append(_parentPath_2);
                    _builder_3.append("\", ");
                    String _implType_2 = f.getImplType();
                    _builder_3.append(_implType_2);
                    _builder_3.append(".factory, ");
                    _builder_3.append(pat);
                    _builder_3.append(");");
                    _switchResult = _xblockexpression = _builder_3.toString();
                    break;
                }
            }
        }
        return _switchResult;
    }

    private SimpleJavaGenerator.Member getEnumFactoryMember(TypeData.Type type) {
        this.requireTypes(OverlayFactory.class, JsonOverlay.class, JsonNode.class, ReferenceManager.class);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("public static OverlayFactory<");
        String _name = type.getName();
        _builder.append(_name);
        _builder.append("> factory = new OverlayFactory<");
        String _name_1 = type.getName();
        _builder.append(_name_1);
        _builder.append(">() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("protected Class<? extends JsonOverlay<? super ");
        String _name_2 = type.getName();
        _builder.append(_name_2, "\t");
        _builder.append(">> getOverlayClass() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return ");
        String _implType = type.getImplType();
        _builder.append(_implType, "\t\t");
        _builder.append(".class;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public JsonOverlay<");
        String _name_3 = type.getName();
        _builder.append(_name_3, "\t");
        _builder.append("> _create(");
        String _name_4 = type.getName();
        _builder.append(_name_4, "\t");
        _builder.append(" ");
        String _lcName = type.getLcName();
        _builder.append(_lcName, "\t");
        _builder.append(", JsonOverlay<?> parent, ReferenceManager refMgr) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return new ");
        String _implType_1 = type.getImplType();
        _builder.append(_implType_1, "\t\t");
        _builder.append("(");
        String _lcName_1 = type.getLcName();
        _builder.append(_lcName_1, "\t\t");
        _builder.append(", parent, refMgr);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public JsonOverlay<");
        String _name_5 = type.getName();
        _builder.append(_name_5, "\t");
        _builder.append("> _create(JsonNode json, JsonOverlay<?> parent, ReferenceManager refMgr) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return new ");
        String _implType_2 = type.getImplType();
        _builder.append(_implType_2, "\t\t");
        _builder.append("(json, parent, refMgr);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}\t\t\t");
        _builder.newLine();
        _builder.append("};");
        _builder.newLine();
        return new SimpleJavaGenerator.Member(_builder.toString());
    }

    private TypeGenerator.Members getFactoryMembers(TypeData.Type type) {
        TypeGenerator.Members members = new TypeGenerator.Members();
        members.add(this.getFactoryMember(type));
        members.addAll(this.getSubtypeMethods(type));
        return members;
    }

    private SimpleJavaGenerator.Member getFactoryMember(TypeData.Type type) {
        this.requireTypes(OverlayFactory.class, JsonNode.class, ReferenceManager.class, JsonOverlay.class);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("public static OverlayFactory<");
        String _name = type.getName();
        _builder.append(_name);
        _builder.append("> factory = new OverlayFactory<");
        String _name_1 = type.getName();
        _builder.append(_name_1);
        _builder.append(">(){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("protected Class<? extends JsonOverlay<? super ");
        String _name_2 = type.getName();
        _builder.append(_name_2, "\t");
        _builder.append(">> getOverlayClass() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return ");
        String _implType = type.getImplType();
        _builder.append(_implType, "\t\t");
        _builder.append(".class;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public JsonOverlay<");
        String _name_3 = type.getName();
        _builder.append(_name_3, "\t");
        _builder.append("> _create(");
        String _name_4 = type.getName();
        _builder.append(_name_4, "\t");
        _builder.append(" ");
        String _lcName = type.getLcName();
        _builder.append(_lcName, "\t");
        _builder.append(", JsonOverlay<?> parent, ReferenceManager refMgr) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("JsonOverlay<?> overlay;");
        _builder.newLine();
        boolean _isEmpty = this.getSubTypes(type).isEmpty();
        if (_isEmpty) {
            _builder.append("\t\t");
            _builder.append("overlay = new ");
            String _implType_1 = type.getImplType();
            _builder.append(_implType_1, "\t\t");
            _builder.append("(");
            String _lcName_1 = type.getLcName();
            _builder.append(_lcName_1, "\t\t");
            _builder.append(", parent, refMgr);");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("\t\t");
            _builder.append("Class<? extends ");
            String _name_5 = type.getName();
            _builder.append(_name_5, "\t\t");
            _builder.append("> subtype = getSubtypeOf(");
            String _lcName_2 = type.getLcName();
            _builder.append(_lcName_2, "\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            String _subtypeCreate = this.getSubtypeCreate(type, type.getLcName());
            _builder.append(_subtypeCreate, "\t\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append("@SuppressWarnings(\"unchecked\")");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("JsonOverlay<");
        String _name_6 = type.getName();
        _builder.append(_name_6, "\t\t");
        _builder.append("> castOverlay = (JsonOverlay<");
        String _name_7 = type.getName();
        _builder.append(_name_7, "\t\t");
        _builder.append(">) overlay;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return castOverlay;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public JsonOverlay<");
        String _name_8 = type.getName();
        _builder.append(_name_8, "\t");
        _builder.append("> _create(JsonNode json, JsonOverlay<?> parent, ReferenceManager refMgr) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("JsonOverlay<?> overlay;");
        _builder.newLine();
        boolean _isEmpty_1 = this.getSubTypes(type).isEmpty();
        if (_isEmpty_1) {
            _builder.append("\t\t");
            _builder.append("overlay = new ");
            String _implType_2 = type.getImplType();
            _builder.append(_implType_2, "\t\t");
            _builder.append("(json, parent, refMgr);");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("\t\t");
            _builder.append("Class<? extends ");
            String _name_9 = type.getName();
            _builder.append(_name_9, "\t\t");
            _builder.append("> subtype = getSubtypeOf(json);");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            String _subtypeCreate_1 = this.getSubtypeCreate(type, ".json");
            _builder.append(_subtypeCreate_1, "\t\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append("@SuppressWarnings(\"unchecked\")");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("JsonOverlay<");
        String _name_10 = type.getName();
        _builder.append(_name_10, "\t\t");
        _builder.append("> castOverlay = (JsonOverlay<");
        String _name_11 = type.getName();
        _builder.append(_name_11, "\t\t");
        _builder.append(">) overlay;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("return castOverlay;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        boolean _isEmpty_2 = this.getSubTypes(type).isEmpty();
        boolean _not = !_isEmpty_2;
        CharSequence _isExtendedType = this.getIsExtendedType(_not);
        _builder.append((Object)_isExtendedType, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("};\t");
        _builder.newLine();
        return new SimpleJavaGenerator.Member(_builder.toString());
    }

    private TypeGenerator.Members getSubtypeMethods(TypeData.Type type) {
        TypeGenerator.Members members = new TypeGenerator.Members();
        Collection<TypeData.Type> subTypes = this.getSubTypes(type);
        if (!subTypes.isEmpty() && !type.isAbstract()) {
            subTypes.add(type);
        }
        members.add(this.getValueSubtypeSelector(type, subTypes));
        members.add(this.getJsonSubtypeSelector(type, subTypes));
        return members;
    }

    private CharSequence getIsExtendedType(boolean isExtended) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("protected boolean isExtendedType() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return ");
        String _xifexpression = null;
        _xifexpression = isExtended ? "true" : "false";
        _builder.append(_xifexpression, "\t");
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    private SimpleJavaGenerator.Member getValueSubtypeSelector(TypeData.Type t, Collection<TypeData.Type> subTypes) {
        StringConcatenation _builder = new StringConcatenation();
        String _lcName = t.getLcName();
        _builder.append(_lcName);
        _builder.append(".getClass().getSimpleName()");
        String switchExpr = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("private static Class<? extends ");
        String _name = t.getName();
        _builder_1.append(_name);
        _builder_1.append("> getSubtypeOf(");
        String _name_1 = t.getName();
        _builder_1.append(_name_1);
        _builder_1.append(" ");
        String _lcName_1 = t.getLcName();
        _builder_1.append(_lcName_1);
        _builder_1.append(") {");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("\t");
        Functions.Function1 _function = it -> it.getName();
        String _subtypeSwitch = this.getSubtypeSwitch(t, subTypes, switchExpr, (Functions.Function1<? super TypeData.Type, ? extends String>)_function);
        _builder_1.append(_subtypeSwitch, "\t");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("}");
        _builder_1.newLine();
        return new SimpleJavaGenerator.Member(_builder_1.toString());
    }

    private SimpleJavaGenerator.Member getJsonSubtypeSelector(TypeData.Type t, Collection<TypeData.Type> subTypes) {
        this.requireTypes(JsonPointer.class, Collectors.class);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("json.at(JsonPointer.compile(\"/");
        String _discriminator = t.getDiscriminator();
        _builder.append(_discriminator);
        _builder.append("\")).asText()");
        String switchExpr = _builder.toString();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("private static Class<? extends ");
        String _name = t.getName();
        _builder_1.append(_name);
        _builder_1.append("> getSubtypeOf(JsonNode json) {");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("\t");
        Functions.Function1 _function = it -> it.getDiscriminatorValue();
        String _subtypeSwitch = this.getSubtypeSwitch(t, subTypes, switchExpr, (Functions.Function1<? super TypeData.Type, ? extends String>)_function);
        _builder_1.append(_subtypeSwitch, "\t");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("}");
        _builder_1.newLine();
        return new SimpleJavaGenerator.Member(_builder_1.toString());
    }

    private String getSubtypeSwitch(TypeData.Type t, Collection<TypeData.Type> subTypes, String switchExpr, Functions.Function1<? super TypeData.Type, ? extends String> discFn) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = subTypes.isEmpty();
        if (_isEmpty) {
            _builder.append("return ");
            String _name = t.getName();
            _builder.append(_name);
            _builder.append(".class;");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("switch(");
            _builder.append(switchExpr);
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            for (TypeData.Type sub : subTypes) {
                _builder.append("\t");
                _builder.append("case \"");
                String _apply = (String)discFn.apply((Object)sub);
                _builder.append(_apply, "\t");
                _builder.append("\":");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("return ");
                String _name_1 = sub.getName();
                _builder.append(_name_1, "\t\t");
                _builder.append(".class;");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("default:");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("return null;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        return _builder.toString();
    }

    private String getSubtypeCreate(TypeData.Type t, String arg0) {
        Collection<TypeData.Type> subtypes = this.getSubTypes(t);
        boolean _isEmpty = subtypes.isEmpty();
        if (_isEmpty) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("overlay = new ");
            String _implType = t.getImplType();
            _builder.append(_implType);
            _builder.append("(");
            String _castArg0 = this.castArg0(t, arg0);
            _builder.append(_castArg0);
            _builder.append(", parent, refMgr);");
            _builder.newLineIfNotEmpty();
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("switch (subtype != null ? subtype.getSimpleName() : \"\") {");
        _builder_1.newLine();
        for (TypeData.Type sub : subtypes) {
            _builder_1.append("\t");
            _builder_1.append("case \"");
            String _name = sub.getName();
            _builder_1.append(_name, "\t");
            _builder_1.append("\":");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t");
            _builder_1.append("\t");
            _builder_1.append("overlay = ");
            String _implType_1 = sub.getImplType();
            _builder_1.append(_implType_1, "\t\t");
            _builder_1.append(".factory.create(");
            String _castArg0_1 = this.castArg0(sub, arg0);
            _builder_1.append(_castArg0_1, "\t\t");
            _builder_1.append(", parent, refMgr);");
            _builder_1.newLineIfNotEmpty();
            _builder_1.append("\t");
            _builder_1.append("\t");
            _builder_1.append("break;");
            _builder_1.newLine();
        }
        _builder_1.append("\t");
        _builder_1.append("default:");
        _builder_1.newLine();
        _builder_1.append("\t\t");
        _builder_1.append("overlay = new ");
        String _implType_2 = t.getImplType();
        _builder_1.append(_implType_2, "\t\t");
        _builder_1.append("(");
        String _castArg0_2 = this.castArg0(t, arg0);
        _builder_1.append(_castArg0_2, "\t\t");
        _builder_1.append(", parent, refMgr);");
        _builder_1.newLineIfNotEmpty();
        _builder_1.append("}");
        _builder_1.newLine();
        return _builder_1.toString();
    }

    private String castArg0(TypeData.Type type, String arg0) {
        String _xifexpression = null;
        boolean _equals = Objects.equal(arg0, ".json");
        if (_equals) {
            _xifexpression = "json";
        } else {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("(");
            String _name = type.getName();
            _builder.append(_name);
            _builder.append(") ");
            _builder.append(arg0);
            _xifexpression = _builder.toString();
        }
        return _xifexpression;
    }

    private Collection<TypeData.Type> getSubTypes(TypeData.Type type) {
        HashSet<TypeData.Type> subTypes = new HashSet<TypeData.Type>();
        ArrayDeque<TypeData.Type> todo = new ArrayDeque<TypeData.Type>();
        todo.add(type);
        while (!todo.isEmpty()) {
            TypeData.Type nextType = (TypeData.Type)todo.remove();
            boolean _contains = subTypes.contains(nextType);
            boolean _not = !_contains;
            if (!_not) continue;
            subTypes.add(nextType);
            Functions.Function1 _function = it -> {
                String _extensionOf = it.getExtensionOf();
                String _name = nextType.getName();
                return Objects.equal(_extensionOf, _name);
            };
            Iterable directSubtypes = IterableExtensions.filter(type.getTypeData().getTypes(), (Functions.Function1)_function);
            Iterables.addAll(todo, directSubtypes);
        }
        subTypes.remove(type);
        return subTypes;
    }
}

