/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdf.model.impl;

import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.AnonId;
import org.apache.jena.rdf.model.HasNoModelException;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.LiteralRequiredException;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.RDFVisitor;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceRequiredException;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.LiteralImpl;
import org.apache.jena.rdf.model.impl.ModelCom;

public class ResourceImpl
extends EnhNode
implements Resource {
    public static final Implementation factory = new Implementation(){

        @Override
        public boolean canWrap(Node n, EnhGraph eg) {
            return !n.isLiteral();
        }

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (n.isLiteral()) {
                throw new ResourceRequiredException(n);
            }
            return new ResourceImpl(n, eg);
        }
    };
    public static final Implementation rdfNodeFactory = new Implementation(){

        @Override
        public boolean canWrap(Node n, EnhGraph eg) {
            return true;
        }

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (n.isURI() || n.isBlank()) {
                return new ResourceImpl(n, eg);
            }
            if (n.isLiteral()) {
                return new LiteralImpl(n, eg);
            }
            return null;
        }
    };

    public ResourceImpl(Node n, ModelCom m3) {
        super(n, m3);
    }

    public ResourceImpl() {
        this((ModelCom)null);
    }

    public ResourceImpl(ModelCom m3) {
        this(ResourceImpl.fresh(null), m3);
    }

    public ResourceImpl(Node n, EnhGraph m3) {
        super(n, m3);
    }

    public ResourceImpl(String uri) {
        super(ResourceImpl.fresh(uri), null);
    }

    public ResourceImpl(String nameSpace, String localName) {
        super(NodeFactory.createURI(nameSpace + localName), null);
    }

    public ResourceImpl(AnonId id) {
        this(id, null);
    }

    public ResourceImpl(AnonId id, ModelCom m3) {
        this(NodeFactory.createBlankNode(id.getLabelString()), m3);
    }

    public ResourceImpl(String uri, ModelCom m3) {
        this(ResourceImpl.fresh(uri), m3);
    }

    public ResourceImpl(Resource r, ModelCom m3) {
        this(r.asNode(), m3);
    }

    public ResourceImpl(String nameSpace, String localName, ModelCom m3) {
        this(NodeFactory.createURI(nameSpace + localName), m3);
    }

    @Override
    public Object visitWith(RDFVisitor rv) {
        return this.isAnon() ? rv.visitBlank(this, this.getId()) : rv.visitURI(this, this.getURI());
    }

    @Override
    public Resource asResource() {
        return this;
    }

    @Override
    public Literal asLiteral() {
        throw new LiteralRequiredException(this.asNode());
    }

    @Override
    public Resource inModel(Model m3) {
        return this.getModel() == m3 ? this : (this.isAnon() ? m3.createResource(this.getId()) : (!this.asNode().isConcrete() ? (Resource)m3.getRDFNode(this.asNode()) : m3.createResource(this.getURI())));
    }

    private static Node fresh(String uri) {
        return uri == null ? NodeFactory.createBlankNode() : NodeFactory.createURI(uri);
    }

    @Override
    public AnonId getId() {
        return new AnonId(this.asNode().getBlankNodeId());
    }

    @Override
    public String getURI() {
        return this.isAnon() ? null : this.node.getURI();
    }

    @Override
    public String getNameSpace() {
        return this.isAnon() ? null : this.node.getNameSpace();
    }

    @Override
    public String getLocalName() {
        return this.isAnon() ? null : this.node.getLocalName();
    }

    @Override
    public boolean hasURI(String uri) {
        return this.node.hasURI(uri);
    }

    @Override
    public String toString() {
        return this.asNode().toString();
    }

    protected ModelCom mustHaveModel() {
        ModelCom model = this.getModelCom();
        if (model == null) {
            throw new HasNoModelException(this);
        }
        return model;
    }

    @Override
    public Statement getRequiredProperty(Property p) {
        return this.mustHaveModel().getRequiredProperty(this, p);
    }

    @Override
    public Statement getProperty(Property p) {
        return this.mustHaveModel().getProperty(this, p);
    }

    @Override
    public StmtIterator listProperties(Property p) {
        return this.mustHaveModel().listStatements((Resource)this, p, (RDFNode)null);
    }

    @Override
    public StmtIterator listProperties() {
        return this.mustHaveModel().listStatements((Resource)this, null, (RDFNode)null);
    }

    @Override
    public Resource addLiteral(Property p, boolean o) {
        ModelCom m3 = this.mustHaveModel();
        m3.add((Resource)this, p, m3.createTypedLiteral(o));
        return this;
    }

    public Resource addProperty(Property p, long o) {
        this.mustHaveModel().addLiteral((Resource)this, p, o);
        return this;
    }

    @Override
    public Resource addLiteral(Property p, long o) {
        ModelCom m3 = this.mustHaveModel();
        m3.add((Resource)this, p, m3.createTypedLiteral(o));
        return this;
    }

    @Override
    public Resource addLiteral(Property p, char o) {
        ModelCom m3 = this.mustHaveModel();
        m3.add((Resource)this, p, m3.createTypedLiteral(o));
        return this;
    }

    public Resource addProperty(Property p, float o) {
        this.mustHaveModel().addLiteral((Resource)this, p, o);
        return this;
    }

    public Resource addProperty(Property p, double o) {
        this.mustHaveModel().addLiteral((Resource)this, p, o);
        return this;
    }

    @Override
    public Resource addLiteral(Property p, double o) {
        ModelCom m3 = this.mustHaveModel();
        m3.add((Resource)this, p, m3.createTypedLiteral(o));
        return this;
    }

    @Override
    public Resource addLiteral(Property p, float o) {
        ModelCom m3 = this.mustHaveModel();
        m3.add((Resource)this, p, m3.createTypedLiteral(o));
        return this;
    }

    @Override
    public Resource addProperty(Property p, String o) {
        this.mustHaveModel().add((Resource)this, p, o);
        return this;
    }

    @Override
    public Resource addProperty(Property p, String o, String l) {
        this.mustHaveModel().add((Resource)this, p, o, l);
        return this;
    }

    @Override
    public Resource addProperty(Property p, String lexicalForm, RDFDatatype datatype) {
        this.mustHaveModel().add((Resource)this, p, lexicalForm, datatype);
        return this;
    }

    @Override
    public Resource addLiteral(Property p, Object o) {
        ModelCom m3 = this.mustHaveModel();
        m3.add((Resource)this, p, m3.createTypedLiteral(o));
        return this;
    }

    @Override
    public Resource addLiteral(Property p, Literal o) {
        this.mustHaveModel().add((Resource)this, p, o);
        return this;
    }

    @Override
    public Resource addProperty(Property p, RDFNode o) {
        this.mustHaveModel().add((Resource)this, p, o);
        return this;
    }

    @Override
    public boolean hasProperty(Property p) {
        return this.mustHaveModel().contains(this, p);
    }

    @Override
    public boolean hasLiteral(Property p, boolean o) {
        ModelCom m3 = this.mustHaveModel();
        return m3.contains((Resource)this, p, m3.createTypedLiteral(o));
    }

    @Override
    public boolean hasLiteral(Property p, long o) {
        ModelCom m3 = this.mustHaveModel();
        return m3.contains((Resource)this, p, m3.createTypedLiteral(o));
    }

    @Override
    public boolean hasLiteral(Property p, char o) {
        ModelCom m3 = this.mustHaveModel();
        return m3.contains((Resource)this, p, m3.createTypedLiteral(o));
    }

    @Override
    public boolean hasLiteral(Property p, double o) {
        ModelCom m3 = this.mustHaveModel();
        return m3.contains((Resource)this, p, m3.createTypedLiteral(o));
    }

    @Override
    public boolean hasLiteral(Property p, float o) {
        ModelCom m3 = this.mustHaveModel();
        return m3.contains((Resource)this, p, m3.createTypedLiteral(o));
    }

    @Override
    public boolean hasProperty(Property p, String o) {
        return this.mustHaveModel().contains((Resource)this, p, o);
    }

    @Override
    public boolean hasProperty(Property p, String o, String l) {
        return this.mustHaveModel().contains(this, p, o, l);
    }

    @Override
    public boolean hasLiteral(Property p, Object o) {
        ModelCom m3 = this.mustHaveModel();
        return m3.contains((Resource)this, p, m3.createTypedLiteral(o));
    }

    @Override
    public boolean hasProperty(Property p, RDFNode o) {
        return this.mustHaveModel().contains((Resource)this, p, o);
    }

    @Override
    public Resource removeProperties() {
        this.removeAll(null);
        return this;
    }

    @Override
    public Resource removeAll(Property p) {
        this.mustHaveModel().removeAll(this, p, null);
        return this;
    }

    @Override
    public Resource begin() {
        this.mustHaveModel().begin();
        return this;
    }

    @Override
    public Resource abort() {
        this.mustHaveModel().abort();
        return this;
    }

    @Override
    public Resource commit() {
        this.mustHaveModel().commit();
        return this;
    }

    @Override
    public Model getModel() {
        return (Model)((Object)this.getGraph());
    }

    protected ModelCom getModelCom() {
        return (ModelCom)this.getGraph();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource getPropertyResourceValue(Property p) {
        try (StmtIterator it = this.listProperties(p);){
            while (it.hasNext()) {
                RDFNode n = ((Statement)it.next()).getObject();
                if (!n.isResource()) continue;
                Resource resource = (Resource)n;
                return resource;
            }
            Resource resource = null;
            return resource;
        }
    }
}

