/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.conformance.core.collections;

import io.restassured.http.Method;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.opengis.cite.ogcapifeatures10.conformance.core.collections.AbstractFeatures;
import org.opengis.cite.ogcapifeatures10.openapi3.OpenApiUtils;
import org.opengis.cite.ogcapifeatures10.util.JsonUtils;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class FeaturesErrorConditions
extends AbstractFeatures {
    public static final String INVALID_QUERY_PARAM_VALUE = "unlimited";
    public static final String UNKNOWN_QUERY_PARAM = "unknownQueryParameter";

    @DataProvider(name="collectionItemUris")
    public Iterator<Object[]> collectionItemUris(ITestContext testContext) {
        ArrayList<Object[]> collectionsData = new ArrayList<Object[]>();
        for (Map collection : this.collections) {
            collectionsData.add(new Object[]{collection});
        }
        return collectionsData.iterator();
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items - Error Conditions, Abstract Test 13/20 (Requirement /req/core/query-param-invalid)", groups={"featuresBase"}, dataProvider="collectionItemUris", dependsOnGroups={"collections"}, alwaysRun=true)
    public void validateFeaturesOperation_QueryParamInvalid(Map<String, Object> collection) {
        String collectionId = (String)collection.get("id");
        String featuresUrl = JsonUtils.findFeaturesUrlForGeoJson(this.rootUri, collection);
        if (featuresUrl == null) {
            throw new SkipException("Could not find url for collection with id " + collectionId + " supporting GeoJson (type " + "application/geo+json" + ")");
        }
        Response response = (Response)this.init().baseUri(featuresUrl).accept("application/geo+json").param("limit", INVALID_QUERY_PARAM_VALUE).when().request(Method.GET);
        ((ValidatableResponse)response.then()).statusCode(400);
    }

    @Test(description="Implements A.2.7. Features {root}/collections/{collectionId}/items - Error Conditions, Abstract Test 13/21 (Requirement /req/core/query-param-unknown)", groups={"featuresBase"}, dataProvider="collectionItemUris", dependsOnGroups={"collections"}, alwaysRun=true)
    public void validateFeaturesOperation_QueryParamUnknown(Map<String, Object> collection) {
        String collectionId = (String)collection.get("id");
        boolean freeFormParameterSupported = OpenApiUtils.isFreeFormParameterSupportedForCollection(this.getApiModel(), this.iut, collectionId);
        if (freeFormParameterSupported) {
            throw new SkipException("Free-form parameters are supported for collection with id " + collectionId);
        }
        String featuresUrl = JsonUtils.findFeaturesUrlForGeoJson(this.rootUri, collection);
        if (featuresUrl == null) {
            throw new SkipException("Could not find url for collection with id " + collectionId + " supporting GeoJson (type " + "application/geo+json" + ")");
        }
        String queryParam = this.createRandomQueryParam();
        boolean parameterSupportedForCollection = OpenApiUtils.isParameterSupportedForCollection(this.getApiModel(), this.iut, collectionId, queryParam);
        if (parameterSupportedForCollection) {
            throw new SkipException("Parameters " + queryParam + " is supported for collection with id " + collectionId);
        }
        Response response = (Response)this.init().baseUri(featuresUrl).accept("application/geo+json").param(queryParam, 1).when().request(Method.GET);
        ((ValidatableResponse)response.then()).statusCode(400);
    }

    private String createRandomQueryParam() {
        Random r = new Random();
        int suffix = 10000 + r.nextInt(10000);
        return UNKNOWN_QUERY_PARAM + suffix;
    }
}

