/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.ogcapifeatures10.util;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.proj4j.CRSFactory;
import org.locationtech.proj4j.CoordinateTransform;
import org.locationtech.proj4j.CoordinateTransformFactory;
import org.locationtech.proj4j.ProjCoordinate;
import org.opengis.cite.ogcapifeatures10.conformance.crs.query.crs.CoordinateSystem;
import org.opengis.cite.ogcapifeatures10.util.BBox;

public class GeometryTransformer {
    private final GeometryFactory geometryFactory = new GeometryFactory();
    private final CoordinateTransform transformer;
    private final CoordinateSystem srcCrs;
    private final CoordinateSystem targetCrs;

    public GeometryTransformer(CoordinateSystem srcCrs, CoordinateSystem targetCrs) {
        this.srcCrs = srcCrs;
        this.targetCrs = targetCrs;
        CoordinateTransformFactory coordinateTransformFactory = new CoordinateTransformFactory();
        CRSFactory crsFactory = new CRSFactory();
        this.transformer = coordinateTransformFactory.createTransform(crsFactory.createFromName(srcCrs.getCodeWithAuthority()), crsFactory.createFromName(targetCrs.getCodeWithAuthority()));
    }

    public BBox transform(BBox bbox) {
        if (this.srcCrs.equals(this.targetCrs)) {
            return bbox;
        }
        Coordinate min2 = new Coordinate(bbox.getMinX(), bbox.getMinY());
        Coordinate max = new Coordinate(bbox.getMaxX(), bbox.getMaxY());
        Coordinate transformedMin = this.transform(min2);
        Coordinate transformedMax = this.transform(max);
        return new BBox(transformedMin.x, transformedMin.y, transformedMax.x, transformedMax.y, this.targetCrs);
    }

    public Geometry transform(Geometry geometryToTransform) {
        if (geometryToTransform == null) {
            return null;
        }
        if (geometryToTransform instanceof Point) {
            return this.transform((Point)geometryToTransform);
        }
        if (geometryToTransform instanceof Polygon) {
            return this.transform((Polygon)geometryToTransform);
        }
        if (geometryToTransform instanceof LineString) {
            return this.transform((LineString)geometryToTransform);
        }
        if (geometryToTransform instanceof GeometryCollection) {
            return this.transform((GeometryCollection)geometryToTransform);
        }
        throw new IllegalArgumentException("Unsupported geometry type: " + geometryToTransform.getClass());
    }

    public Point transform(Point geometryToTransform) {
        Coordinate coordinate = geometryToTransform.getCoordinate();
        Coordinate transformedCoordinate = this.transform(coordinate);
        return this.geometryFactory.createPoint(transformedCoordinate);
    }

    public LineString transform(LineString geometryToTransform) {
        Coordinate[] coordinates = geometryToTransform.getCoordinates();
        Coordinate[] transformedCoordinates = this.transform(coordinates);
        return this.geometryFactory.createLineString(transformedCoordinates);
    }

    public Polygon transform(Polygon geometryToTransform) {
        Coordinate[] coordinatesExteriorRing = geometryToTransform.getExteriorRing().getCoordinates();
        Coordinate[] transformedCoordinatesExteriorRing = this.transform(coordinatesExteriorRing);
        LinearRing exteriorRing = this.geometryFactory.createLinearRing(transformedCoordinatesExteriorRing);
        LinearRing[] interiorRings = new LinearRing[geometryToTransform.getNumInteriorRing()];
        for (int numInteriorRing = 0; numInteriorRing < geometryToTransform.getNumInteriorRing(); ++numInteriorRing) {
            LinearRing interiorRingN = geometryToTransform.getInteriorRingN(numInteriorRing);
            Coordinate[] transformedCoordinatesInteriorRingN = this.transform(interiorRingN.getCoordinates());
            interiorRings[numInteriorRing] = this.geometryFactory.createLinearRing(transformedCoordinatesInteriorRingN);
        }
        return this.geometryFactory.createPolygon(exteriorRing, interiorRings);
    }

    public Geometry transform(GeometryCollection geometryToTransform) {
        if (geometryToTransform instanceof MultiPoint) {
            return this.transform((MultiPoint)geometryToTransform);
        }
        if (geometryToTransform instanceof MultiLineString) {
            return this.transform((MultiLineString)geometryToTransform);
        }
        if (geometryToTransform instanceof MultiPolygon) {
            return this.transform((MultiPolygon)geometryToTransform);
        }
        throw new IllegalArgumentException("Unsupported geometry type: " + geometryToTransform.getClass());
    }

    public MultiPoint transform(MultiPoint geometryToTransform) {
        Point[] points = new Point[geometryToTransform.getNumGeometries()];
        for (int numGeometry = 0; numGeometry < geometryToTransform.getNumGeometries(); ++numGeometry) {
            Geometry geometryN = geometryToTransform.getGeometryN(numGeometry);
            points[numGeometry] = this.transform((Point)geometryN);
        }
        return this.geometryFactory.createMultiPoint(points);
    }

    public MultiLineString transform(MultiLineString geometryToTransform) {
        LineString[] lineStrings = new LineString[geometryToTransform.getNumGeometries()];
        for (int numGeometry = 0; numGeometry < geometryToTransform.getNumGeometries(); ++numGeometry) {
            Geometry geometryN = geometryToTransform.getGeometryN(numGeometry);
            lineStrings[numGeometry] = this.transform((LineString)geometryN);
        }
        return this.geometryFactory.createMultiLineString(lineStrings);
    }

    public MultiPolygon transform(MultiPolygon geometryToTransform) {
        Polygon[] polygons = new Polygon[geometryToTransform.getNumGeometries()];
        for (int numGeometry = 0; numGeometry < geometryToTransform.getNumGeometries(); ++numGeometry) {
            Geometry geometryN = geometryToTransform.getGeometryN(numGeometry);
            polygons[numGeometry] = this.transform((Polygon)geometryN);
        }
        return this.geometryFactory.createMultiPolygon(polygons);
    }

    private Coordinate[] transform(Coordinate[] coordinates) {
        List<Coordinate> transformedCoordinates = Arrays.stream(coordinates).map(coord -> this.transform((Coordinate)coord)).collect(Collectors.toList());
        return transformedCoordinates.toArray(new Coordinate[transformedCoordinates.size()]);
    }

    private Coordinate transform(Coordinate coord) {
        ProjCoordinate srcCoordinate = new ProjCoordinate(coord.x, coord.y, coord.z);
        ProjCoordinate targetCoordinate = new ProjCoordinate();
        this.transformer.transform(srcCoordinate, targetCoordinate);
        return new Coordinate(targetCoordinate.x, targetCoordinate.y, targetCoordinate.z);
    }
}

